﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'smmsg.pas' rev: 37.00 (Windows)

#ifndef smmsgHPP
#define smmsgHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <Winapi.ActiveX.hpp>
#include <System.SysUtils.hpp>
#include <SMMSGTags.hpp>
#include <System.Variants.hpp>
#include <Winapi.Windows.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smmsg
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TMSGProperty;
class DELPHICLASS TMSGPropertyCompressedRTF;
struct TPropertyStreamHeader;
struct TPropertyStreamEmbeddedHeader;
struct TPropertyStreamAttachmentHeader;
struct TPropertyStreamRecipientHeader;
class DELPHICLASS TMSGPropertyWithHeader;
class DELPHICLASS TMSGPropertyTopLevel;
class DELPHICLASS TMSGPropertyEmbeddedMessage;
class DELPHICLASS TMSGPropertyAttachment;
class DELPHICLASS TMSGPropertyRecipient;
class DELPHICLASS TMSGProperties;
class DELPHICLASS TSMMessage;
class DELPHICLASS TSMMSGFile;
class DELPHICLASS TSMTNEFFile;
class DELPHICLASS TSMEMLFile;
class DELPHICLASS TSMMHTFile;
//-- type declarations -------------------------------------------------------
typedef System::UnicodeString TSMMAbout;

enum DECLSPEC_DENUM TMSGPropertyCategory : unsigned char { mpcGeneral, mpcEnvelope, mpcRecipient, mpcNonTransmittable, mpcMessage, mpcTransportEnvelope, mpcTransportRecipient, mpcUserNonTransmittable, mpcProviderNonTransmittable, mpcMessageClassContent, mpcMessageClassNonTransmittable, mpcUserProperty, mpcMessageStore, mpcFolderABContainer, mpcAttachment, mpcAddressBook, mpcUser, mpcDistributionList, mpcProfile, mpcStatus };

enum DECLSPEC_DENUM TMSGAttachmentKind : unsigned char { akUnknown, akAttachment, akMessage, akOLEObject };

class PASCALIMPLEMENTATION TMSGProperty : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	Smmsgtags::MSG_DWORD FTagID;
	System::Variant FValue;
	int FValueLength;
	Smmsgtags::MSG_DWORD FReserved1;
	TMSGProperties* FSubProperties;
	void __fastcall SetSubProperties(TMSGProperties* Value);
	System::WideString __fastcall GetAsString();
	
protected:
	Smmsgtags::MSG_DWORD __fastcall PureTag();
	
public:
	__fastcall virtual TMSGProperty(System::Classes::TCollection* Collection);
	__fastcall virtual ~TMSGProperty();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	TMSGPropertyCategory __fastcall GetCategory();
	System::UnicodeString __fastcall GetName(bool IncludeCaption, bool MAPIAlways);
	int __fastcall PropertyType();
	void __fastcall ApplyValueTag(Smmsgtags::MSG_DWORD ATagID, System::Classes::TStream* Stream, int brLen);
	virtual void __fastcall ApplyValue(System::Classes::TStream* Stream, int brLen);
	void __fastcall ApplyGeneralProperty(System::Classes::TStream* Stream, Smmsgtags::MSG_DWORD AID, Smmsgtags::MSG_DWORD ATypeID);
	System::UnicodeString __fastcall GetAttachmentFileName(int Index);
	System::UnicodeString __fastcall GetAttachmentName(int Index);
	int __fastcall GetAttachmentFileSize(int Index);
	TMSGAttachmentKind __fastcall AttachmentKind();
	bool __fastcall AttachmentIsEmbeddedMessage();
	__property int ValueLength = {read=FValueLength, write=FValueLength, nodefault};
	__property System::WideString AsString = {read=GetAsString};
	
__published:
	__property TMSGPropertyCategory Category = {read=GetCategory, nodefault};
	__property Smmsgtags::MSG_DWORD TagID = {read=FTagID, write=FTagID, nodefault};
	__property System::Variant Value = {read=FValue, write=FValue};
	__property Smmsgtags::MSG_DWORD Reserved1 = {read=FReserved1, write=FReserved1, nodefault};
	__property TMSGProperties* SubProperties = {read=FSubProperties, write=SetSubProperties};
};


enum DECLSPEC_DENUM TMSGCompressedRTFValueType : unsigned char { csRaw, csLZFU, csMELA };

class PASCALIMPLEMENTATION TMSGPropertyCompressedRTF : public TMSGProperty
{
	typedef TMSGProperty inherited;
	
private:
	TMSGCompressedRTFValueType ValueType;
	
protected:
	unsigned __fastcall CalculateCRC32ForStream(System::Classes::TStream* AStream);
	unsigned __fastcall CalculateCRC32ForString(const System::RawByteString Data);
	System::WideString __fastcall ProcessRTFCompressed(System::Classes::TStream* Stream, int &ValueSize);
	int __fastcall CompressRTFValue(System::Variant &AValue);
	System::UnicodeString __fastcall ProcessRTFCompressedLZFU(System::Classes::TStream* Stream, int &ValueSize);
	int __fastcall CompressRTFValueLZFU(const System::Variant &AValue, bool ToCompress, System::Classes::TStream* Destination);
	
public:
	virtual void __fastcall ApplyValue(System::Classes::TStream* Stream, int brLen);
public:
	/* TMSGProperty.Create */ inline __fastcall virtual TMSGPropertyCompressedRTF(System::Classes::TCollection* Collection) : TMSGProperty(Collection) { }
	/* TMSGProperty.Destroy */ inline __fastcall virtual ~TMSGPropertyCompressedRTF() { }
	
};


#pragma pack(push,1)
struct DECLSPEC_DRECORD TPropertyStreamHeader
{
public:
	System::StaticArray<System::Byte, 8> Reserved1;
	Smmsgtags::MSG_DWORD NextRecipientID;
	Smmsgtags::MSG_DWORD NextAttachmentID;
	Smmsgtags::MSG_DWORD RecipientCount;
	Smmsgtags::MSG_DWORD AttachmentCount;
	System::StaticArray<System::Byte, 8> Reserved2;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TPropertyStreamEmbeddedHeader
{
public:
	System::StaticArray<System::Byte, 8> Reserved1;
	Smmsgtags::MSG_DWORD NextRecipientID;
	Smmsgtags::MSG_DWORD NextAttachmentID;
	Smmsgtags::MSG_DWORD RecipientCount;
	Smmsgtags::MSG_DWORD AttachmentCount;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TPropertyStreamAttachmentHeader
{
public:
	System::StaticArray<System::Byte, 8> Reserved1;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TPropertyStreamRecipientHeader
{
public:
	System::StaticArray<System::Byte, 8> Reserved1;
};
#pragma pack(pop)


class PASCALIMPLEMENTATION TMSGPropertyWithHeader : public TMSGProperty
{
	typedef TMSGProperty inherited;
	
public:
	/* TMSGProperty.Create */ inline __fastcall virtual TMSGPropertyWithHeader(System::Classes::TCollection* Collection) : TMSGProperty(Collection) { }
	/* TMSGProperty.Destroy */ inline __fastcall virtual ~TMSGPropertyWithHeader() { }
	
};


class PASCALIMPLEMENTATION TMSGPropertyTopLevel : public TMSGPropertyWithHeader
{
	typedef TMSGPropertyWithHeader inherited;
	
private:
	TPropertyStreamHeader FHeader;
	
protected:
	int __fastcall GetHeaderSize();
	
public:
	__property int HeaderSize = {read=GetHeaderSize, nodefault};
	__property TPropertyStreamHeader Header = {read=FHeader, write=FHeader};
public:
	/* TMSGProperty.Create */ inline __fastcall virtual TMSGPropertyTopLevel(System::Classes::TCollection* Collection) : TMSGPropertyWithHeader(Collection) { }
	/* TMSGProperty.Destroy */ inline __fastcall virtual ~TMSGPropertyTopLevel() { }
	
};


class PASCALIMPLEMENTATION TMSGPropertyEmbeddedMessage : public TMSGPropertyWithHeader
{
	typedef TMSGPropertyWithHeader inherited;
	
private:
	TPropertyStreamEmbeddedHeader FHeader;
	
protected:
	int __fastcall GetHeaderSize();
	
public:
	__property int HeaderSize = {read=GetHeaderSize, nodefault};
	__property TPropertyStreamEmbeddedHeader Header = {read=FHeader, write=FHeader};
public:
	/* TMSGProperty.Create */ inline __fastcall virtual TMSGPropertyEmbeddedMessage(System::Classes::TCollection* Collection) : TMSGPropertyWithHeader(Collection) { }
	/* TMSGProperty.Destroy */ inline __fastcall virtual ~TMSGPropertyEmbeddedMessage() { }
	
};


class PASCALIMPLEMENTATION TMSGPropertyAttachment : public TMSGPropertyWithHeader
{
	typedef TMSGPropertyWithHeader inherited;
	
private:
	TPropertyStreamAttachmentHeader FHeader;
	
protected:
	int __fastcall GetHeaderSize();
	
public:
	__property int HeaderSize = {read=GetHeaderSize, nodefault};
	__property TPropertyStreamAttachmentHeader Header = {read=FHeader, write=FHeader};
public:
	/* TMSGProperty.Create */ inline __fastcall virtual TMSGPropertyAttachment(System::Classes::TCollection* Collection) : TMSGPropertyWithHeader(Collection) { }
	/* TMSGProperty.Destroy */ inline __fastcall virtual ~TMSGPropertyAttachment() { }
	
};


class PASCALIMPLEMENTATION TMSGPropertyRecipient : public TMSGPropertyWithHeader
{
	typedef TMSGPropertyWithHeader inherited;
	
private:
	TPropertyStreamRecipientHeader FHeader;
	
protected:
	int __fastcall GetHeaderSize();
	
public:
	__property int HeaderSize = {read=GetHeaderSize, nodefault};
	__property TPropertyStreamRecipientHeader Header = {read=FHeader, write=FHeader};
public:
	/* TMSGProperty.Create */ inline __fastcall virtual TMSGPropertyRecipient(System::Classes::TCollection* Collection) : TMSGPropertyWithHeader(Collection) { }
	/* TMSGProperty.Destroy */ inline __fastcall virtual ~TMSGPropertyRecipient() { }
	
};


enum DECLSPEC_DENUM TSMMessageFormat : unsigned char { mfUnknown, mfText, mfRTF, mfHTML };

enum DECLSPEC_DENUM TSMMessagePriority : unsigned char { mpLowest, mpLow, mpNormal, mpHigh, mpHighest };

class PASCALIMPLEMENTATION TMSGProperties : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
public:
	TMSGProperty* operator[](int Index) { return this->Items[Index]; }
	
private:
	System::Classes::TComponent* FOwner;
	TSMMessageFormat FMessageFormat;
	TMSGProperty* __fastcall GetProperty(int Index);
	void __fastcall SetProperty(int Index, TMSGProperty* Value);
	
protected:
	TMSGProperty* FParentProperty;
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	System::WideString __fastcall ExpandRecipients(const System::WideString AValue);
	System::WideString __fastcall GetRecipientDetails(const System::WideString AValue);
	
public:
	__fastcall TMSGProperties(System::Classes::TComponent* AOwner);
	HIDESBASE TMSGProperty* __fastcall Add();
	TMSGProperty* __fastcall AddTypedValue(Smmsgtags::MSG_DWORD ATagID, const System::Variant &AValue);
	TMSGProperty* __fastcall AddAttachmentFile(const System::UnicodeString AFileName);
	HIDESBASE void __fastcall Clear();
	TMSGProperty* __fastcall GetPropertyByTag(Smmsgtags::MSG_DWORD ATagID, bool WithoutType, bool IncludeDetails);
	System::WideString __fastcall GetPropertyAsString(Smmsgtags::MSG_DWORD ATagID, bool WithoutType, bool IncludeDetails);
	void __fastcall SaveToMsgFile(const System::UnicodeString AFileName, bool SaveAllProperties);
	void __fastcall SaveToEMLFile(const System::UnicodeString AFileName, bool SaveAllProperties);
	void __fastcall SaveToEMLStream(System::Classes::TStream* AStream, bool SaveAllProperties);
	void __fastcall SaveToTextFile(const System::UnicodeString AFileName, bool SaveAllProperties);
	void __fastcall SaveToTextStream(System::Classes::TStream* AStream, bool SaveAllProperties);
	void __fastcall SaveToHTMLFile(const System::UnicodeString AFileName, bool SaveAllProperties);
	void __fastcall SaveToHTMLStream(System::Classes::TStream* AStream, bool SaveAllProperties);
	void __fastcall SaveToXMLFile(const System::UnicodeString AFileName, bool SaveAllProperties);
	void __fastcall SaveToXMLStream(System::Classes::TStream* AStream, bool SaveAllProperties);
	bool __fastcall IsMainProperties();
	System::WideString __fastcall GetSubject();
	System::WideString __fastcall GetBody();
	System::WideString __fastcall GetHTMLBody();
	System::WideString __fastcall GetRTFBody();
	System::WideString __fastcall GetSenderAddress();
	System::WideString __fastcall GetSenderName();
	System::WideString __fastcall GetRecipientAddress();
	System::WideString __fastcall GetRecipientName();
	System::WideString __fastcall GetCC();
	System::WideString __fastcall GetBCC();
	System::WideString __fastcall GetTransportHeader();
	System::WideString __fastcall GetMessageID();
	System::TDateTime __fastcall GetMessageDate();
	TSMMessagePriority __fastcall GetPriority();
	int __fastcall GetCodePage();
	System::UnicodeString __fastcall GetHTMLCharset();
	TMSGProperty* __fastcall GetAttachment(int Index);
	int __fastcall GetAttachmentCount();
	void __fastcall SaveAttachmentToStream(int Index, System::Classes::TStream* Stream);
	void __fastcall SaveAttachmentToFile(int Index, const System::UnicodeString AFileName);
	__property System::Classes::TComponent* PropOwner = {read=FOwner};
	__property TMSGProperty* Items[int Index] = {read=GetProperty, write=SetProperty/*, default*/};
	__property TSMMessageFormat MessageFormat = {read=FMessageFormat, nodefault};
	__property TMSGProperty* Attachment[int Index] = {read=GetAttachment};
	__property int AttachmentCount = {read=GetAttachmentCount, nodefault};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TMSGProperties() { }
	
};


class PASCALIMPLEMENTATION TSMMessage : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	TSMMAbout FAbout;
	TMSGProperties* FProperties;
	TMSGProperties* __fastcall GetProperties();
	void __fastcall SetProperties(TMSGProperties* Value);
	void __fastcall SetAbout(const TSMMAbout Value);
	System::WideString __fastcall GetSubject();
	System::WideString __fastcall GetBody();
	System::WideString __fastcall GetHTMLBody();
	System::WideString __fastcall GetRTFBody();
	System::WideString __fastcall GetSenderAddress();
	System::WideString __fastcall GetSenderName();
	System::WideString __fastcall GetRecipientAddress();
	System::WideString __fastcall GetRecipientName();
	System::WideString __fastcall GetCC();
	System::WideString __fastcall GetBCC();
	System::WideString __fastcall GetTransportHeader();
	System::WideString __fastcall GetMessageID();
	System::TDateTime __fastcall GetMessageDate();
	TSMMessagePriority __fastcall GetPriority();
	
protected:
	virtual void __fastcall ClearInternalLists();
	
public:
	__fastcall virtual TSMMessage(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMMessage();
	virtual void __fastcall LoadFromStream(System::Classes::TStream* Stream);
	virtual void __fastcall LoadFromFile(const System::UnicodeString AFileName);
	bool __fastcall MessageFlagValue(System::Word Flag);
	void __fastcall SaveToMsgFile(const System::UnicodeString AFileName, bool SaveAllProperties);
	void __fastcall SaveToEMLFile(const System::UnicodeString AFileName, bool SaveAllProperties);
	void __fastcall SaveToEMLStream(System::Classes::TStream* AStream, bool SaveAllProperties);
	void __fastcall SaveToTextFile(const System::UnicodeString AFileName, bool SaveAllProperties);
	void __fastcall SaveToTextStream(System::Classes::TStream* AStream, bool SaveAllProperties);
	void __fastcall SaveToHTMLFile(const System::UnicodeString AFileName, bool SaveAllProperties);
	void __fastcall SaveToHTMLStream(System::Classes::TStream* AStream, bool SaveAllProperties);
	void __fastcall SaveToXMLFile(const System::UnicodeString AFileName, bool SaveAllProperties);
	void __fastcall SaveToXMLStream(System::Classes::TStream* AStream, bool SaveAllProperties);
	System::UnicodeString __fastcall GetHTMLCharset();
	int __fastcall GetCodePageFromString(const System::UnicodeString Value);
	__classmethod System::UnicodeString __fastcall ConvertRTF2HTML(const System::UnicodeString rtf);
	__property System::WideString Subject = {read=GetSubject};
	__property System::WideString Body = {read=GetBody};
	__property System::WideString HTMLBody = {read=GetHTMLBody};
	__property System::WideString RTFBody = {read=GetRTFBody};
	__property System::WideString SenderAddress = {read=GetSenderAddress};
	__property System::WideString SenderName = {read=GetSenderName};
	__property System::WideString RecipientAddress = {read=GetRecipientAddress};
	__property System::WideString RecipientName = {read=GetRecipientName};
	__property System::WideString CC = {read=GetCC};
	__property System::WideString BCC = {read=GetBCC};
	__property System::WideString TransportHeader = {read=GetTransportHeader};
	__property System::WideString MessageID = {read=GetMessageID};
	__property System::TDateTime MessageDate = {read=GetMessageDate};
	__property TSMMessagePriority Priority = {read=GetPriority, nodefault};
	
__published:
	__property TSMMAbout About = {read=FAbout, write=SetAbout, stored=false};
	__property TMSGProperties* Properties = {read=GetProperties, write=SetProperties};
};


typedef void __fastcall (__closure *TMSGDecompressRTFEvent)(System::TObject* Sender, System::Classes::TStream* Stream, int ValueSize, System::UnicodeString &Result);

typedef void __fastcall (__closure *TSMMSGConvertCodepage)(System::TObject* Sender, const System::UnicodeString ACodePage, System::UnicodeString &Value);

class PASCALIMPLEMENTATION TSMMSGFile : public TSMMessage
{
	typedef TSMMessage inherited;
	
private:
	TMSGDecompressRTFEvent FOnDecompressRTF;
	TSMMSGConvertCodepage FOnConvertCodepage;
	
protected:
	void __fastcall LoadIStorage(_di_IStorage Storage, TMSGProperties* AProperties);
	
public:
	virtual void __fastcall LoadFromStream(System::Classes::TStream* Stream);
	virtual void __fastcall LoadFromFile(const System::UnicodeString AFileName);
	
__published:
	__property TMSGDecompressRTFEvent OnDecompressRTF = {read=FOnDecompressRTF, write=FOnDecompressRTF};
	__property TSMMSGConvertCodepage OnConvertCodepage = {read=FOnConvertCodepage, write=FOnConvertCodepage};
public:
	/* TSMMessage.Create */ inline __fastcall virtual TSMMSGFile(System::Classes::TComponent* AOwner) : TSMMessage(AOwner) { }
	/* TSMMessage.Destroy */ inline __fastcall virtual ~TSMMSGFile() { }
	
};


class PASCALIMPLEMENTATION TSMTNEFFile : public TSMMessage
{
	typedef TSMMessage inherited;
	
private:
	void __fastcall ReadTNEFProp(System::Classes::TStream* Stream, TMSGProperties* AProperties);
	
protected:
	void __fastcall ReadMessage(System::Classes::TStream* Stream);
	void __fastcall ReadAttachment(System::Classes::TStream* Stream);
	void __fastcall ReadRecipientTable(System::Classes::TStream* Stream);
	
public:
	virtual void __fastcall LoadFromStream(System::Classes::TStream* Stream);
	virtual void __fastcall LoadFromFile(const System::UnicodeString AFileName);
public:
	/* TSMMessage.Create */ inline __fastcall virtual TSMTNEFFile(System::Classes::TComponent* AOwner) : TSMMessage(AOwner) { }
	/* TSMMessage.Destroy */ inline __fastcall virtual ~TSMTNEFFile() { }
	
};


typedef void __fastcall (*TSMEMLTagCallback)(System::TObject* msg, const System::UnicodeString ATagName, const System::UnicodeString AFullLine, int ATagValue, int AFullLineLen, bool &ADone);

class PASCALIMPLEMENTATION TSMEMLFile : public TSMMessage
{
	typedef TSMMessage inherited;
	
private:
	System::Classes::TStrings* Feml;
	System::UnicodeString FTransferEncoding;
	System::UnicodeString FCodepage;
	TSMMSGConvertCodepage FOnConvertCodepage;
	System::UnicodeString FCurrentBoundary;
	System::Classes::TStrings* FCurrentBoundaries;
	TMSGProperties* FCurrentProperties;
	TMSGProperty* __fastcall AddNewProp(int ATagID, int AValueLen, const System::Variant &AValue);
	System::UnicodeString __fastcall GetNormalHeader(int &Index);
	
protected:
	virtual void __fastcall ClearInternalLists();
	System::WideString __fastcall DecodeValueByCharset(const System::UnicodeString s);
	System::WideString __fastcall DecodeValue(const System::RawByteString s, System::UnicodeString ATransferEncoding);
	bool __fastcall ProcessEMLTag(const System::UnicodeString ATagName, const System::UnicodeString AFullLine, Smmsgtags::MSG_DWORD ATagValue, Smmsgtags::MSG_DWORD AFullLineLen, TSMEMLTagCallback ACallBack);
	void __fastcall ProcessHeader(int &intCurLine, TMSGProperties* AProperties);
	bool __fastcall IsBoundaryEnd(const System::UnicodeString ALine, const System::UnicodeString ABoundary);
	void __fastcall ProcessBoundary(System::UnicodeString ABoundary, int &intCurLine, TMSGProperties* AProperties);
	void __fastcall ProcessPart(int &intCurLine, TMSGProperties* AProperties);
	
public:
	__fastcall virtual TSMEMLFile(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMEMLFile();
	virtual void __fastcall LoadFromStream(System::Classes::TStream* Stream);
	virtual void __fastcall LoadFromFile(const System::UnicodeString AFileName);
	__property System::Classes::TStrings* OriginalEML = {read=Feml};
	
__published:
	__property TSMMSGConvertCodepage OnConvertCodepage = {read=FOnConvertCodepage, write=FOnConvertCodepage};
};


class PASCALIMPLEMENTATION TSMMHTFile : public TSMEMLFile
{
	typedef TSMEMLFile inherited;
	
public:
	/* TSMEMLFile.Create */ inline __fastcall virtual TSMMHTFile(System::Classes::TComponent* AOwner) : TSMEMLFile(AOwner) { }
	/* TSMEMLFile.Destroy */ inline __fastcall virtual ~TSMMHTFile() { }
	
};


//-- var, const, procedure ---------------------------------------------------
#define SMMSGVersion L"1.52b"
extern DELPHI_PACKAGE void __fastcall AboutSMMsg(void);
}	/* namespace Smmsg */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMMSG)
using namespace Smmsg;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// smmsgHPP
