﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SME2DBF.pas' rev: 37.00 (Windows)

#ifndef SME2DBFHPP
#define SME2DBFHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Data.DB.hpp>
#include <ExportDS.hpp>
#include <SMEEngine.hpp>
#include <SME2Cell.hpp>
#include <System.Variants.hpp>
#include <System.UITypes.hpp>

//-- user supplied -----------------------------------------------------------

namespace Sme2dbf
{
//-- forward type declarations -----------------------------------------------
struct TDBFField;
struct TDBFField7;
struct TDBFHeader;
struct TSMEDBTHeader;
struct TSMEFPTHeader;
struct TSMEBlockHeader;
class DELPHICLASS TSMExportToDBF;
//-- type declarations -------------------------------------------------------
#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBFField
{
public:
	System::StaticArray<char, 11> FieldName;
	char FieldType;
	System::LongInt Address;
	System::Byte Length;
	System::Byte Decimals;
	System::StaticArray<System::Byte, 2> Reserved1;
	System::Byte WordAreaID;
	System::Word MultiUserDBase;
	System::Byte SetFields;
	System::StaticArray<System::Byte, 8> Reserved2;
	System::Byte MDXFlag;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBFField7
{
public:
	System::StaticArray<char, 32> FieldName;
	char FieldType;
	System::Byte Length;
	System::Byte Decimals;
	System::StaticArray<System::Byte, 2> Reserved1;
	System::Byte MDXFlag;
	unsigned Reserved2;
	unsigned NextAutoInc;
	System::Word Reserved3;
};
#pragma pack(pop)


typedef System::StaticArray<TDBFField, 4096> TDBFFields;

enum DECLSPEC_DENUM TDBFVersion : unsigned char { dBase3, dBase3Memo, dBase3Plus, dBase3PlusMemo, FoxPro, FoxProMemo, dBase4, dBase4Memo, VFP3, dBase5, dBase7, dBase7Memo, FoxBASE1, FoxBASE2, VFP3AutoIncrement, HyperSix, VFP3Binary, dBase4SQL, dBase4SQLSys, FoxPro2 };

enum DECLSPEC_DENUM TDBFMemoType : unsigned char { dmDBT, dmFPT, dmSMT };

#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBFHeader
{
public:
	System::Byte VersionNumber;
	System::Byte LastUpdateYear;
	System::Byte LastUpdateMonth;
	System::Byte LastUpdateDay;
	System::LongInt NumberOfRecords;
	System::Word HeaderSize;
	System::Word RecordSize;
	System::StaticArray<char, 2> Reserve1;
	System::Byte IncompleteTransaction;
	System::Byte Encrypted;
	System::StaticArray<char, 12> Reserved;
	System::Byte MDXIsExist;
	System::Byte LanguageID;
	System::StaticArray<char, 2> Reserved2;
	System::LongInt NumberOfFields;
	TDBFFields Fields;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TSMEDBTHeader
{
public:
	System::LongInt NextBlock;
	System::StaticArray<System::Byte, 4> Dummy;
	System::StaticArray<System::Byte, 8> DbfFile;
	System::Byte Version;
	System::StaticArray<System::Byte, 3> Dummy2;
	System::Word BlockLen;
	System::StaticArray<System::Byte, 490> Dummy3;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TSMEFPTHeader
{
public:
	System::LongInt NextBlock;
	System::StaticArray<System::Byte, 2> Dummy;
	System::Word BlockLen;
	System::StaticArray<System::Byte, 504> Dummy3;
};
#pragma pack(pop)


typedef TSMEBlockHeader *PSMEBlockHeader;

struct DECLSPEC_DRECORD TSMEBlockHeader
{
public:
	System::LongInt MemoType;
	System::LongInt MemoSize;
};


class PASCALIMPLEMENTATION TSMExportToDBF : public Sme2cell::TSMExportToCellFile
{
	typedef Sme2cell::TSMExportToCellFile inherited;
	
private:
	TDBFHeader DBFHeader;
	TSMEDBTHeader MEMOHeader;
	TSMEFPTHeader FPTHeader;
	TDBFVersion FDBFVersion;
	TDBFMemoType FDBFMemoType;
	System::Byte FLanguageID;
	bool MemoIsExists;
	Smeengine::TSMEString MemoFileName;
	
protected:
	System::Classes::TStrings* lstFieldNames;
	System::Classes::TStream* MEMOStream;
	virtual bool __fastcall MergeIsSupported();
	virtual void __fastcall InternalBeforeProcess();
	virtual void __fastcall InternalFileCreate(const Smeengine::TSMEString AFileName);
	void __fastcall WriteMemo(System::AnsiString Value);
	
public:
	__fastcall virtual TSMExportToDBF(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMExportToDBF();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	virtual void __fastcall WriteDataBegin();
	virtual void __fastcall CloseFileStream();
	virtual void __fastcall WriteDimensions(int intRowCount, int intColCount);
	virtual void __fastcall WriteColWidth(int intCurColumn, int intColWidth);
	virtual void __fastcall WriteRowStart();
	virtual void __fastcall WriteData(Data::Db::TField* fld, Smeengine::TCellType &CellType, int ARow, int ACol, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	virtual void __fastcall WriteString(const Smeengine::TSMEString s);
	virtual System::UnicodeString __fastcall Extension();
	
__published:
	__property TDBFVersion DBFVersion = {read=FDBFVersion, write=FDBFVersion, default=0};
	__property TDBFMemoType DBFMemoType = {read=FDBFMemoType, write=FDBFMemoType, default=0};
	__property System::Byte LanguageID = {read=FLanguageID, write=FLanguageID, default=0};
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE System::StaticArray<System::Byte, 20> arrDBFVersion;
}	/* namespace Sme2dbf */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SME2DBF)
using namespace Sme2dbf;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SME2DBFHPP
