﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SME2PDF.pas' rev: 37.00 (Windows)

#ifndef SME2PDFHPP
#define SME2PDFHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <Winapi.Windows.hpp>
#include <Vcl.Graphics.hpp>
#include <System.UITypes.hpp>
#include <Data.DB.hpp>
#include <ExportDS.hpp>
#include <SME2Cell.hpp>
#include <SMEEngine.hpp>
#include <System.ZLib.hpp>
#include <System.Variants.hpp>

//-- user supplied -----------------------------------------------------------

namespace Sme2pdf
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TPDFFont;
class DELPHICLASS TPDFFonts;
class DELPHICLASS TSMExportToPDF;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TPDFFilterDecode : unsigned char { fdASCIIHex, fdASCII85, fdLZW, fdDCT, fdFlate };

enum DECLSPEC_DENUM TPDFCompressionMethod : unsigned char { cmFastest, cmNormal, cmMaxCompress };

typedef System::StaticArray<System::UnicodeString, 5> Sme2pdf__1;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TPDFFont : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString RefIndex;
	System::UnicodeString BaseFont;
	System::UnicodeString FontName;
	System::Uitypes::TFontName Name;
	System::Uitypes::TFontCharset CharSet;
	System::Uitypes::TFontStyles Style;
	bool IsTrueType;
	bool IsEmbeddable;
	int Flags;
	void __fastcall FontParameters(Vcl::Graphics::TFont* Font);
	System::UnicodeString __fastcall GetFontName();
	bool __fastcall IsStandardFont();
	System::UnicodeString __fastcall EncodingString();
public:
	/* TObject.Create */ inline __fastcall TPDFFont() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TPDFFont() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TPDFFonts : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
private:
	System::UnicodeString __fastcall FontFamily(Vcl::Graphics::TFont* Font, System::Uitypes::TFontCharset Charset);
	System::Uitypes::TFontCharset __fastcall GetFontCharset(System::Uitypes::TFontCharset AValue);
	int __fastcall GetItemByFont(const System::UnicodeString BaseFont, System::Uitypes::TFontCharset Charset);
	int __fastcall FontFromTable(TSMExportToPDF* PDFEngine, Vcl::Graphics::TFont* Font);
	void __fastcall WriteFontDifferences(TSMExportToPDF* PDFEngine, TPDFFont* fnt);
	
public:
	TPDFFont* __fastcall GetFont(int Index);
	virtual void __fastcall Clear();
	void __fastcall WriteFonts(TSMExportToPDF* PDFEngine);
public:
	/* TList.Destroy */ inline __fastcall virtual ~TPDFFonts() { }
	
public:
	/* TObject.Create */ inline __fastcall TPDFFonts() : System::Classes::TList() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TSMEViewerPreference : unsigned char { evpHideToolBar, evpHideMenuBar, evpHideWindowUI, evpFitWindow, evpCenterWindow };

typedef System::Set<TSMEViewerPreference, TSMEViewerPreference::evpHideToolBar, TSMEViewerPreference::evpCenterWindow> TSMEViewerPreferences;

enum DECLSPEC_DENUM TSMEPDFPageLayout : unsigned char { eplDefault, eplSinglePage, eplOneColumn, eplTwoColumnLeft, eplTwoColumnRight, eplTwoPageLeft, eplTwoPageRight };

class PASCALIMPLEMENTATION TSMExportToPDF : public Sme2cell::TSMExportToCellFile
{
	typedef Sme2cell::TSMExportToCellFile inherited;
	
private:
	TPDFCompressionMethod FCompressionMethod;
	TSMEViewerPreferences FViewerPreferences;
	TSMEPDFPageLayout FPageLayout;
	System::Variant arrColWidths;
	int MaxKids;
	int FLastUsedRefIndex;
	System::Classes::TStringList* CrossRef;
	TPDFFonts* tblFont;
	System::Classes::TStrings* tblImage;
	System::Classes::TStrings* lstPages;
	int intTotalPages;
	int StreamSize;
	int FilePos;
	int intLastMergeCol;
	System::UnicodeString BodyRefIndex;
	System::UnicodeString ResRefIndex;
	System::UnicodeString StreamRefIndex;
	System::UnicodeString ProcRefIndex;
	double intCurY;
	double intCurRowHeight;
	double intCurYPos;
	double FOneSheetWidth;
	double PageWidth;
	double PageHeight;
	bool IsMemStream;
	bool IsDataStarted;
	TPDFFilterDecode FFontDecode;
	TPDFFilterDecode FImageDecode;
	double __fastcall GetRowTop(int ARow);
	
protected:
	System::Classes::TMemoryStream* MemStream;
	virtual bool __fastcall MergeIsSupported();
	System::UnicodeString __fastcall DateToPDFString(System::TDateTime dt);
	int __fastcall Occurs(System::UnicodeString Value, System::WideChar ch);
	void __fastcall ReplaceChar(System::UnicodeString &Source, System::WideChar chOld, System::WideChar chNew);
	System::UnicodeString __fastcall PDFColor(System::Uitypes::TColor Value, bool IsBackground);
	void __fastcall AddRef(System::UnicodeString RefIndex);
	System::UnicodeString __fastcall GetNextRefIndex();
	void __fastcall WriteCrossRef();
	
public:
	virtual void __fastcall WriteString(const Smeengine::TSMEString s);
	virtual void __fastcall WriteFileBegin();
	virtual void __fastcall WriteFileEnd();
	virtual void __fastcall WriteDimensions(int intRowCount, int intColCount);
	virtual void __fastcall WriteColWidth(int intCurColumn, int intColWidth);
	virtual void __fastcall WriteHeader();
	virtual void __fastcall WriteRowStart();
	virtual void __fastcall WriteRowEnd();
	virtual void __fastcall WriteData(Data::Db::TField* fld, Smeengine::TCellType &CellType, int ARow, int ACol, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	virtual void __fastcall WriteMergeData(Smeengine::TCellType &CellType, int ARow, int ACol, int AMergeCols, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	void __fastcall WriteLine(double Left, double Top, double Width, double Height, System::Uitypes::TColor ForeColor, System::Uitypes::TColor BackColor);
	void __fastcall WriteBitmap(int Index, System::UnicodeString ImageRefIndex, Vcl::Graphics::TBitmap* bmp);
	virtual void __fastcall WritePageBegin();
	virtual void __fastcall WritePageEnd();
	__fastcall virtual TSMExportToPDF(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMExportToPDF();
	virtual System::UnicodeString __fastcall Extension();
	
__published:
	__property PageSetup;
	__property TSMEViewerPreferences ViewerPreferences = {read=FViewerPreferences, write=FViewerPreferences, default=0};
	__property TSMEPDFPageLayout PageLayout = {read=FPageLayout, write=FPageLayout, default=0};
	__property TPDFCompressionMethod CompressionMethod = {read=FCompressionMethod, write=FCompressionMethod, default=1};
	__property TPDFFilterDecode FontDecode = {read=FFontDecode, write=FFontDecode, default=0};
	__property TPDFFilterDecode ImageDecode = {read=FImageDecode, write=FImageDecode, default=4};
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE Sme2pdf__1 arrPDFFilter;
}	/* namespace Sme2pdf */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SME2PDF)
using namespace Sme2pdf;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SME2PDFHPP
