﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SME2SQL.pas' rev: 37.00 (Windows)

#ifndef SME2SQLHPP
#define SME2SQLHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Data.DB.hpp>
#include <SME2Cell.hpp>
#include <ExportDS.hpp>
#include <SMEEngine.hpp>
#include <System.UITypes.hpp>

//-- user supplied -----------------------------------------------------------

namespace Sme2sql
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMESQLTypes;
class DELPHICLASS TSMESQLOptions;
class DELPHICLASS TSMExportToSQL;
//-- type declarations -------------------------------------------------------
#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMESQLTypes : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::UnicodeString FftString;
	System::UnicodeString FftSmallint;
	System::UnicodeString FftInteger;
	System::UnicodeString FftWord;
	System::UnicodeString FftBoolean;
	System::UnicodeString FftFloat;
	System::UnicodeString FftCurrency;
	System::UnicodeString FftBCD;
	System::UnicodeString FftDate;
	System::UnicodeString FftTime;
	System::UnicodeString FftDateTime;
	System::UnicodeString FftAutoInc;
	System::UnicodeString FftBlob;
	System::UnicodeString FftMemo;
	System::UnicodeString FftGraphic;
	System::UnicodeString FftLargeint;
	System::UnicodeString FftLongWord;
	System::UnicodeString FftShortint;
	System::UnicodeString FftByte;
	System::UnicodeString FftExtended;
	System::UnicodeString FftSingle;
	bool FCheckRequired;
	bool FAddPrimaryKey;
	
public:
	__fastcall virtual TSMESQLTypes();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::UnicodeString ftString = {read=FftString, write=FftString};
	__property System::UnicodeString ftSmallint = {read=FftSmallint, write=FftSmallint};
	__property System::UnicodeString ftInteger = {read=FftInteger, write=FftInteger};
	__property System::UnicodeString ftWord = {read=FftWord, write=FftWord};
	__property System::UnicodeString ftBoolean = {read=FftBoolean, write=FftBoolean};
	__property System::UnicodeString ftFloat = {read=FftFloat, write=FftFloat};
	__property System::UnicodeString ftCurrency = {read=FftCurrency, write=FftCurrency};
	__property System::UnicodeString ftBCD = {read=FftBCD, write=FftBCD};
	__property System::UnicodeString ftDate = {read=FftDate, write=FftDate};
	__property System::UnicodeString ftTime = {read=FftTime, write=FftTime};
	__property System::UnicodeString ftDateTime = {read=FftDateTime, write=FftDateTime};
	__property System::UnicodeString ftAutoInc = {read=FftAutoInc, write=FftAutoInc};
	__property System::UnicodeString ftBlob = {read=FftBlob, write=FftBlob};
	__property System::UnicodeString ftMemo = {read=FftMemo, write=FftMemo};
	__property System::UnicodeString ftGraphic = {read=FftGraphic, write=FftGraphic};
	__property System::UnicodeString ftLargeint = {read=FftLargeint, write=FftLargeint};
	__property System::UnicodeString ftLongWord = {read=FftLongWord, write=FftLongWord};
	__property System::UnicodeString ftShortint = {read=FftShortint, write=FftShortint};
	__property System::UnicodeString ftByte = {read=FftByte, write=FftByte};
	__property System::UnicodeString ftExtended = {read=FftExtended, write=FftExtended};
	__property System::UnicodeString ftSingle = {read=FftSingle, write=FftSingle};
	__property bool CheckRequired = {read=FCheckRequired, write=FCheckRequired, default=1};
	__property bool AddPrimaryKey = {read=FAddPrimaryKey, write=FAddPrimaryKey, default=0};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMESQLTypes() { }
	
};

#pragma pack(pop)

typedef void __fastcall (__closure *TGetCreateTable)(System::TObject* Sender, System::UnicodeString &SQL, System::UnicodeString &Prefix, System::UnicodeString &Suffix);

enum DECLSPEC_DENUM TFieldCharCase : unsigned char { ecNormal, ecUpperCase, ecLowerCase, ecProper };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMESQLOptions : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::UnicodeString FSQLTerm;
	Smeengine::TSMEChar FSQLQuote;
	System::UnicodeString FSQLNULL;
	System::UnicodeString FCommitTerm;
	int FBatchRecCount;
	bool FAddCreateTable;
	TFieldCharCase FFieldNameCharCase;
	bool FMultiRowInsert;
	TSMESQLTypes* FSQLTypes;
	void __fastcall SetSQLTypes(TSMESQLTypes* Value);
	
public:
	__fastcall virtual TSMESQLOptions();
	__fastcall virtual ~TSMESQLOptions();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	void __fastcall LoadFromStrings(System::Classes::TStrings* lstSpec);
	void __fastcall SaveToStream(System::Classes::TStream* AStream);
	
__published:
	__property bool AddCreateTable = {read=FAddCreateTable, write=FAddCreateTable, nodefault};
	__property System::UnicodeString CommitTerm = {read=FCommitTerm, write=FCommitTerm};
	__property int BatchRecCount = {read=FBatchRecCount, write=FBatchRecCount, default=2147483647};
	__property TFieldCharCase FieldNameCharCase = {read=FFieldNameCharCase, write=FFieldNameCharCase, default=0};
	__property bool MultiRowInsert = {read=FMultiRowInsert, write=FMultiRowInsert, default=0};
	__property Smeengine::TSMEChar SQLQuote = {read=FSQLQuote, write=FSQLQuote, nodefault};
	__property System::UnicodeString SQLTerm = {read=FSQLTerm, write=FSQLTerm};
	__property TSMESQLTypes* SQLTypes = {read=FSQLTypes, write=SetSQLTypes};
	__property System::UnicodeString SQLNULL = {read=FSQLNULL, write=FSQLNULL};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TSMExportToSQL : public Sme2cell::TSMExportToCellBufferedFile
{
	typedef Sme2cell::TSMExportToCellBufferedFile inherited;
	
private:
	TSMESQLOptions* FSQLOptions;
	int RecInBatch;
	System::UnicodeString strFieldNames;
	TGetCreateTable FOnGetCreateTable;
	System::UnicodeString __fastcall GetSQLTerm();
	void __fastcall SetSQLTerm(System::UnicodeString Value);
	Smeengine::TSMEChar __fastcall GetSQLQuote();
	void __fastcall SetSQLQuote(Smeengine::TSMEChar Value);
	System::UnicodeString __fastcall GetCommitTerm();
	void __fastcall SetCommitTerm(System::UnicodeString Value);
	int __fastcall GetBatchRecCount();
	void __fastcall SetBatchRecCount(int Value);
	bool __fastcall GetAddCreateTable();
	void __fastcall SetAddCreateTable(bool Value);
	TFieldCharCase __fastcall GetFieldNameCharCase();
	void __fastcall SetFieldNameCharCase(TFieldCharCase Value);
	TSMESQLTypes* __fastcall GetSQLTypes();
	void __fastcall SetSQLTypes(TSMESQLTypes* Value);
	bool __fastcall GetMultiRowInsert();
	void __fastcall SetMultiRowInsert(bool Value);
	TSMESQLOptions* __fastcall GetSQLOptions();
	void __fastcall SetSQLOptions(TSMESQLOptions* Value);
	
protected:
	virtual bool __fastcall MergeIsSupported();
	virtual bool __fastcall TitleIsSupported();
	virtual Smeengine::TSMEString __fastcall GetFieldStr(Data::Db::TField* Field, Smeengine::TSMEColumn* AColumn);
	System::UnicodeString __fastcall GetFieldName(const System::UnicodeString Value);
	
public:
	virtual void __fastcall WriteCommitTerm();
	virtual void __fastcall WriteFileBegin();
	virtual void __fastcall WriteFileEnd();
	virtual void __fastcall WriteRowStart();
	virtual void __fastcall WriteRowEnd();
	virtual void __fastcall WriteData(Data::Db::TField* fld, Smeengine::TCellType &CellType, int ARow, int ACol, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	__fastcall virtual TSMExportToSQL(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMExportToSQL();
	virtual System::UnicodeString __fastcall Extension();
	
__published:
	__property ActionAfterExport = {default=0};
	__property FileName = {default=0};
	__property bool AddCreateTable = {read=GetAddCreateTable, write=SetAddCreateTable, nodefault};
	__property System::UnicodeString CommitTerm = {read=GetCommitTerm, write=SetCommitTerm};
	__property int BatchRecCount = {read=GetBatchRecCount, write=SetBatchRecCount, default=2147483647};
	__property TFieldCharCase FieldNameCharCase = {read=GetFieldNameCharCase, write=SetFieldNameCharCase, default=0};
	__property bool MultiRowInsert = {read=GetMultiRowInsert, write=SetMultiRowInsert, nodefault};
	__property Smeengine::TSMEChar SQLQuote = {read=GetSQLQuote, write=SetSQLQuote, nodefault};
	__property System::UnicodeString SQLTerm = {read=GetSQLTerm, write=SetSQLTerm};
	__property TSMESQLTypes* SQLTypes = {read=GetSQLTypes, write=SetSQLTypes};
	__property TSMESQLOptions* SQLOptions = {read=GetSQLOptions, write=SetSQLOptions};
	__property TableName = {default=0};
	__property TGetCreateTable OnGetCreateTable = {read=FOnGetCreateTable, write=FOnGetCreateTable};
	__property AddTitle = {default=0};
	__property CharacterSet;
	__property Header;
	__property Footer;
	__property OnGetCellParams;
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE System::UnicodeString CreateTableTemplate;
}	/* namespace Sme2sql */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SME2SQL)
using namespace Sme2sql;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SME2SQLHPP
