﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SME2XLS.pas' rev: 37.00 (Windows)

#ifndef SME2XLSHPP
#define SME2XLSHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <Winapi.Windows.hpp>
#include <System.UITypes.hpp>
#include <Vcl.Graphics.hpp>
#include <Data.DB.hpp>
#include <Winapi.ActiveX.hpp>
#include <System.SysUtils.hpp>
#include <SME2Cell.hpp>
#include <ExportDS.hpp>
#include <SMEEngine.hpp>

//-- user supplied -----------------------------------------------------------

namespace Sme2xls
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS ESMEMaxRowCountException;
class DELPHICLASS ESMEExcelException;
class DELPHICLASS TXLSObject;
class DELPHICLASS TXLSPicture;
class DELPHICLASS TXLSMergeCells;
class DELPHICLASS TXLSFormat;
class DELPHICLASS TSMEXLSSST;
class DELPHICLASS TTemporaryFileStream;
class DELPHICLASS TSMExportToCustomXLS;
class DELPHICLASS TSMExportToXLS;
class DELPHICLASS TSMExportToXLSWorkBook;
//-- type declarations -------------------------------------------------------
#pragma pack(push,4)
class PASCALIMPLEMENTATION ESMEMaxRowCountException : public System::Sysutils::Exception
{
	typedef System::Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ inline __fastcall ESMEMaxRowCountException(const System::UnicodeString Msg) : System::Sysutils::Exception(Msg) { }
	/* Exception.CreateFmt */ inline __fastcall ESMEMaxRowCountException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High) : System::Sysutils::Exception(Msg, Args, Args_High) { }
	/* Exception.CreateRes */ inline __fastcall ESMEMaxRowCountException(System::NativeUInt Ident)/* overload */ : System::Sysutils::Exception(Ident) { }
	/* Exception.CreateRes */ inline __fastcall ESMEMaxRowCountException(System::PResStringRec ResStringRec)/* overload */ : System::Sysutils::Exception(ResStringRec) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMEMaxRowCountException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMEMaxRowCountException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High) { }
	/* Exception.CreateHelp */ inline __fastcall ESMEMaxRowCountException(const System::UnicodeString Msg, int AHelpContext) : System::Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ inline __fastcall ESMEMaxRowCountException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext) : System::Sysutils::Exception(Msg, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMEMaxRowCountException(System::NativeUInt Ident, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMEMaxRowCountException(System::PResStringRec ResStringRec, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMEMaxRowCountException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMEMaxRowCountException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High, AHelpContext) { }
	/* Exception.Destroy */ inline __fastcall virtual ~ESMEMaxRowCountException() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION ESMEExcelException : public System::Sysutils::Exception
{
	typedef System::Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ inline __fastcall ESMEExcelException(const System::UnicodeString Msg) : System::Sysutils::Exception(Msg) { }
	/* Exception.CreateFmt */ inline __fastcall ESMEExcelException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High) : System::Sysutils::Exception(Msg, Args, Args_High) { }
	/* Exception.CreateRes */ inline __fastcall ESMEExcelException(System::NativeUInt Ident)/* overload */ : System::Sysutils::Exception(Ident) { }
	/* Exception.CreateRes */ inline __fastcall ESMEExcelException(System::PResStringRec ResStringRec)/* overload */ : System::Sysutils::Exception(ResStringRec) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMEExcelException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMEExcelException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High) { }
	/* Exception.CreateHelp */ inline __fastcall ESMEExcelException(const System::UnicodeString Msg, int AHelpContext) : System::Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ inline __fastcall ESMEExcelException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext) : System::Sysutils::Exception(Msg, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMEExcelException(System::NativeUInt Ident, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMEExcelException(System::PResStringRec ResStringRec, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMEExcelException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMEExcelException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High, AHelpContext) { }
	/* Exception.Destroy */ inline __fastcall virtual ~ESMEExcelException() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TSMExportXLSVersion : unsigned char { exvExcel2, exvExcel3, exvExcel4, exvExcel5, exvExcel7, exvExcel8, exvExcel9, exvExcel12, exvExcel12Bin };

enum DECLSPEC_DENUM TXLSObjectKind : unsigned char { okUnknown, okHyperlink, okNote, okPicture, okImage, okGraphic, okMergedCells };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TXLSObject : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TXLSObjectKind FObjectKind;
	System::Word FFromCol;
	System::Word FFromRow;
	System::Word FToCol;
	System::Word FToRow;
	
public:
	__property TXLSObjectKind ObjectKind = {read=FObjectKind, write=FObjectKind, default=0};
	__property System::Word FromCol = {read=FFromCol, write=FFromCol, nodefault};
	__property System::Word FromRow = {read=FFromRow, write=FFromRow, nodefault};
	__property System::Word ToCol = {read=FToCol, write=FToCol, nodefault};
	__property System::Word ToRow = {read=FToRow, write=FToRow, nodefault};
public:
	/* TObject.Create */ inline __fastcall TXLSObject() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TXLSObject() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TXLSPicture : public TXLSObject
{
	typedef TXLSObject inherited;
	
private:
	Vcl::Graphics::TPicture* FPicture;
	int FSize;
	
public:
	__fastcall virtual TXLSPicture();
	__fastcall virtual ~TXLSPicture();
	int __fastcall GetPictureSize();
	int __fastcall GetPictureType();
	System::UnicodeString __fastcall GetPictureExt();
	void __fastcall WriteToStream(System::Classes::TStream* strm);
	System::UnicodeString __fastcall GetAsString(bool ConvertToJpeg);
	__property Vcl::Graphics::TPicture* Picture = {read=FPicture, write=FPicture};
	__property int Size = {read=FSize, write=FSize, nodefault};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TXLSMergeCells : public TXLSObject
{
	typedef TXLSObject inherited;
	
public:
	/* TObject.Create */ inline __fastcall TXLSMergeCells() : TXLSObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TXLSMergeCells() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TXLSFormat : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::Uitypes::TColor FColor;
	int FFontIndex;
	int FNumFormat;
	System::Classes::TAlignment FAlignment;
	Smeengine::TSMEVerticalAlignment FVerticalAlignment;
	bool FWrapText;
	
public:
	__property System::Uitypes::TColor Color = {read=FColor, write=FColor, default=0};
	__property int FontIndex = {read=FFontIndex, write=FFontIndex, default=0};
	__property int NumFormat = {read=FNumFormat, write=FNumFormat, default=-1};
	__property System::Classes::TAlignment Alignment = {read=FAlignment, write=FAlignment, default=0};
	__property Smeengine::TSMEVerticalAlignment VerticalAlignment = {read=FVerticalAlignment, write=FVerticalAlignment, default=0};
	__property bool WrapText = {read=FWrapText, write=FWrapText, default=0};
public:
	/* TObject.Create */ inline __fastcall TXLSFormat() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TXLSFormat() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TSMEXLSSST : public System::Classes::TStringList
{
	typedef System::Classes::TStringList inherited;
	
private:
	TSMExportToCustomXLS* FEngine;
	System::Classes::TList* BlockSizes;
	__int64 CurPosInSSTBlock;
	
public:
	__fastcall virtual TSMEXLSSST();
	__fastcall virtual ~TSMEXLSSST();
	int __fastcall AddString(System::UnicodeString Value);
	virtual void __fastcall Clear();
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TTemporaryFileStream : public System::Classes::THandleStream
{
	typedef System::Classes::THandleStream inherited;
	
public:
	__fastcall TTemporaryFileStream();
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TTemporaryFileStream() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TSMESSTOptimizationMode : unsigned char { somNone, somUniqueValues, somOptimal };

class PASCALIMPLEMENTATION TSMExportToCustomXLS : public Sme2cell::TSMExportToCellFile
{
	typedef Sme2cell::TSMExportToCellFile inherited;
	
private:
	System::Classes::TMemoryStream* FTempFontStream;
	int FSheetIndex;
	System::UnicodeString FUserName;
	System::Classes::TStrings* FPageHeader;
	System::Classes::TStrings* FPageFooter;
	TSMESSTOptimizationMode FSSTOptimizationMode;
	System::Classes::TStrings* __fastcall GetPageHeader();
	void __fastcall SetPageHeader(System::Classes::TStrings* Value);
	System::Classes::TStrings* __fastcall GetPageFooter();
	void __fastcall SetPageFooter(System::Classes::TStrings* Value);
	int __fastcall GetFontFromTable(Vcl::Graphics::TFont* const Font);
	System::Classes::TMemoryStream* __fastcall GetFontStream();
	int __fastcall GetXLSIndexByColor(System::Uitypes::TColor color);
	
protected:
	TSMExportXLSVersion FVersion;
	System::Classes::TList* lstFonts;
	System::Classes::TList* lstFormats;
	System::Classes::TList* lstObjects;
	TSMEXLSSST* lstSST;
	int __fastcall GetXF(Vcl::Graphics::TFont* const Font, System::Uitypes::TColor AColor, int ANumFormat, System::Classes::TAlignment AAlignment, Smeengine::TSMEVerticalAlignment AVerticalAlignment, bool AWrapText);
	void __fastcall WriteFormats();
	void __fastcall WriteStyles();
	void __fastcall WriteSST();
	virtual void __fastcall InternalBeforeProcess();
	virtual void __fastcall InternalAfterProcess();
	virtual void __fastcall WriteBuffer(System::Sysutils::PByteArray Buffer, int ASize);
	virtual void __fastcall WriteStringValue(const Smeengine::TSMEString AString, bool IncludeLength);
	int __fastcall GetMaxBuffSize();
	System::UnicodeString __fastcall ApplyDataFormat(const System::UnicodeString AFormat, bool ToDirect);
	virtual System::Word __fastcall GetDefaultNumFormat(Smeengine::TCellType ACellType);
	virtual int __fastcall GetMaxFontCount();
	virtual int __fastcall GetMaxRowCount();
	virtual int __fastcall GetMaxColCount();
	bool __fastcall AddPicture(Data::Db::TField* AField, Smeengine::TCellType ACellType, int ARow, int ACol, Smeengine::TSMEString AContent);
	virtual int __fastcall AddSSTValue(const System::UnicodeString AValue);
	System::UnicodeString __fastcall GetNormalizedSheetName(const System::UnicodeString ASheetName);
	__property TSMESSTOptimizationMode SSTOptimizationMode = {read=FSSTOptimizationMode, write=FSSTOptimizationMode, default=0};
	
public:
	virtual void __fastcall ApplyDefaultFont(Vcl::Graphics::TFont* AFont, bool ReadOwner);
	virtual void __fastcall WriteRecordHeader(System::Classes::TStream* Stream, __int64 RecType, __int64 Size);
	virtual void __fastcall WriteFontStream();
	void __fastcall WriteMSOHeader(System::Word FBT, System::Word Version, System::Word Instance, int Size);
	void __fastcall Write_MSO_DGG(int ContainerSize);
	void __fastcall Write_MSO_BStoreContainer(int ContainerSize);
	virtual void __fastcall WriteData(Data::Db::TField* fld, Smeengine::TCellType &CellType, int ARow, int ACol, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	virtual void __fastcall WriteFont(Vcl::Graphics::TFont* fn);
	virtual void __fastcall WriteRowStart();
	virtual void __fastcall WriteFormat(int Index, System::UnicodeString Format, bool IsFormat);
	virtual void __fastcall WriteXF(TXLSFormat* fmt, int AIndex);
	virtual void __fastcall WriteFileEnd();
	void __fastcall WriteFontFormats();
	void __fastcall WriteXF5s();
	void __fastcall WriteStyle(const System::AnsiString Style);
	__fastcall virtual TSMExportToCustomXLS(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMExportToCustomXLS();
	virtual System::UnicodeString __fastcall Extension();
	__property System::Classes::TMemoryStream* TempFontStream = {read=GetFontStream};
	__property TSMExportXLSVersion Version = {read=FVersion, default=3};
	
__published:
	__property ExportStyle;
	__property System::UnicodeString UserName = {read=FUserName, write=FUserName};
	__property System::Classes::TStrings* PageHeader = {read=GetPageHeader, write=SetPageHeader};
	__property System::Classes::TStrings* PageFooter = {read=GetPageFooter, write=SetPageFooter};
};


class PASCALIMPLEMENTATION TSMExportToXLS : public TSMExportToCustomXLS
{
	typedef TSMExportToCustomXLS inherited;
	
protected:
	virtual void __fastcall WriteBuffer(System::Sysutils::PByteArray Buffer, int ASize);
	virtual void __fastcall WriteStringValue(const Smeengine::TSMEString AString, bool IncludeLength);
	
public:
	virtual void __fastcall WriteRecordHeader(System::Classes::TStream* Stream, __int64 RecType, __int64 Size);
	virtual void __fastcall WriteFontStream();
	virtual void __fastcall WriteFileBegin();
	virtual void __fastcall WriteDimensions(int intRowCount, int intColCount);
	virtual void __fastcall WriteColWidth(int intCurColumn, int intColWidth);
	virtual void __fastcall WriteFormat(int Index, System::UnicodeString Format, bool IsFormat);
public:
	/* TSMExportToCustomXLS.Create */ inline __fastcall virtual TSMExportToXLS(System::Classes::TComponent* AOwner) : TSMExportToCustomXLS(AOwner) { }
	/* TSMExportToCustomXLS.Destroy */ inline __fastcall virtual ~TSMExportToXLS() { }
	
};


class PASCALIMPLEMENTATION TSMExportToXLSWorkBook : public TSMExportToCustomXLS
{
	typedef TSMExportToCustomXLS inherited;
	
private:
	int APos;
	
protected:
	System::Sysutils::PByteArray pBuf;
	_di_IStream OStream;
	virtual System::Word __fastcall GetDefaultNumFormat(Smeengine::TCellType ACellType);
	virtual void __fastcall WriteBuffer(System::Sysutils::PByteArray Buffer, int ASize);
	virtual void __fastcall WriteStringValue(const Smeengine::TSMEString AString, bool IncludeLength);
	
public:
	virtual void __fastcall WriteRecordHeader(System::Classes::TStream* Stream, __int64 RecType, __int64 Size);
	virtual void __fastcall WriteFontStream();
	virtual void __fastcall WriteDimensions(int intRowCount, int intColCount);
	virtual void __fastcall WriteFormat(int Index, System::UnicodeString Format, bool IsFormat);
	void __fastcall SaveToWorkbook();
public:
	/* TSMExportToCustomXLS.Create */ inline __fastcall virtual TSMExportToXLSWorkBook(System::Classes::TComponent* AOwner) : TSMExportToCustomXLS(AOwner) { }
	/* TSMExportToCustomXLS.Destroy */ inline __fastcall virtual ~TSMExportToXLSWorkBook() { }
	
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Sme2xls */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SME2XLS)
using namespace Sme2xls;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SME2XLSHPP
