﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMEEngine.pas' rev: 37.00 (Windows)

#ifndef SMEEngineHPP
#define SMEEngineHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <System.SysUtils.hpp>
#include <Data.DB.hpp>
#include <Vcl.Graphics.hpp>
#include <System.Variants.hpp>
#include <System.UITypes.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smeengine
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS ESMENotSupportedClassException;
class DELPHICLASS TSMEColumnBand;
class DELPHICLASS TSMEColumnBands;
class DELPHICLASS TSMEColumnTitle;
class DELPHICLASS TSMEColumn;
class DELPHICLASS TSMEColumns;
class DELPHICLASS TSMEGrouping;
class DELPHICLASS TSMEGroupings;
class DELPHICLASS TSMEPageSetup;
class DELPHICLASS TSMECustomDataEngine;
class DELPHICLASS TSMEVirtualDataEngine;
//-- type declarations -------------------------------------------------------
typedef System::WideString TSMEString;

typedef System::WideChar TSMEChar;

#pragma pack(push,4)
class PASCALIMPLEMENTATION ESMENotSupportedClassException : public System::Sysutils::Exception
{
	typedef System::Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ inline __fastcall ESMENotSupportedClassException(const System::UnicodeString Msg) : System::Sysutils::Exception(Msg) { }
	/* Exception.CreateFmt */ inline __fastcall ESMENotSupportedClassException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High) : System::Sysutils::Exception(Msg, Args, Args_High) { }
	/* Exception.CreateRes */ inline __fastcall ESMENotSupportedClassException(System::NativeUInt Ident)/* overload */ : System::Sysutils::Exception(Ident) { }
	/* Exception.CreateRes */ inline __fastcall ESMENotSupportedClassException(System::PResStringRec ResStringRec)/* overload */ : System::Sysutils::Exception(ResStringRec) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMENotSupportedClassException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMENotSupportedClassException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High) { }
	/* Exception.CreateHelp */ inline __fastcall ESMENotSupportedClassException(const System::UnicodeString Msg, int AHelpContext) : System::Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ inline __fastcall ESMENotSupportedClassException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext) : System::Sysutils::Exception(Msg, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMENotSupportedClassException(System::NativeUInt Ident, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMENotSupportedClassException(System::PResStringRec ResStringRec, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMENotSupportedClassException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMENotSupportedClassException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High, AHelpContext) { }
	/* Exception.Destroy */ inline __fastcall virtual ~ESMENotSupportedClassException() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMEColumnBand : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	System::Classes::TAlignment FAlignment;
	System::UnicodeString FCaption;
	bool FVisible;
	System::Uitypes::TColor FColor;
	Vcl::Graphics::TFont* FFont;
	void __fastcall SetFont(Vcl::Graphics::TFont* Value);
	
public:
	__fastcall virtual TSMEColumnBand(System::Classes::TCollection* Collection);
	__fastcall virtual ~TSMEColumnBand();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::Classes::TAlignment Alignment = {read=FAlignment, write=FAlignment, default=2};
	__property System::UnicodeString Caption = {read=FCaption, write=FCaption};
	__property bool Visible = {read=FVisible, write=FVisible, default=1};
	__property Vcl::Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property System::Uitypes::TColor Color = {read=FColor, write=FColor, default=12632256};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMEColumnBands : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
public:
	TSMEColumnBand* operator[](int Index) { return this->Items[Index]; }
	
private:
	System::Classes::TComponent* FSMEControl;
	TSMEColumnBand* __fastcall GetColumnBand(int Index);
	void __fastcall SetColumnBand(int Index, TSMEColumnBand* Value);
	
protected:
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	
public:
	__fastcall TSMEColumnBands(System::Classes::TComponent* SMECntrl);
	HIDESBASE TSMEColumnBand* __fastcall Add();
	__property TSMEColumnBand* Items[int Index] = {read=GetColumnBand, write=SetColumnBand/*, default*/};
	__property System::Classes::TComponent* SMEControl = {read=FSMEControl};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TSMEColumnBands() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMEColumnTitle : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::UnicodeString FCaption;
	System::Uitypes::TColor FColor;
	System::Classes::TAlignment FAlignment;
	Vcl::Graphics::TFont* FFont;
	void __fastcall SetFont(Vcl::Graphics::TFont* Value);
	
public:
	__fastcall TSMEColumnTitle();
	__fastcall virtual ~TSMEColumnTitle();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::UnicodeString Caption = {read=FCaption, write=FCaption};
	__property System::Classes::TAlignment Alignment = {read=FAlignment, write=FAlignment, default=0};
	__property Vcl::Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property System::Uitypes::TColor Color = {read=FColor, write=FColor, default=12632256};
};

#pragma pack(pop)

enum DECLSPEC_DENUM TSMEFieldDisplayFormat : unsigned char { dfFull, dfFieldCaption, dfFieldName };

enum DECLSPEC_DENUM TSMEVerticalAlignment : unsigned char { vaTop, vaCenter, vaBottom, vaJustify };

enum DECLSPEC_DENUM TSMEColumnKind : unsigned char { ckField, ckConstant, ckSysVar };

enum DECLSPEC_DENUM TCellType : unsigned char { ctBlank, ctInteger, ctDouble, ctString, ctDateTime, ctDate, ctCurrency, ctTime, ctMEMO, ctGraphic, ctBoolean, ctBLOB, ctFormula };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMEColumn : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	System::UnicodeString FFieldName;
	System::Uitypes::TColor FColor;
	int FWidth;
	int FPrecision;
	Vcl::Graphics::TFont* FFont;
	System::Classes::TAlignment FAlignment;
	TSMEVerticalAlignment FVerticalAlignment;
	bool FVisible;
	TSMEColumnTitle* FTitle;
	TCellType FDataType;
	TSMEColumnKind FColumnKind;
	int FBandIndex;
	System::UnicodeString FFormat;
	void __fastcall SetFont(Vcl::Graphics::TFont* Value);
	void __fastcall SetTitle(TSMEColumnTitle* Value);
	
protected:
	virtual System::UnicodeString __fastcall GetDisplayName();
	
public:
	Data::Db::TField* Field;
	__fastcall virtual TSMEColumn(System::Classes::TCollection* Collection);
	__fastcall virtual ~TSMEColumn();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	System::UnicodeString __fastcall GetItemCaption(TSMEFieldDisplayFormat FieldDisplayFormat);
	
__published:
	__property System::Classes::TAlignment Alignment = {read=FAlignment, write=FAlignment, default=0};
	__property TSMEVerticalAlignment VerticalAlignment = {read=FVerticalAlignment, write=FVerticalAlignment, default=0};
	__property System::Uitypes::TColor Color = {read=FColor, write=FColor, default=16777215};
	__property System::UnicodeString FieldName = {read=FFieldName, write=FFieldName};
	__property System::UnicodeString Format = {read=FFormat, write=FFormat};
	__property Vcl::Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property int Width = {read=FWidth, write=FWidth, default=0};
	__property int Precision = {read=FPrecision, write=FPrecision, default=0};
	__property bool Visible = {read=FVisible, write=FVisible, nodefault};
	__property TSMEColumnTitle* Title = {read=FTitle, write=SetTitle};
	__property TCellType DataType = {read=FDataType, write=FDataType, default=3};
	__property TSMEColumnKind ColumnKind = {read=FColumnKind, write=FColumnKind, default=0};
	__property int BandIndex = {read=FBandIndex, write=FBandIndex, default=-1};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMEColumns : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
public:
	TSMEColumn* operator[](int Index) { return this->Items[Index]; }
	
private:
	System::Classes::TComponent* FSMEControl;
	TSMEColumn* __fastcall GetColumn(int Index);
	void __fastcall SetColumn(int Index, TSMEColumn* Value);
	
protected:
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	
public:
	__fastcall TSMEColumns(System::Classes::TComponent* SMECntrl);
	HIDESBASE TSMEColumn* __fastcall Add();
	int __fastcall ColumnByFieldName(const System::UnicodeString AFieldName);
	int __fastcall MergedColStart(int BandIndex);
	int __fastcall MergedColCount(int BandIndex, int StartColIndex);
	void __fastcall ClearFields();
	__property TSMEColumn* Items[int Index] = {read=GetColumn, write=SetColumn/*, default*/};
	__property System::Classes::TComponent* SMEControl = {read=FSMEControl};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TSMEColumns() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TSMEGrouping : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	System::UnicodeString FCaption;
	System::Uitypes::TColor FColor;
	Vcl::Graphics::TFont* FFont;
	System::UnicodeString FExpression;
	void __fastcall SetFont(Vcl::Graphics::TFont* Value);
	
protected:
	System::Variant FPrevValue;
	System::Variant FCurrValue;
	
public:
	__fastcall virtual TSMEGrouping(System::Classes::TCollection* Collection);
	__fastcall virtual ~TSMEGrouping();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	bool __fastcall GroupIsChanged();
	__property System::Variant CurrValue = {read=FCurrValue, write=FCurrValue};
	
__published:
	__property System::UnicodeString Caption = {read=FCaption, write=FCaption};
	__property Vcl::Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property System::Uitypes::TColor Color = {read=FColor, write=FColor, default=12632256};
	__property System::UnicodeString Expression = {read=FExpression, write=FExpression};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMEGroupings : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
public:
	TSMEGrouping* operator[](int Index) { return this->Items[Index]; }
	
private:
	System::Classes::TComponent* FSMEControl;
	TSMEGrouping* __fastcall GetGrouping(int Index);
	void __fastcall SetGrouping(int Index, TSMEGrouping* Value);
	
protected:
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	
public:
	__fastcall TSMEGroupings(System::Classes::TComponent* SMECntrl);
	HIDESBASE TSMEGrouping* __fastcall Add();
	void __fastcall InitPrevDataValues();
	__property TSMEGrouping* Items[int Index] = {read=GetGrouping, write=SetGrouping/*, default*/};
	__property System::Classes::TComponent* SMEControl = {read=FSMEControl};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TSMEGroupings() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TSMEMeasure : unsigned char { emPoint, emInch, emCentimeters, emPicas };

enum DECLSPEC_DENUM TSMEOrientation : unsigned char { emDefault, emPortrait, emLandscape };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMEPageSetup : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	TSMEMeasure FMeasure;
	bool FUseDefault;
	float FTopMargin;
	float FBottomMargin;
	float FLeftMargin;
	float FRightMargin;
	int FZoom;
	System::Word FPaperSize;
	int FFitToPagesWide;
	int FFitToPagesTall;
	float FTableWidth;
	TSMEOrientation FOrientation;
	
public:
	__fastcall virtual TSMEPageSetup();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	int __fastcall GetTwips(float AValue);
	
__published:
	__property TSMEMeasure Measure = {read=FMeasure, write=FMeasure, default=0};
	__property bool UseDefault = {read=FUseDefault, write=FUseDefault, default=1};
	__property float TopMargin = {read=FTopMargin, write=FTopMargin};
	__property float BottomMargin = {read=FBottomMargin, write=FBottomMargin};
	__property float LeftMargin = {read=FLeftMargin, write=FLeftMargin};
	__property float RightMargin = {read=FRightMargin, write=FRightMargin};
	__property System::Word PaperSize = {read=FPaperSize, write=FPaperSize, nodefault};
	__property int Zoom = {read=FZoom, write=FZoom, default=100};
	__property int FitToPagesWide = {read=FFitToPagesWide, write=FFitToPagesWide, default=1};
	__property int FitToPagesTall = {read=FFitToPagesTall, write=FFitToPagesTall, default=1};
	__property float TableWidth = {read=FTableWidth, write=FTableWidth};
	__property TSMEOrientation Orientation = {read=FOrientation, write=FOrientation, default=0};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMEPageSetup() { }
	
};

#pragma pack(pop)

typedef void __fastcall (__closure *TSMEGetNext)(System::TObject* Sender, bool &Abort);

typedef void __fastcall (__closure *TSMEGetCount)(System::TObject* Sender, System::LongInt &Count);

typedef void __fastcall (__closure *TSMEGetValue)(System::TObject* Sender, TSMEColumn* Column, System::Variant &Value);

typedef System::TMetaClass* TSMECustomDataEngineClass;

class PASCALIMPLEMENTATION TSMECustomDataEngine : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	bool FSelectedRecords;
	System::Classes::TNotifyEvent FOnFirst;
	TSMEGetNext FOnNext;
	TSMEGetCount FOnCount;
	System::Classes::TNotifyEvent FOnBeforeExecute;
	System::Classes::TNotifyEvent FOnAfterExecute;
	System::Classes::TNotifyEvent FOnFillColumns;
	TSMEGetValue FOnGetValue;
	int FLevel;
	
protected:
	bool IsCanceled;
	
public:
	virtual bool __fastcall SelectedRecordIsSupported();
	virtual void __fastcall EnableControls();
	virtual void __fastcall DisableControls();
	virtual void __fastcall SavePosition();
	virtual void __fastcall RestorePosition();
	virtual void __fastcall FillColumns(TSMEColumns* Columns, TSMEColumnBands* Bands, bool RightToLeft);
	virtual bool __fastcall IsDataRow(int Index);
	virtual bool __fastcall Eof();
	virtual void __fastcall First();
	virtual void __fastcall Next();
	virtual System::Variant __fastcall GetFieldValue(TSMEColumn* Column);
	virtual void __fastcall ApplyCellColors(int ARow, int ACol, System::Classes::TAlignment &al, Vcl::Graphics::TFont* &fnt, System::Uitypes::TColor &AColor);
	virtual int __fastcall RecordCount();
	virtual Data::Db::TFieldType __fastcall DataTypeByColumn(TSMEColumn* Column);
	virtual bool __fastcall RequiredByColumn(TSMEColumn* Column);
	virtual bool __fastcall ReadOnlyByColumn(TSMEColumn* Column);
	virtual Data::Db::TField* __fastcall FindFieldByColumn(TSMEColumn* Column);
	__property bool SelectedRecords = {read=FSelectedRecords, write=FSelectedRecords, nodefault};
	__property int Level = {read=FLevel, write=FLevel, default=0};
	
__published:
	__property System::Classes::TNotifyEvent OnFirst = {read=FOnFirst, write=FOnFirst};
	__property TSMEGetNext OnNext = {read=FOnNext, write=FOnNext};
	__property TSMEGetCount OnCount = {read=FOnCount, write=FOnCount};
	__property System::Classes::TNotifyEvent OnBeforeExecute = {read=FOnBeforeExecute, write=FOnBeforeExecute};
	__property System::Classes::TNotifyEvent OnAfterExecute = {read=FOnAfterExecute, write=FOnAfterExecute};
	__property System::Classes::TNotifyEvent OnFillColumns = {read=FOnFillColumns, write=FOnFillColumns};
	__property TSMEGetValue OnGetValue = {read=FOnGetValue, write=FOnGetValue};
public:
	/* TComponent.Create */ inline __fastcall virtual TSMECustomDataEngine(System::Classes::TComponent* AOwner) : System::Classes::TComponent(AOwner) { }
	/* TComponent.Destroy */ inline __fastcall virtual ~TSMECustomDataEngine() { }
	
};


class PASCALIMPLEMENTATION TSMEVirtualDataEngine : public TSMECustomDataEngine
{
	typedef TSMECustomDataEngine inherited;
	
private:
	int intCurRow;
	
public:
	virtual void __fastcall First();
	virtual void __fastcall Next();
	virtual bool __fastcall Eof();
	virtual System::Variant __fastcall GetFieldValue(TSMEColumn* Column);
public:
	/* TComponent.Create */ inline __fastcall virtual TSMEVirtualDataEngine(System::Classes::TComponent* AOwner) : TSMECustomDataEngine(AOwner) { }
	/* TComponent.Destroy */ inline __fastcall virtual ~TSMEVirtualDataEngine() { }
	
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE TCellType __fastcall GetValueType(Data::Db::TFieldType DataType, const System::Variant &Value, bool BlankIfZero);
extern DELPHI_PACKAGE Data::Db::TFieldType __fastcall CellType2FieldType(TCellType ct);
}	/* namespace Smeengine */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMEENGINE)
using namespace Smeengine;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMEEngineHPP
