﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ExportDS.pas' rev: 37.00 (Windows)

#ifndef ExportDSHPP
#define ExportDSHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <System.SysUtils.hpp>
#include <Vcl.Controls.hpp>
#include <Vcl.Graphics.hpp>
#include <System.UITypes.hpp>
#include <Winapi.Windows.hpp>
#include <SMEEngine.hpp>
#include <SMEStat.hpp>
#include <Data.DB.hpp>
#include <System.Variants.hpp>

//-- user supplied -----------------------------------------------------------

namespace Exportds
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS ESMEInvalidPropertyException;
class DELPHICLASS ESMEInvalidFileNameException;
class DELPHICLASS TSMExportStyle;
class DELPHICLASS TSMEDataFormats;
class DELPHICLASS TSMESendTo;
class DELPHICLASS TSMEDataLevel;
class DELPHICLASS TSMEDataLevels;
class DELPHICLASS TSMEStatistic;
class DELPHICLASS TSMECustomBaseComponent;
class DELPHICLASS TSMExportBaseComponent;
//-- type declarations -------------------------------------------------------
class PASCALIMPLEMENTATION ESMEInvalidPropertyException : public System::Sysutils::Exception
{
	typedef System::Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ inline __fastcall ESMEInvalidPropertyException(const System::UnicodeString Msg) : System::Sysutils::Exception(Msg) { }
	/* Exception.CreateFmt */ inline __fastcall ESMEInvalidPropertyException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High) : System::Sysutils::Exception(Msg, Args, Args_High) { }
	/* Exception.CreateRes */ inline __fastcall ESMEInvalidPropertyException(System::NativeUInt Ident)/* overload */ : System::Sysutils::Exception(Ident) { }
	/* Exception.CreateRes */ inline __fastcall ESMEInvalidPropertyException(System::PResStringRec ResStringRec)/* overload */ : System::Sysutils::Exception(ResStringRec) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMEInvalidPropertyException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMEInvalidPropertyException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High) { }
	/* Exception.CreateHelp */ inline __fastcall ESMEInvalidPropertyException(const System::UnicodeString Msg, int AHelpContext) : System::Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ inline __fastcall ESMEInvalidPropertyException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext) : System::Sysutils::Exception(Msg, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMEInvalidPropertyException(System::NativeUInt Ident, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMEInvalidPropertyException(System::PResStringRec ResStringRec, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMEInvalidPropertyException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMEInvalidPropertyException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High, AHelpContext) { }
	/* Exception.Destroy */ inline __fastcall virtual ~ESMEInvalidPropertyException() { }
	
};


class PASCALIMPLEMENTATION ESMEInvalidFileNameException : public System::Sysutils::Exception
{
	typedef System::Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ inline __fastcall ESMEInvalidFileNameException(const System::UnicodeString Msg) : System::Sysutils::Exception(Msg) { }
	/* Exception.CreateFmt */ inline __fastcall ESMEInvalidFileNameException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High) : System::Sysutils::Exception(Msg, Args, Args_High) { }
	/* Exception.CreateRes */ inline __fastcall ESMEInvalidFileNameException(System::NativeUInt Ident)/* overload */ : System::Sysutils::Exception(Ident) { }
	/* Exception.CreateRes */ inline __fastcall ESMEInvalidFileNameException(System::PResStringRec ResStringRec)/* overload */ : System::Sysutils::Exception(ResStringRec) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMEInvalidFileNameException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMEInvalidFileNameException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High) { }
	/* Exception.CreateHelp */ inline __fastcall ESMEInvalidFileNameException(const System::UnicodeString Msg, int AHelpContext) : System::Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ inline __fastcall ESMEInvalidFileNameException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext) : System::Sysutils::Exception(Msg, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMEInvalidFileNameException(System::NativeUInt Ident, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMEInvalidFileNameException(System::PResStringRec ResStringRec, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMEInvalidFileNameException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMEInvalidFileNameException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High, AHelpContext) { }
	/* Exception.Destroy */ inline __fastcall virtual ~ESMEInvalidFileNameException() { }
	
};


enum DECLSPEC_DENUM TTableTypeExport : unsigned char { teParadox, teDBase, teText, teHTML, teXLS, teExcel, teWord, teSYLK, teDIF, teWKS, teQuattro, teSQL, teXML, teAccess, teClipboard, teRTF, teSPSS, tePDF, teLDIF, teADO, teOpenOffice, teExcel2007, teJSON, teWord2007, teExcelXML };

typedef System::Set<TTableTypeExport, TTableTypeExport::teParadox, TTableTypeExport::teExcelXML> TExportFormatTypes;

enum DECLSPEC_DENUM TCharacterSet : unsigned char { csANSI_WINDOWS, csASCII_MSDOS, csEBCDIC, csUTF8, csUnicode };

typedef System::StaticArray<System::UnicodeString, 5> Exportds__3;

enum DECLSPEC_DENUM TSMEStyle : unsigned char { esNormal, esPriceList, esMSMoney, esBrick, esDesert, esEggplant, esLilac, esMaple, esMarine, esRose, esSpruce, esWheat };

class PASCALIMPLEMENTATION TSMExportStyle : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	TSMEStyle FStyle;
	System::Uitypes::TColor FOddColor;
	System::Uitypes::TColor FEvenColor;
	void __fastcall SetStyle(TSMEStyle Value);
	
public:
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property TSMEStyle Style = {read=FStyle, write=SetStyle, nodefault};
	__property System::Uitypes::TColor OddColor = {read=FOddColor, write=FOddColor, nodefault};
	__property System::Uitypes::TColor EvenColor = {read=FEvenColor, write=FEvenColor, nodefault};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMExportStyle() { }
	
public:
	/* TObject.Create */ inline __fastcall TSMExportStyle() : System::Classes::TPersistent() { }
	
};


enum DECLSPEC_DENUM TSMEDateOrder : unsigned char { doMDY, doDMY, doYMD, doYDM, doDYM, doMYD };

class PASCALIMPLEMENTATION TSMEDataFormats : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	TSMEDateOrder FDateOrder;
	System::WideChar FDateSeparator;
	System::WideChar FTimeSeparator;
	bool FFourDigitYear;
	bool FLeadingZerosInDate;
	System::WideChar FThousandSeparator;
	System::WideChar FDecimalSeparator;
	System::UnicodeString FCurrencyString;
	System::UnicodeString FCustomDateTimeFormat;
	System::UnicodeString FBooleanTrue;
	System::UnicodeString FBooleanFalse;
	bool FUseRegionalSettings;
	
public:
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	void __fastcall LoadRegionalSettings();
	System::UnicodeString __fastcall GetDateFormat();
	System::UnicodeString __fastcall GetTimeFormat();
	System::UnicodeString __fastcall GetDateTimeFormat();
	System::UnicodeString __fastcall GetDTSeparator(System::WideChar Value);
	
__published:
	__property TSMEDateOrder DateOrder = {read=FDateOrder, write=FDateOrder, default=0};
	__property System::WideChar DateSeparator = {read=FDateSeparator, write=FDateSeparator, nodefault};
	__property System::WideChar TimeSeparator = {read=FTimeSeparator, write=FTimeSeparator, nodefault};
	__property bool FourDigitYear = {read=FFourDigitYear, write=FFourDigitYear, nodefault};
	__property bool LeadingZerosInDate = {read=FLeadingZerosInDate, write=FLeadingZerosInDate, nodefault};
	__property System::WideChar ThousandSeparator = {read=FThousandSeparator, write=FThousandSeparator, nodefault};
	__property System::WideChar DecimalSeparator = {read=FDecimalSeparator, write=FDecimalSeparator, nodefault};
	__property System::UnicodeString CurrencyString = {read=FCurrencyString, write=FCurrencyString};
	__property System::UnicodeString CustomDateTimeFormat = {read=FCustomDateTimeFormat, write=FCustomDateTimeFormat};
	__property System::UnicodeString BooleanTrue = {read=FBooleanTrue, write=FBooleanTrue};
	__property System::UnicodeString BooleanFalse = {read=FBooleanFalse, write=FBooleanFalse};
	__property bool UseRegionalSettings = {read=FUseRegionalSettings, write=FUseRegionalSettings, nodefault};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMEDataFormats() { }
	
public:
	/* TObject.Create */ inline __fastcall TSMEDataFormats() : System::Classes::TPersistent() { }
	
};


class PASCALIMPLEMENTATION TSMESendTo : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::UnicodeString FEMailRecipient;
	System::UnicodeString FEMailCC;
	System::UnicodeString FEMailBCC;
	System::UnicodeString FEMailSubject;
	System::UnicodeString FEMailBody;
	bool FEMailOpen;
	
public:
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::UnicodeString EMailRecipient = {read=FEMailRecipient, write=FEMailRecipient};
	__property System::UnicodeString EMailCC = {read=FEMailCC, write=FEMailCC};
	__property System::UnicodeString EMailBCC = {read=FEMailBCC, write=FEMailBCC};
	__property System::UnicodeString EMailSubject = {read=FEMailSubject, write=FEMailSubject};
	__property System::UnicodeString EMailBody = {read=FEMailBody, write=FEMailBody};
	__property bool EMailOpenBeforeSend = {read=FEMailOpen, write=FEMailOpen, default=1};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMESendTo() { }
	
public:
	/* TObject.Create */ inline __fastcall TSMESendTo() : System::Classes::TPersistent() { }
	
};


typedef System::UnicodeString TSMEAbout;

typedef void __fastcall (__closure *TSMEBeforeRecordEvent)(System::TObject* Sender, bool &Accept);

typedef void __fastcall (__closure *TSMEAfterRecordEvent)(System::TObject* Sender, bool &Abort);

typedef void __fastcall (__closure *TGetRowHeightEvent)(System::TObject* Sender, int ARow, int &ARowHeight);

typedef void __fastcall (__closure *TGetCellParamsEvent)(System::TObject* Sender, Data::Db::TField* Field, Smeengine::TSMEString &Text, Vcl::Graphics::TFont* AFont, System::Classes::TAlignment &Alignment, System::Uitypes::TColor &Background, Smeengine::TCellType &CellType);

typedef void __fastcall (__closure *TSMEGetLanguageStringEvent)(System::TObject* Sender, int id, Smeengine::TSMEString &Text);

typedef void __fastcall (__closure *TSMEGetNextSelected)(System::TObject* Sender, int Index, Data::Db::TBookmark &Selected);

typedef void __fastcall (__closure *TSMEGetSelectedCount)(System::TObject* Sender, System::LongInt &Count);

typedef void __fastcall (__closure *TSMESpecificationEvent)(System::TObject* Sender, Smeengine::TSMEString &AFileName);

typedef void __fastcall (__closure *TSMEGetFileName)(System::TObject* Sender, int CurFileNumber, Smeengine::TSMEString &AFileName);

typedef void __fastcall (__closure *TSMEProgress)(System::TObject* Sender, int CurValue, int MaxValue, bool &Abort);

enum DECLSPEC_DENUM TColumnSource : unsigned char { csDBGrid, csDataSet, csDataEngine };

enum DECLSPEC_DENUM TSMELayout : unsigned char { elColumnar, elReversedColumnar, elTabularForm };

enum DECLSPEC_DENUM TActionAfterExport : unsigned char { aeNone, aeOpenView, aeEMail };

enum DECLSPEC_DENUM TSMOption : unsigned char { soFieldMask, soShowMessage, soBlankRowAfterCaptions, soMergeData, soWaitCursor, soDisableControls, soUseFieldNameAsCaption, soColLines, soRowLines, soColorsFonts, soExportBlankValues, soExportBands, soExportInvisibleFields, soAutoCloseStatistic, soReprintTitleForEveryRow };

typedef System::Set<TSMOption, TSMOption::soFieldMask, TSMOption::soReprintTitleForEveryRow> TSMOptions;

enum DECLSPEC_DENUM TSMEDataLevelOption : unsigned char { dloShowCaption, dloEmbededInParentLevel, dloOutlineLevel, dloCollapsedLevel, dloReprintTitles, dloAddTitle };

typedef System::Set<TSMEDataLevelOption, TSMEDataLevelOption::dloShowCaption, TSMEDataLevelOption::dloAddTitle> TSMEDataLevelOptions;

class PASCALIMPLEMENTATION TSMEDataLevel : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	bool FIsWWDBGrid;
	bool FIsTMSDBGrid;
	Smeengine::TSMEString FCaption;
	int FShiftCount;
	Smeengine::TSMEColumns* FColumns;
	Smeengine::TSMEGroupings* FGroupings;
	Smeengine::TSMEColumnBands* FBands;
	Vcl::Controls::TControl* FDBGrid;
	Data::Db::TDataSet* FDataSet;
	Smeengine::TSMECustomDataEngine* FDataEngine;
	TColumnSource FColumnSource;
	TSMELayout FLayout;
	bool FParentLayout;
	TSMEDataLevelOptions FOptions;
	TSMEDataLevels* FDetailSources;
	void __fastcall SetColumns(Smeengine::TSMEColumns* Value);
	void __fastcall SetGroupings(Smeengine::TSMEGroupings* Value);
	void __fastcall SetBands(Smeengine::TSMEColumnBands* Value);
	void __fastcall SetDBGrid(Vcl::Controls::TControl* AValue);
	void __fastcall SetDataSet(Data::Db::TDataSet* AValue);
	void __fastcall SetDataEngine(Smeengine::TSMECustomDataEngine* AValue);
	void __fastcall SetDetailSources(TSMEDataLevels* Value);
	
protected:
	TSMECustomBaseComponent* __fastcall GetSMEComponent();
	
public:
	bool IsCustomColumns;
	Smeengine::TSMECustomDataEngine* SourceDataEngine;
	void __fastcall CreateSourceDataEngine();
	void __fastcall DestroySourceDataEngine();
	__fastcall virtual TSMEDataLevel(System::Classes::TCollection* Collection);
	__fastcall virtual ~TSMEDataLevel();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	__property bool IsWWDBGrid = {read=FIsWWDBGrid, nodefault};
	__property bool IsTMSDBGrid = {read=FIsTMSDBGrid, nodefault};
	__property Smeengine::TSMEGroupings* Groupings = {read=FGroupings, write=SetGroupings};
	
__published:
	__property Smeengine::TSMEString Caption = {read=FCaption, write=FCaption};
	__property int ShiftCount = {read=FShiftCount, write=FShiftCount, default=1};
	__property Smeengine::TSMEColumns* Columns = {read=FColumns, write=SetColumns};
	__property Smeengine::TSMEColumnBands* Bands = {read=FBands, write=SetBands};
	__property Vcl::Controls::TControl* DBGrid = {read=FDBGrid, write=SetDBGrid};
	__property Data::Db::TDataSet* DataSet = {read=FDataSet, write=SetDataSet};
	__property Smeengine::TSMECustomDataEngine* DataEngine = {read=FDataEngine, write=SetDataEngine};
	__property TColumnSource ColumnSource = {read=FColumnSource, write=FColumnSource, nodefault};
	__property TSMELayout Layout = {read=FLayout, write=FLayout, default=0};
	__property bool ParentLayout = {read=FParentLayout, write=FParentLayout, default=1};
	__property TSMEDataLevelOptions Options = {read=FOptions, write=FOptions, default=54};
	__property TSMEDataLevels* DetailSources = {read=FDetailSources, write=SetDetailSources};
};


class PASCALIMPLEMENTATION TSMEDataLevels : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
public:
	TSMEDataLevel* operator[](int Index) { return this->Items[Index]; }
	
private:
	TSMECustomBaseComponent* FSMEControl;
	TSMEDataLevel* __fastcall GetDataLevel(int Index);
	void __fastcall SetDataLevel(int Index, TSMEDataLevel* Value);
	
protected:
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	
public:
	__fastcall TSMEDataLevels(TSMECustomBaseComponent* SMECntrl);
	HIDESBASE TSMEDataLevel* __fastcall Add();
	__property TSMEDataLevel* Items[int Index] = {read=GetDataLevel, write=SetDataLevel/*, default*/};
	__property TSMECustomBaseComponent* SMEControl = {read=FSMEControl};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TSMEDataLevels() { }
	
};


enum DECLSPEC_DENUM TSMEResult : unsigned char { erInProgress, erCompleted, erCanceled, erFailed };

enum DECLSPEC_DENUM TSMESection : unsigned char { esHeader, esBand, esTitle, esData, esFooter, esDetail };

class PASCALIMPLEMENTATION TSMEStatistic : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::LongInt FTotalCount;
	System::LongInt FTotalErrors;
	System::LongInt FUpdateStep;
	TSMEResult FResult;
	System::LongInt FCurrentRow;
	System::LongInt FCurrentCol;
	TSMESection FCurrentSection;
	int FCurrentDataLevel;
	int FCurrentRowHeight;
	
public:
	TSMEDataLevel* CurrentDetailLevel;
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	__property System::LongInt CurrentRow = {read=FCurrentRow, write=FCurrentRow, nodefault};
	__property System::LongInt CurrentCol = {read=FCurrentCol, write=FCurrentCol, nodefault};
	__property TSMESection CurrentSection = {read=FCurrentSection, write=FCurrentSection, nodefault};
	__property int CurrentDataLevel = {read=FCurrentDataLevel, write=FCurrentDataLevel, nodefault};
	
__published:
	__property System::LongInt TotalCount = {read=FTotalCount, write=FTotalCount, stored=false, nodefault};
	__property System::LongInt TotalErrors = {read=FTotalErrors, write=FTotalErrors, stored=false, nodefault};
	__property System::LongInt UpdateStep = {read=FUpdateStep, write=FUpdateStep, default=1};
	__property TSMEResult Result = {read=FResult, write=FResult, stored=false, nodefault};
	__property int CurrentRowHeight = {read=FCurrentRowHeight, write=FCurrentRowHeight, nodefault};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMEStatistic() { }
	
public:
	/* TObject.Create */ inline __fastcall TSMEStatistic() : System::Classes::TPersistent() { }
	
};


class PASCALIMPLEMENTATION TSMECustomBaseComponent : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	TSMEAbout FAbout;
	TSMOptions FOptions;
	System::UnicodeString FTitleStatus;
	TCharacterSet FCharacterSet;
	System::LongInt FRowsPerFile;
	bool FRightToLeft;
	bool FSelectedRecord;
	bool FAddTitle;
	Smeengine::TSMEString FKeyGenerator;
	bool FAnimatedStatus;
	bool FBlankIfZero;
	System::Classes::TStrings* FHeader;
	System::Classes::TStrings* FFooter;
	TSMExportStyle* FExportStyle;
	TSMEDataFormats* FDataFormats;
	TSMESendTo* FSendTo;
	bool FExportIfEmpty;
	Smeengine::TSMEPageSetup* FPageSetup;
	TSMEBeforeRecordEvent FOnBeforeRecord;
	TSMEAfterRecordEvent FOnAfterRecord;
	TGetRowHeightEvent FOnGetRowHeight;
	TGetCellParamsEvent FOnGetCellParams;
	TSMEGetLanguageStringEvent FOnGetLanguageString;
	System::Classes::TNotifyEvent FOnBeforeExecute;
	System::Classes::TNotifyEvent FOnAfterExecute;
	TSMEGetFileName FOnGetFileName;
	TSMEProgress FOnProgress;
	System::UnicodeString FSeparator;
	System::UnicodeString FTextQualifier;
	System::UnicodeString FRecordSeparator;
	bool FFixed;
	bool FAutoFitColumns;
	bool FAutoFilter;
	Smeengine::TSMEString FTableName;
	TTableTypeExport FTableType;
	TSMEStatistic* FStatistic;
	void __fastcall SetPageSetup(Smeengine::TSMEPageSetup* Value);
	void __fastcall SetExportStyle(TSMExportStyle* Value);
	void __fastcall SetSendTo(TSMESendTo* Value);
	System::Classes::TStrings* __fastcall GetHeader();
	void __fastcall SetHeader(System::Classes::TStrings* Value);
	System::Classes::TStrings* __fastcall GetFooter();
	void __fastcall SetFooter(System::Classes::TStrings* Value);
	int __fastcall GetExportedRecordCount();
	TSMEResult __fastcall GetExportResult();
	void __fastcall SetAbout(const TSMEAbout Value);
	
protected:
	virtual void __fastcall SetTableType(TTableTypeExport Value);
	Smeengine::TCellType __fastcall GetFieldType(Data::Db::TField* Field, bool BlankIfZero);
	virtual int __fastcall MappingVersion();
	System::Variant __fastcall GetSysValue(const Smeengine::TSMEString AName);
	void __fastcall AssignStyle(System::LongInt ARow, System::Uitypes::TColor &color);
	virtual void __fastcall Prepare();
	Smeengine::TSMEString __fastcall AddZeros(const Smeengine::TSMEString Source, int Len, bool IsLeading);
	virtual Smeengine::TSMEString __fastcall GetFieldStr(Data::Db::TField* Field, Smeengine::TSMEColumn* AColumn);
	Smeengine::TSMEString __fastcall GetLanguageString(int id);
	void __fastcall WriteBOMToStream(System::Classes::TStream* AStream, TCharacterSet ACharacterSet);
	__property System::Classes::TStrings* Header = {read=GetHeader, write=SetHeader};
	__property System::Classes::TStrings* Footer = {read=GetFooter, write=SetFooter};
	__property System::LongInt RowsPerFile = {read=FRowsPerFile, write=FRowsPerFile, default=0};
	__property TTableTypeExport TableType = {read=FTableType, write=SetTableType, nodefault};
	
public:
	__fastcall virtual TSMECustomBaseComponent(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMECustomBaseComponent();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	void __fastcall AboutSME();
	int __fastcall SendMail(const System::UnicodeString AFileName, const System::UnicodeString body);
	virtual System::UnicodeString __fastcall Extension();
	int __fastcall GetTitleRowCount();
	__property bool AddTitle = {read=FAddTitle, write=FAddTitle, default=0};
	__property TCharacterSet CharacterSet = {read=FCharacterSet, write=FCharacterSet, nodefault};
	__property TGetRowHeightEvent OnGetRowHeight = {read=FOnGetRowHeight, write=FOnGetRowHeight};
	__property TGetCellParamsEvent OnGetCellParams = {read=FOnGetCellParams, write=FOnGetCellParams};
	__property int ExportedRecordCount = {read=GetExportedRecordCount, nodefault};
	__property TSMEResult ExportResult = {read=GetExportResult, nodefault};
	__property Smeengine::TSMEPageSetup* PageSetup = {read=FPageSetup, write=SetPageSetup};
	__property TSMExportStyle* ExportStyle = {read=FExportStyle, write=SetExportStyle};
	__property Smeengine::TSMEString TableName = {read=FTableName, write=FTableName};
	__property System::UnicodeString TextQualifier = {read=FTextQualifier, write=FTextQualifier};
	__property System::UnicodeString Separator = {read=FSeparator, write=FSeparator};
	__property System::UnicodeString RecordSeparator = {read=FRecordSeparator, write=FRecordSeparator};
	__property bool Fixed = {read=FFixed, write=FFixed, nodefault};
	__property bool AutoFitColumns = {read=FAutoFitColumns, write=FAutoFitColumns, default=0};
	__property bool AutoFilter = {read=FAutoFilter, write=FAutoFilter, default=0};
	
__published:
	__property TSMEAbout About = {read=FAbout, write=SetAbout, stored=false};
	__property bool AnimatedStatus = {read=FAnimatedStatus, write=FAnimatedStatus, default=1};
	__property TSMEDataFormats* DataFormats = {read=FDataFormats, write=FDataFormats};
	__property Smeengine::TSMEString KeyGenerator = {read=FKeyGenerator, write=FKeyGenerator};
	__property bool SelectedRecord = {read=FSelectedRecord, write=FSelectedRecord, default=0};
	__property bool BlankIfZero = {read=FBlankIfZero, write=FBlankIfZero, default=0};
	__property TSMOptions Options = {read=FOptions, write=FOptions, default=8626};
	__property System::UnicodeString TitleStatus = {read=FTitleStatus, write=FTitleStatus};
	__property bool RightToLeft = {read=FRightToLeft, write=FRightToLeft, default=0};
	__property TSMESendTo* SendTo = {read=FSendTo, write=SetSendTo};
	__property bool ExportIfEmpty = {read=FExportIfEmpty, write=FExportIfEmpty, default=1};
	__property TSMEStatistic* Statistic = {read=FStatistic, write=FStatistic};
	__property TSMEGetLanguageStringEvent OnGetLanguageString = {read=FOnGetLanguageString, write=FOnGetLanguageString};
	__property TSMEBeforeRecordEvent OnBeforeRecord = {read=FOnBeforeRecord, write=FOnBeforeRecord};
	__property TSMEAfterRecordEvent OnAfterRecord = {read=FOnAfterRecord, write=FOnAfterRecord};
	__property System::Classes::TNotifyEvent OnBeforeExecute = {read=FOnBeforeExecute, write=FOnBeforeExecute};
	__property System::Classes::TNotifyEvent OnAfterExecute = {read=FOnAfterExecute, write=FOnAfterExecute};
	__property TSMEGetFileName OnGetFileName = {read=FOnGetFileName, write=FOnGetFileName};
	__property TSMEProgress OnProgress = {read=FOnProgress, write=FOnProgress};
};


typedef void __fastcall (__closure *TSMEGetParsedExpression)(System::TObject* Sender, Smeengine::TSMEGrouping* AGrouping, System::Variant &Value);

class PASCALIMPLEMENTATION TSMExportBaseComponent : public TSMECustomBaseComponent
{
	typedef TSMECustomBaseComponent inherited;
	
private:
	TActionAfterExport FActionAfterExport;
	Vcl::Controls::TControl* FDBGrid;
	Data::Db::TDataSet* FDataSet;
	Smeengine::TSMECustomDataEngine* FDataEngine;
	TColumnSource FColumnSource;
	TSMEDataLevels* FDetailSources;
	Vcl::Graphics::TFont* FDefaultFont;
	Smeengine::TSMEString FFileName;
	TSMEGetNextSelected FOnGetNextSelected;
	TSMEGetSelectedCount FOnGetSelectedCount;
	TSMESpecificationEvent FOnBeforeLoadSpecification;
	TSMESpecificationEvent FOnAfterLoadSpecification;
	TSMESpecificationEvent FOnBeforeSaveSpecification;
	TSMESpecificationEvent FOnAfterSaveSpecification;
	TSMEGetParsedExpression FOnExpression;
	Smeengine::TSMEString FSpecificationDir;
	Smeengine::TSMEColumns* FColumns;
	Smeengine::TSMEGroupings* FGroupings;
	Smeengine::TSMEColumnBands* FBands;
	TSMELayout FLayout;
	int FLastExportColumnIndex;
	System::LongInt intRecordCount;
	bool IsCustomColumns;
	bool IsAborted;
	System::WideChar oldDecimalSeparator;
	System::WideChar oldDateSeparator;
	System::WideChar oldTimeSeparator;
	System::WideChar oldThousandSeparator;
	System::UnicodeString oldCurrencyString;
	void __fastcall SetSpecificationDir(Smeengine::TSMEString Value);
	void __fastcall SetColumns(Smeengine::TSMEColumns* Value);
	void __fastcall SetGroupings(Smeengine::TSMEGroupings* Value);
	void __fastcall SetBands(Smeengine::TSMEColumnBands* Value);
	void __fastcall SetDBGrid(Vcl::Controls::TControl* AValue);
	void __fastcall SetDataSet(Data::Db::TDataSet* AValue);
	void __fastcall SetDataEngine(Smeengine::TSMECustomDataEngine* AValue);
	void __fastcall SetDetailSources(TSMEDataLevels* Value);
	void __fastcall SetDefaultFont(Vcl::Graphics::TFont* Value);
	
protected:
	bool boolAborted;
	Smestat::TfrmSMEProcess* frmSMEProcess;
	bool FIsWWDBGrid;
	bool FIsTMSDBGrid;
	Smeengine::TSMECustomDataEngine* SourceDataEngine;
	virtual void __fastcall CreateSourceDataEngine();
	virtual void __fastcall DestroySourceDataEngine();
	void __fastcall CreateDirIfNotExists(const Smeengine::TSMEString s);
	bool __fastcall DetailExists();
	bool __fastcall CreateProgressDlg(Smeengine::TSMEString strCaption, Smeengine::TSMEString strMessage, Smeengine::TSMEString strBtnCaption, System::LongInt MinValue, System::LongInt MaxValue, System::LongInt Progress);
	bool __fastcall DestroyProgressDlg();
	bool __fastcall UpdateProgressDlg(Smeengine::TSMEString strMessage, System::LongInt Progress);
	bool __fastcall ProgressCanceled();
	void __fastcall SetProgressCanceled(bool Value);
	virtual void __fastcall InternalBeforeProcess();
	virtual void __fastcall InternalAfterProcess();
	virtual void __fastcall SetTableType(TTableTypeExport Value);
	virtual void __fastcall AfterExport();
	virtual void __fastcall Notification(System::Classes::TComponent* AComponent, System::Classes::TOperation Operation);
	Data::Db::TBookmark __fastcall GetNextSelected(int i);
	int __fastcall GetSelectedCount();
	bool __fastcall IsMemoColumnExist();
	bool __fastcall IsTrialCount(int i);
	__property TSMELayout Layout = {read=FLayout, write=FLayout, default=0};
	
public:
	__fastcall virtual TSMExportBaseComponent(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMExportBaseComponent();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	void __fastcall BuildDefaultColumns();
	void __fastcall Execute();
	Data::Db::TDataSet* __fastcall GetDS();
	__classmethod System::UnicodeString __fastcall GetDefExt(int intIndex);
	virtual void __fastcall ApplyDefaultFont(Vcl::Graphics::TFont* AFont, bool ReadOwner);
	void __fastcall LoadSpecification(Smeengine::TSMEString strFileName);
	void __fastcall SaveSpecification(Smeengine::TSMEString SpecName, Smeengine::TSMEString FileName, bool ShowDialog);
	virtual void __fastcall LoadSpecificationFromStrings(System::Classes::TStrings* lstSpec);
	virtual void __fastcall LoadSpecificationFromStream(System::Classes::TStream* Stream);
	virtual void __fastcall SaveSpecificationToStream(System::Classes::TStream* Stream, const Smeengine::TSMEString SpecName);
	virtual void __fastcall SaveSpecificationToStringList(System::Classes::TStrings* List, const System::UnicodeString SpecName);
	__property bool IsWWDBGrid = {read=FIsWWDBGrid, nodefault};
	__property bool IsTMSDBGrid = {read=FIsTMSDBGrid, nodefault};
	__property TActionAfterExport ActionAfterExport = {read=FActionAfterExport, write=FActionAfterExport, default=0};
	__property Smeengine::TSMEString FileName = {read=FFileName, write=FFileName};
	__property int LastExportColumnIndex = {read=FLastExportColumnIndex, nodefault};
	__property TSMEDataLevels* DetailSources = {read=FDetailSources, write=SetDetailSources};
	__property Smeengine::TSMEGroupings* Groupings = {read=FGroupings, write=SetGroupings};
	__property TSMEGetParsedExpression OnExpression = {read=FOnExpression, write=FOnExpression};
	
__published:
	__property Smeengine::TSMEColumns* Columns = {read=FColumns, write=SetColumns};
	__property Smeengine::TSMEColumnBands* Bands = {read=FBands, write=SetBands};
	__property Vcl::Graphics::TFont* DefaultFont = {read=FDefaultFont, write=SetDefaultFont};
	__property Vcl::Controls::TControl* DBGrid = {read=FDBGrid, write=SetDBGrid};
	__property Data::Db::TDataSet* DataSet = {read=FDataSet, write=SetDataSet};
	__property Smeengine::TSMECustomDataEngine* DataEngine = {read=FDataEngine, write=SetDataEngine};
	__property TColumnSource ColumnSource = {read=FColumnSource, write=FColumnSource, default=0};
	__property Smeengine::TSMEString SpecificationDir = {read=FSpecificationDir, write=SetSpecificationDir};
	__property TSMEGetNextSelected OnGetNextSelected = {read=FOnGetNextSelected, write=FOnGetNextSelected};
	__property TSMEGetSelectedCount OnGetSelectedCount = {read=FOnGetSelectedCount, write=FOnGetSelectedCount};
	__property TSMESpecificationEvent OnBeforeLoadSpecification = {read=FOnBeforeLoadSpecification, write=FOnBeforeLoadSpecification};
	__property TSMESpecificationEvent OnAfterLoadSpecification = {read=FOnAfterLoadSpecification, write=FOnAfterLoadSpecification};
	__property TSMESpecificationEvent OnBeforeSaveSpecification = {read=FOnBeforeSaveSpecification, write=FOnBeforeSaveSpecification};
	__property TSMESpecificationEvent OnAfterSaveSpecification = {read=FOnAfterSaveSpecification, write=FOnAfterSaveSpecification};
};


//-- var, const, procedure ---------------------------------------------------
#define SMEVersion L"5.0 (b83)"
extern DELPHI_PACKAGE TExportFormatTypes AllFormats;
extern DELPHI_PACKAGE Smeengine::TSMEString GeneratorVer;
extern DELPHI_PACKAGE Exportds__3 arrCharacterSet;
static _DELPHI_CONST System::Int8 SMEDefaultRowHeight = System::Int8(0x14);
extern DELPHI_PACKAGE System::StaticArray<System::StaticArray<System::Uitypes::TColor, 2>, 12> arrStyleColor;
static _DELPHI_CONST System::Uitypes::TColor clMoneyGreen = System::Uitypes::TColor(12639424);
static _DELPHI_CONST System::Uitypes::TColor clSkyBlue = System::Uitypes::TColor(16776176);
extern DELPHI_PACKAGE void __fastcall AboutSMExport(void);
extern DELPHI_PACKAGE Smeengine::TSMEString __fastcall GetFileNameByGraphic(const Smeengine::TSMEString FileName, int intCurPicFile, Vcl::Graphics::TPicture* pic);
extern DELPHI_PACKAGE System::Classes::TList* __fastcall GetPropAsSelectedList(System::Classes::TComponent* comp);
extern DELPHI_PACKAGE System::UnicodeString __fastcall Translate(const System::UnicodeString s, bool IsEncrypt);
extern DELPHI_PACKAGE Smeengine::TSMEString __fastcall ReplaceHTMLSystemChars(const Smeengine::TSMEString s, TTableTypeExport ExportType);
extern DELPHI_PACKAGE System::UnicodeString __fastcall TblName(Data::Db::TDataSet* DS);
extern DELPHI_PACKAGE bool __fastcall IsNumericField(Data::Db::TField* Field);
extern DELPHI_PACKAGE bool __fastcall IsStringField(Data::Db::TField* Field);
extern DELPHI_PACKAGE Smeengine::TSMEString __fastcall UECode(bool WinToDOS, Smeengine::TSMEString s);
extern DELPHI_PACKAGE System::UnicodeString __fastcall EBCDICCode(System::UnicodeString s);
extern DELPHI_PACKAGE System::UnicodeString __fastcall PadLSpace(System::UnicodeString strStr, int intLen);
extern DELPHI_PACKAGE System::UnicodeString __fastcall PadCSpace(System::UnicodeString strStr, int intLen);
extern DELPHI_PACKAGE System::UnicodeString __fastcall PadRSpace(System::UnicodeString strStr, int intLen);
}	/* namespace Exportds */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_EXPORTDS)
using namespace Exportds;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// ExportDSHPP
