﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SME2DOCX.pas' rev: 37.00 (Windows)

#ifndef SME2DOCXHPP
#define SME2DOCXHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <Winapi.Windows.hpp>
#include <Vcl.Graphics.hpp>
#include <System.UITypes.hpp>
#include <System.SysUtils.hpp>
#include <Data.DB.hpp>
#include <SME2Cell.hpp>
#include <ExportDS.hpp>
#include <SMEEngine.hpp>
#include <SMEZipFile.hpp>

//-- user supplied -----------------------------------------------------------

namespace Sme2docx
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS ESMEWordException;
class DELPHICLASS TDOCObject;
class DELPHICLASS TDOCPicture;
class DELPHICLASS TDOCChunk;
class DELPHICLASS TDOCRTF;
class DELPHICLASS TDOCHTML;
class DELPHICLASS TDOCBookmark;
class DELPHICLASS TSMExportToWordX;
//-- type declarations -------------------------------------------------------
class PASCALIMPLEMENTATION ESMEWordException : public System::Sysutils::Exception
{
	typedef System::Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ inline __fastcall ESMEWordException(const System::UnicodeString Msg) : System::Sysutils::Exception(Msg) { }
	/* Exception.CreateFmt */ inline __fastcall ESMEWordException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High) : System::Sysutils::Exception(Msg, Args, Args_High) { }
	/* Exception.CreateRes */ inline __fastcall ESMEWordException(System::NativeUInt Ident)/* overload */ : System::Sysutils::Exception(Ident) { }
	/* Exception.CreateRes */ inline __fastcall ESMEWordException(System::PResStringRec ResStringRec)/* overload */ : System::Sysutils::Exception(ResStringRec) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMEWordException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMEWordException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High) { }
	/* Exception.CreateHelp */ inline __fastcall ESMEWordException(const System::UnicodeString Msg, int AHelpContext) : System::Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ inline __fastcall ESMEWordException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext) : System::Sysutils::Exception(Msg, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMEWordException(System::NativeUInt Ident, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMEWordException(System::PResStringRec ResStringRec, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMEWordException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMEWordException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High, AHelpContext) { }
	/* Exception.Destroy */ inline __fastcall virtual ~ESMEWordException() { }
	
};


enum DECLSPEC_DENUM TDOCObjectKind : unsigned char { dokUnknown, dokHyperlink, dokNote, dokPicture, dokImage, dokGraphic, dokRTF, dokHTML, dokBookmark };

class PASCALIMPLEMENTATION TDOCObject : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TDOCObjectKind FObjectKind;
	System::Word FFromCol;
	System::Word FFromRow;
	System::Word FToCol;
	System::Word FToRow;
	
public:
	virtual System::UnicodeString __fastcall GetID(int AIndex);
	__property TDOCObjectKind ObjectKind = {read=FObjectKind, write=FObjectKind, default=0};
	__property System::Word FromCol = {read=FFromCol, write=FFromCol, nodefault};
	__property System::Word FromRow = {read=FFromRow, write=FFromRow, nodefault};
	__property System::Word ToCol = {read=FToCol, write=FToCol, nodefault};
	__property System::Word ToRow = {read=FToRow, write=FToRow, nodefault};
public:
	/* TObject.Create */ inline __fastcall TDOCObject() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TDOCObject() { }
	
};


class PASCALIMPLEMENTATION TDOCPicture : public TDOCObject
{
	typedef TDOCObject inherited;
	
private:
	Vcl::Graphics::TPicture* FPicture;
	int FSize;
	
public:
	__fastcall virtual TDOCPicture();
	__fastcall virtual ~TDOCPicture();
	int __fastcall GetPictureSize();
	int __fastcall GetPictureType();
	System::UnicodeString __fastcall GetPictureExt();
	void __fastcall WriteToStream(System::Classes::TStream* strm);
	System::UnicodeString __fastcall GetAsString(bool ConvertToJpeg);
	__property Vcl::Graphics::TPicture* Picture = {read=FPicture, write=FPicture};
	__property int Size = {read=FSize, write=FSize, nodefault};
};


class PASCALIMPLEMENTATION TDOCChunk : public TDOCObject
{
	typedef TDOCObject inherited;
	
private:
	System::Classes::TMemoryStream* FData;
	
public:
	__fastcall virtual TDOCChunk();
	__fastcall virtual ~TDOCChunk();
	__property System::Classes::TMemoryStream* Data = {read=FData, write=FData};
};


class PASCALIMPLEMENTATION TDOCRTF : public TDOCChunk
{
	typedef TDOCChunk inherited;
	
protected:
	System::UnicodeString __fastcall GetFileName(int AIndex);
	
public:
	__fastcall virtual TDOCRTF();
	virtual System::UnicodeString __fastcall GetID(int AIndex);
public:
	/* TDOCChunk.Destroy */ inline __fastcall virtual ~TDOCRTF() { }
	
};


class PASCALIMPLEMENTATION TDOCHTML : public TDOCChunk
{
	typedef TDOCChunk inherited;
	
protected:
	System::UnicodeString __fastcall GetFileName(int AIndex);
	
public:
	__fastcall virtual TDOCHTML();
	virtual System::UnicodeString __fastcall GetID(int AIndex);
public:
	/* TDOCChunk.Destroy */ inline __fastcall virtual ~TDOCHTML() { }
	
};


class PASCALIMPLEMENTATION TDOCBookmark : public TDOCObject
{
	typedef TDOCObject inherited;
	
private:
	int FTocID;
	System::UnicodeString FName;
	System::UnicodeString FTitle;
	
protected:
	System::UnicodeString __fastcall GetName();
	
public:
	__fastcall virtual TDOCBookmark();
	__property int TocID = {read=FTocID, write=FTocID, nodefault};
	__property System::UnicodeString Name = {read=FName, write=FName};
	__property System::UnicodeString Title = {read=FTitle, write=FTitle};
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TDOCBookmark() { }
	
};


typedef void __fastcall (__closure *TSMEBeforeWriteStreamEvent)(System::TObject* Sender, System::Classes::TStream* &AStream);

class PASCALIMPLEMENTATION TSMExportToWordX : public Sme2cell::TSMExportToCellFile
{
	typedef Sme2cell::TSMExportToCellFile inherited;
	
private:
	Smezipfile::TZipArchive* fsDOCX;
	TSMEBeforeWriteStreamEvent FOnBeforeWriteStream;
	System::Classes::TList* lstFonts;
	System::Classes::TList* lstObjects;
	System::Classes::TStream* strmXMLDocument;
	System::UnicodeString strColumnWidths;
	System::Variant arrColWidths;
	void * __fastcall GetResourceAsPointer(System::WideChar * ResName, System::WideChar * ResType, /* out */ int &Size);
	System::UnicodeString __fastcall GetResourceAsString(System::WideChar * ResName, System::WideChar * ResType);
	
protected:
	int OpenedTRtagCount;
	virtual void __fastcall InternalBeforeProcess();
	virtual void __fastcall InternalAfterProcess();
	virtual void __fastcall InternalFileCreate(const Smeengine::TSMEString AFileName);
	virtual void __fastcall InternalFileClose();
	void __fastcall AddFileToArchive(const System::UnicodeString FileName, unsigned FAttr, const System::UnicodeString AValue);
	void __fastcall AddFileStreamToArchive(const System::UnicodeString FileName, System::Classes::TStream* AStream);
	System::UnicodeString __fastcall GetFontXML(Vcl::Graphics::TFont* fn);
	void __fastcall WriteFontFormats();
	void __fastcall WriteObjects();
	void __fastcall WriteStringToDocument(System::UnicodeString s);
	System::UnicodeString __fastcall GetXMLColor(System::Uitypes::TColor cl, bool IsBackColor, System::UnicodeString AFormatString);
	System::UnicodeString __fastcall GetXMLFont(Vcl::Graphics::TFont* fnt, System::Uitypes::TColor BackColor);
	System::UnicodeString __fastcall GetRPrTag(bool IsDataArea);
	System::UnicodeString __fastcall GetColumnProperties(int ACol, System::Uitypes::TColor BackColor);
	System::UnicodeString __fastcall GetTableStart();
	System::UnicodeString __fastcall GetTableFinish();
	System::UnicodeString __fastcall GetColSpan(int ColCount);
	System::UnicodeString __fastcall GetShiftRow(int ShiftCount);
	
public:
	__fastcall virtual TSMExportToWordX(System::Classes::TComponent* AOwner);
	virtual System::UnicodeString __fastcall Extension();
	int __fastcall AddObjectToDocument(TDOCObject* obj);
	virtual void __fastcall ApplyDefaultFont(Vcl::Graphics::TFont* AFont, bool ReadOwner);
	virtual void __fastcall WriteFileBegin();
	virtual void __fastcall WriteFileEnd();
	virtual void __fastcall CloseFileStream();
	virtual void __fastcall WriteDataBegin();
	virtual void __fastcall WriteDataEnd();
	virtual void __fastcall WriteData(Data::Db::TField* fld, Smeengine::TCellType &CellType, int ARow, int ACol, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	virtual void __fastcall WriteMergeData(Smeengine::TCellType &CellType, int ARow, int ACol, int AMergeCols, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	virtual void __fastcall WriteDimensions(int intRowCount, int intColCount);
	virtual void __fastcall WriteColWidth(int intCurColumn, int intColWidth);
	virtual void __fastcall WriteRowStart();
	virtual void __fastcall WriteRowEnd();
	__property TSMEBeforeWriteStreamEvent OnBeforeWriteStream = {read=FOnBeforeWriteStream, write=FOnBeforeWriteStream};
	
__published:
	__property PageSetup;
public:
	/* TSMExportBaseComponent.Destroy */ inline __fastcall virtual ~TSMExportToWordX() { }
	
};


//-- var, const, procedure ---------------------------------------------------
#define DocumentXMLHeader L"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\""\
	L"?>\r\n<w:document xmlns:ve=\"http://schemas.openxmlformats"\
	L".org/markup-compatibility/2006\" xmlns:o=\"urn:schemas-mic"\
	L"rosoft-com:office:office\" xmlns:r=\"http://schemas.openxm"\
	L"lformats.org/officeDocument/2006/relationships\" xmlns:m=\""\
	L"http://schemas.openxmlformats.org/officeDocument/2006/math"\
	L"\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:wp=\"ht"\
	L"tp://schemas.openxmlformats.org/drawingml/2006/wordprocess"\
	L"ingDrawing\" xmlns:w10=\"urn:schemas-microsoft-com:office:"\
	L"word\" xmlns:w=\"http://schemas.openxmlformats.org/wordpro"\
	L"cessingml/2006/main\" xmlns:wne=\"http://schemas.microsoft"\
	L".com/office/word/2006/wordml\"><w:body>"
}	/* namespace Sme2docx */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SME2DOCX)
using namespace Sme2docx;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SME2DOCXHPP
