﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SME2OLE.pas' rev: 37.00 (Windows)

#ifndef SME2OLEHPP
#define SME2OLEHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <System.SysUtils.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <System.UITypes.hpp>
#include <Data.DB.hpp>
#include <ExportDS.hpp>
#include <SME2Cell.hpp>
#include <SMEEngine.hpp>
#include <System.Variants.hpp>

//-- user supplied -----------------------------------------------------------

namespace Sme2ole
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMExportToExcel;
class DELPHICLASS TSMExportToWord;
class DELPHICLASS TSMExportToADODOA;
class DELPHICLASS TSMExportToAccess;
class DELPHICLASS TSMExportToOpenOffice;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TMSExcelVersion : unsigned char { evExcelAuto, evExcel2, evExcel2FarEast, evExcel3, evExcel4, evExcel5, evExcel7, evExcel9597, evExcel8, evExcel2007 };

class PASCALIMPLEMENTATION TSMExportToExcel : public Sme2cell::TSMExportToCellFile
{
	typedef Sme2cell::TSMExportToCellFile inherited;
	
private:
	TMSExcelVersion FExcelVersion;
	Smeengine::TSMEString FTemplateFile;
	bool IsNewestCom;
	bool FUseCurrentInstance;
	int FStartColumn;
	int FStartRow;
	bool FFreezeFixed;
	bool FDeleteDefaultSheets;
	Smeengine::TSMEString FPassword;
	Smeengine::TSMEString strLastFileName;
	bool FIsMemoColumnExist;
	System::Variant arrData;
	System::Uitypes::TColor colorDefault;
	System::Classes::TStrings* FPageHeader;
	System::Classes::TStrings* FPageFooter;
	System::Classes::TStrings* __fastcall GetPageHeader();
	void __fastcall SetPageHeader(System::Classes::TStrings* Value);
	System::Classes::TStrings* __fastcall GetPageFooter();
	void __fastcall SetPageFooter(System::Classes::TStrings* Value);
	bool __fastcall IsVersionStore();
	void __fastcall DrawBorder(const System::Variant &Range, bool IsVertical);
	
protected:
	int intMergedSheetRows;
	virtual void __fastcall InternalFileCreate(const Smeengine::TSMEString AFileName);
	virtual void __fastcall InternalSheetOpen(const Smeengine::TSMEString ACaption);
	virtual void __fastcall InternalSheetClose();
	virtual System::UnicodeString __fastcall GetFormat(Data::Db::TFieldType ft, int Precision);
	bool __fastcall IsFormula(const Smeengine::TSMEString Value);
	
public:
	System::Variant xls;
	System::Variant xlw;
	__fastcall virtual TSMExportToExcel(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMExportToExcel();
	virtual System::UnicodeString __fastcall Extension();
	void __fastcall SaveFileStream();
	virtual void __fastcall CloseFileStream();
	virtual void __fastcall WriteHeader();
	virtual void __fastcall WriteFooter();
	virtual void __fastcall WriteDimensions(int intRowCount, int intColCount);
	virtual void __fastcall WriteColWidth(int intCurColumn, int intColWidth);
	virtual void __fastcall WriteData(Data::Db::TField* fld, Smeengine::TCellType &CellType, int ARow, int ACol, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	virtual void __fastcall WriteMergeData(Smeengine::TCellType &CellType, int ARow, int ACol, int AMergeCols, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	virtual void __fastcall WriteRowStart();
	virtual void __fastcall WriteRowEnd();
	
__published:
	__property AutoFitColumns = {default=0};
	__property AutoFilter = {default=0};
	__property bool UseCurrentInstance = {read=FUseCurrentInstance, write=FUseCurrentInstance, default=0};
	__property TMSExcelVersion ExcelVersion = {read=FExcelVersion, write=FExcelVersion, stored=IsVersionStore, default=0};
	__property Smeengine::TSMEString TemplateFile = {read=FTemplateFile, write=FTemplateFile};
	__property bool FreezeFixed = {read=FFreezeFixed, write=FFreezeFixed, default=0};
	__property bool DeleteDefaultSheets = {read=FDeleteDefaultSheets, write=FDeleteDefaultSheets, default=0};
	__property Smeengine::TSMEString Password = {read=FPassword, write=FPassword};
	__property PageSetup;
	__property System::Classes::TStrings* PageHeader = {read=GetPageHeader, write=SetPageHeader};
	__property System::Classes::TStrings* PageFooter = {read=GetPageFooter, write=SetPageFooter};
	__property ActionAfterExport = {default=0};
	__property FileName = {default=0};
	__property int StartColumn = {read=FStartColumn, write=FStartColumn, default=0};
	__property int StartRow = {read=FStartRow, write=FStartRow, default=0};
	__property AddTitle = {default=0};
	__property CharacterSet;
	__property ExportStyle;
	__property Header;
	__property Footer;
	__property OnGetCellParams;
};


enum DECLSPEC_DENUM TSMEWordFileFormat : unsigned char { ewDefault, ewDocument, ewDocument97, ewText, ewDOSText, ewRTF, ewUnicodeText, ewHTML, ewWebArchive, ewFilteredHTML, ewXML, ewPDF, ewXPS, ewODT };

class PASCALIMPLEMENTATION TSMExportToWord : public Sme2cell::TSMExportToCellFile
{
	typedef Sme2cell::TSMExportToCellFile inherited;
	
private:
	bool IsNewestCom;
	bool FUseCurrentInstance;
	Smeengine::TSMEString FTemplateFile;
	Smeengine::TSMEString strLastFileName;
	System::Variant arrColWidths;
	int intTblRowCount;
	int intTblColCount;
	Smeengine::TSMEString FPassword;
	TSMEWordFileFormat FFileFormat;
	int __fastcall GetColorIndex(System::Uitypes::TColor color);
	float __fastcall GetMeasureMargin(Smeengine::TSMEMeasure Measure, float Value);
	
protected:
	int intTotalMergedCols;
	virtual void __fastcall InternalFileCreate(const Smeengine::TSMEString AFileName);
	
public:
	System::Variant word;
	System::Variant document;
	System::Variant table;
	__fastcall virtual TSMExportToWord(System::Classes::TComponent* AOwner);
	virtual System::UnicodeString __fastcall Extension();
	virtual void __fastcall CloseFileStream();
	virtual void __fastcall WriteDataBegin();
	virtual void __fastcall WriteDimensions(int intRowCount, int intColCount);
	virtual void __fastcall WriteColWidth(int intCurColumn, int intColWidth);
	virtual void __fastcall WriteData(Data::Db::TField* fld, Smeengine::TCellType &CellType, int ARow, int ACol, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	virtual void __fastcall WriteMergeData(Smeengine::TCellType &CellType, int ARow, int ACol, int AMergeCols, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	virtual void __fastcall WriteRowStart();
	
__published:
	__property bool UseCurrentInstance = {read=FUseCurrentInstance, write=FUseCurrentInstance, default=0};
	__property Smeengine::TSMEString TemplateFile = {read=FTemplateFile, write=FTemplateFile};
	__property AutoFitColumns = {default=0};
	__property Smeengine::TSMEString Password = {read=FPassword, write=FPassword};
	__property TSMEWordFileFormat FileFormat = {read=FFileFormat, write=FFileFormat, default=0};
	__property PageSetup;
	__property ActionAfterExport = {default=0};
	__property FileName = {default=0};
	__property AddTitle = {default=0};
	__property CharacterSet;
	__property ExportStyle;
	__property Header;
	__property Footer;
	__property OnGetCellParams;
public:
	/* TSMExportBaseComponent.Destroy */ inline __fastcall virtual ~TSMExportToWord() { }
	
};


class PASCALIMPLEMENTATION TSMExportToADODOA : public Exportds::TSMExportBaseComponent
{
	typedef Exportds::TSMExportBaseComponent inherited;
	
private:
	bool FUseCurrentInstance;
	Smeengine::TSMEString FUserName;
	Smeengine::TSMEString FPassword;
	
protected:
	bool IsNewestCom;
	Vcl::Graphics::TFont* fontUser;
	virtual void __fastcall InitializeConnection();
	virtual void __fastcall FinilizeConnection();
	virtual void __fastcall OpenDatabase(Smeengine::TSMEString Value);
	virtual bool __fastcall TableExists(const Smeengine::TSMEString Value);
	virtual void __fastcall DeleteTable(const Smeengine::TSMEString Value);
	virtual void __fastcall CreateNewTable();
	virtual void __fastcall OpenRecordset();
	virtual void __fastcall AddNewRecord();
	virtual void __fastcall UpdateField(int ACol, Data::Db::TField* fld, const System::Variant &Value);
	virtual void __fastcall PostRecord();
	virtual void __fastcall Prepare();
	
public:
	__fastcall virtual TSMExportToADODOA(System::Classes::TComponent* AOwner);
	
__published:
	__property bool UseCurrentInstance = {read=FUseCurrentInstance, write=FUseCurrentInstance, default=0};
	__property Smeengine::TSMEString UserName = {read=FUserName, write=FUserName};
	__property Smeengine::TSMEString Password = {read=FPassword, write=FPassword};
	__property ActionAfterExport = {default=0};
	__property FileName = {default=0};
	__property TableName = {default=0};
	__property CharacterSet;
	__property OnGetCellParams;
public:
	/* TSMExportBaseComponent.Destroy */ inline __fastcall virtual ~TSMExportToADODOA() { }
	
};


enum DECLSPEC_DENUM TMSAccessVersion : unsigned char { avAuto, avAccess97, avAccess2000, avAccess2007 };

class PASCALIMPLEMENTATION TSMExportToAccess : public TSMExportToADODOA
{
	typedef TSMExportToADODOA inherited;
	
private:
	TMSAccessVersion FMSAccessVersion;
	bool __fastcall IsVersionStore();
	
protected:
	virtual Smeengine::TSMEString __fastcall GetFieldStr(Data::Db::TField* Field, Smeengine::TSMEColumn* AColumn);
	virtual void __fastcall InitializeConnection();
	virtual void __fastcall FinilizeConnection();
	virtual void __fastcall OpenDatabase(Smeengine::TSMEString Value);
	virtual bool __fastcall TableExists(const Smeengine::TSMEString Value);
	virtual void __fastcall DeleteTable(const Smeengine::TSMEString Value);
	virtual void __fastcall CreateNewTable();
	virtual void __fastcall OpenRecordset();
	virtual void __fastcall AddNewRecord();
	virtual void __fastcall UpdateField(int ACol, Data::Db::TField* fld, const System::Variant &Value);
	virtual void __fastcall PostRecord();
	
public:
	System::OleVariant access;
	System::OleVariant db;
	System::OleVariant recordset;
	__fastcall virtual TSMExportToAccess(System::Classes::TComponent* AOwner);
	virtual System::UnicodeString __fastcall Extension();
	
__published:
	__property TMSAccessVersion MSAccessVersion = {read=FMSAccessVersion, write=FMSAccessVersion, stored=IsVersionStore, default=0};
public:
	/* TSMExportBaseComponent.Destroy */ inline __fastcall virtual ~TSMExportToAccess() { }
	
};


class PASCALIMPLEMENTATION TSMExportToOpenOffice : public Sme2cell::TSMExportToCellFile
{
	typedef Sme2cell::TSMExportToCellFile inherited;
	
private:
	bool IsNewestCom;
	bool FUseCurrentInstance;
	System::UnicodeString FFilterName;
	Smeengine::TSMEString strLastFileName;
	System::Variant arrColWidths;
	int intTblRowCount;
	int intTblColCount;
	
protected:
	int intTotalMergedCols;
	virtual void __fastcall InternalFileCreate(const Smeengine::TSMEString AFileName);
	System::Variant __fastcall MakePropertyValue(System::UnicodeString PropName, System::UnicodeString PropValue);
	Smeengine::TSMEString __fastcall FixPathChar(const Smeengine::TSMEString s);
	
public:
	System::Variant StarDesktop;
	System::Variant StarOffice;
	System::Variant Document;
	System::Variant Table;
	__fastcall virtual TSMExportToOpenOffice(System::Classes::TComponent* AOwner);
	virtual System::UnicodeString __fastcall Extension();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	virtual void __fastcall CloseFileStream();
	virtual void __fastcall WriteDataBegin();
	virtual void __fastcall WriteDimensions(int intRowCount, int intColCount);
	virtual void __fastcall WriteColWidth(int intCurColumn, int intColWidth);
	virtual void __fastcall WriteData(Data::Db::TField* fld, Smeengine::TCellType &CellType, int ARow, int ACol, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	virtual void __fastcall WriteMergeData(Smeengine::TCellType &CellType, int ARow, int ACol, int AMergeCols, Smeengine::TSMEString &AString, System::Classes::TAlignment &al, Smeengine::TSMEVerticalAlignment &alv, Vcl::Graphics::TFont* font, System::Uitypes::TColor &color);
	__classmethod void __fastcall GetFilterNames(System::Classes::TStrings* lst);
	
__published:
	__property bool UseCurrentInstance = {read=FUseCurrentInstance, write=FUseCurrentInstance, default=0};
	__property System::UnicodeString FilterName = {read=FFilterName, write=FFilterName};
	__property ActionAfterExport = {default=0};
	__property FileName = {default=0};
	__property AddTitle = {default=0};
	__property CharacterSet;
	__property ExportStyle;
	__property Header;
	__property Footer;
	__property OnGetCellParams;
public:
	/* TSMExportBaseComponent.Destroy */ inline __fastcall virtual ~TSMExportToOpenOffice() { }
	
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE TMSExcelVersion DefaultExcelVersion;
extern DELPHI_PACKAGE TMSAccessVersion DefaultAccessVersion;
extern DELPHI_PACKAGE System::UnicodeString defOOFilterName;
extern DELPHI_PACKAGE bool __fastcall MSExcelIsInstalled(void);
extern DELPHI_PACKAGE bool __fastcall MSWordIsInstalled(void);
extern DELPHI_PACKAGE bool __fastcall MSAccessIsInstalled(void);
extern DELPHI_PACKAGE bool __fastcall MSJETIsInstalled(void);
extern DELPHI_PACKAGE bool __fastcall OpenOfficeIsInstalled(void);
extern DELPHI_PACKAGE void __fastcall GetAccessTableNames(System::Classes::TStrings* lst, const Smeengine::TSMEString DBName);
}	/* namespace Sme2ole */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SME2OLE)
using namespace Sme2ole;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SME2OLEHPP
