﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMEWiz.pas' rev: 37.00 (Windows)

#ifndef SMEWizHPP
#define SMEWizHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.Messages.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.Forms.hpp>
#include <Vcl.Dialogs.hpp>
#include <Vcl.Controls.hpp>
#include <Vcl.StdCtrls.hpp>
#include <Vcl.ExtCtrls.hpp>
#include <Data.DB.hpp>
#include <Vcl.CheckLst.hpp>
#include <Vcl.Menus.hpp>
#include <System.UITypes.hpp>
#include <ExportDS.hpp>
#include <SMEEngine.hpp>
#include <SME2SQL.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smewiz
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMECategories;
class DELPHICLASS TfrmSMEWizard;
class DELPHICLASS TSMEUserAccess;
class DELPHICLASS TSMEWizardDlg;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TSMEFileCategory : unsigned char { fceDocument, fceDatabase, fceSpreadsheet, fceWEB, fceOther };

class PASCALIMPLEMENTATION TSMECategories : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	bool FShowCategories;
	System::Uitypes::TColor FBackColor;
	Vcl::Graphics::TFont* FTextFont;
	Exportds::TExportFormatTypes FDocumentFormats;
	Exportds::TExportFormatTypes FDatabaseFormats;
	Exportds::TExportFormatTypes FSpreadsheetFormats;
	Exportds::TExportFormatTypes FWEBFormats;
	Exportds::TExportFormatTypes FOtherFormats;
	
protected:
	Vcl::Graphics::TFont* __fastcall GetTextFont();
	void __fastcall SetTextFont(Vcl::Graphics::TFont* Value);
	
public:
	__fastcall virtual TSMECategories();
	__fastcall virtual ~TSMECategories();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property bool ShowCategories = {read=FShowCategories, write=FShowCategories, default=1};
	__property System::Uitypes::TColor BackColor = {read=FBackColor, write=FBackColor, default=12935473};
	__property Vcl::Graphics::TFont* TextFont = {read=GetTextFont, write=SetTextFont};
	__property Exportds::TExportFormatTypes DocumentFormats = {read=FDocumentFormats, write=FDocumentFormats, default=9617476};
	__property Exportds::TExportFormatTypes DatabaseFormats = {read=FDatabaseFormats, write=FDatabaseFormats, default=534531};
	__property Exportds::TExportFormatTypes SpreadsheetFormats = {read=FSpreadsheetFormats, write=FSpreadsheetFormats, default=18941488};
	__property Exportds::TExportFormatTypes WEBFormats = {read=FWEBFormats, write=FWEBFormats, default=4198408};
	__property Exportds::TExportFormatTypes OtherFormats = {read=FOtherFormats, write=FOtherFormats, default=262528};
};


typedef void __fastcall (__closure *TSMEGetSpecificationsEvent)(System::TObject* Sender, System::Classes::TStrings* lstFiles);

typedef void __fastcall (__closure *TSMESaveSpecNotifyEvent)(System::TObject* Sender, const System::UnicodeString Caption, const System::UnicodeString FileName);

typedef void __fastcall (__closure *TSMECloseEvent)(System::TObject* Sender, System::Uitypes::TModalResult &Action);

typedef void __fastcall (__closure *TSMEStepChangeEvent)(System::TObject* Sender, bool &Allow);

enum DECLSPEC_DENUM TSMEDirection : unsigned char { edForward, edBackward };

class PASCALIMPLEMENTATION TfrmSMEWizard : public Vcl::Forms::TForm
{
	typedef Vcl::Forms::TForm inherited;
	
	
private:
	typedef System::StaticArray<System::UnicodeString, 10> _TfrmSMEWizard__1;
	
	typedef System::StaticArray<System::UnicodeString, 10> _TfrmSMEWizard__2;
	
	
__published:
	Vcl::Stdctrls::TButton* btnPrev;
	Vcl::Stdctrls::TButton* btnNext;
	Vcl::Stdctrls::TButton* btnCancel;
	Vcl::Stdctrls::TLabel* lblStep;
	Vcl::Stdctrls::TButton* btnSpecs;
	Vcl::Extctrls::TImage* imgLogo;
	Vcl::Menus::TPopupMenu* pmColumns;
	Vcl::Menus::TMenuItem* miSelectAll;
	Vcl::Menus::TMenuItem* miUnselectAll;
	Vcl::Menus::TMenuItem* miInvertSelection;
	Vcl::Stdctrls::TButton* btnFirst;
	Vcl::Stdctrls::TButton* btnLast;
	Vcl::Extctrls::TPanel* pnlDescription;
	Vcl::Stdctrls::TLabel* lblCaption;
	Vcl::Stdctrls::TLabel* lblDescription;
	Vcl::Extctrls::TImage* imgBackground;
	Vcl::Extctrls::TImage* imgDescription;
	Vcl::Stdctrls::TLabel* lblStepInfo;
	Vcl::Menus::TMenuItem* miSeparator;
	Vcl::Menus::TMenuItem* miInsertSysVar;
	Vcl::Menus::TMenuItem* miSVRowNo;
	Vcl::Menus::TMenuItem* miSVColNo;
	Vcl::Menus::TMenuItem* miSVRecCount;
	Vcl::Menus::TMenuItem* miSVErrCount;
	Vcl::Menus::TMenuItem* miSVKeyGenerator;
	Vcl::Extctrls::TPaintBox* pbLogo;
	Vcl::Extctrls::TPanel* pnlStep1;
	Vcl::Extctrls::TRadioGroup* rgTableType;
	Vcl::Extctrls::TPanel* pnlCategory;
	Vcl::Forms::TScrollBox* sbCategory;
	Vcl::Extctrls::TPanel* pnlStep2;
	Vcl::Stdctrls::TLabel* lblFileOrigin;
	Vcl::Stdctrls::TComboBox* cbCharacterSet;
	Vcl::Stdctrls::TCheckBox* cbSelectedRecord;
	Vcl::Stdctrls::TCheckBox* cbAddTitle;
	Vcl::Stdctrls::TCheckBox* cbAddBlankRow;
	Vcl::Stdctrls::TCheckBox* cbBlankIfZero;
	Vcl::Stdctrls::TCheckBox* cbWithoutFieldMask;
	Vcl::Extctrls::TPanel* pnlStep3;
	Vcl::Stdctrls::TRadioButton* rbText1;
	Vcl::Stdctrls::TRadioButton* rbText2;
	Vcl::Extctrls::TRadioGroup* rgSeparator;
	Vcl::Stdctrls::TEdit* edSymbol;
	Vcl::Stdctrls::TLabel* lblRecSeparator;
	Vcl::Stdctrls::TComboBox* cbRecSeparator;
	Vcl::Stdctrls::TComboBox* cbQualifier;
	Vcl::Stdctrls::TLabel* lblQualifier;
	Vcl::Extctrls::TPanel* pnlStep4;
	Vcl::Stdctrls::TCheckBox* chkAddCreateTable;
	Vcl::Stdctrls::TCheckBox* chkMultiRowInsert;
	Vcl::Stdctrls::TLabel* lblFieldNameCharset;
	Vcl::Stdctrls::TComboBox* cbFieldNameCharset;
	Vcl::Stdctrls::TGroupBox* gbSQL;
	Vcl::Stdctrls::TLabel* lblCommit;
	Vcl::Stdctrls::TLabel* lblSQLQuote;
	Vcl::Stdctrls::TLabel* lblSQLTerm;
	Vcl::Stdctrls::TEdit* edCommit;
	Vcl::Stdctrls::TComboBox* cbSQLQuote;
	Vcl::Stdctrls::TComboBox* cbSQLTerm;
	Vcl::Stdctrls::TLabel* lblAddCommit;
	Vcl::Stdctrls::TEdit* edAddCommit;
	Vcl::Extctrls::TPanel* pnlStep5;
	Vcl::Stdctrls::TGroupBox* gbFormat;
	Vcl::Stdctrls::TLabel* lblDateOrder;
	Vcl::Stdctrls::TLabel* lblDateDelimiter;
	Vcl::Stdctrls::TLabel* lblTimeDelimiter;
	Vcl::Stdctrls::TLabel* lblDecimalSymbol;
	Vcl::Stdctrls::TLabel* lblThousandSymbol;
	Vcl::Stdctrls::TLabel* lblCurrencyString;
	Vcl::Stdctrls::TLabel* lblLogical;
	Vcl::Stdctrls::TComboBox* cbDateOrder;
	Vcl::Stdctrls::TEdit* edDateDelimiter;
	Vcl::Stdctrls::TEdit* edTimeDelimiter;
	Vcl::Stdctrls::TCheckBox* cbFourDigitYear;
	Vcl::Stdctrls::TCheckBox* cbLeadingZerosInDate;
	Vcl::Stdctrls::TEdit* edDecimalSymbol;
	Vcl::Stdctrls::TEdit* edThousandSymbol;
	Vcl::Stdctrls::TEdit* edCurrencyString;
	Vcl::Stdctrls::TEdit* edTrue;
	Vcl::Stdctrls::TEdit* edFalse;
	Vcl::Extctrls::TPanel* pnlStep6;
	Vcl::Checklst::TCheckListBox* clbFields;
	Vcl::Stdctrls::TLabel* lblWidth;
	Vcl::Stdctrls::TEdit* edWidth;
	Vcl::Stdctrls::TLabel* lblWidthFix;
	Vcl::Stdctrls::TGroupBox* gbTitle;
	Vcl::Stdctrls::TLabel* lblTitleCaption;
	Vcl::Stdctrls::TLabel* lblTitleAlignment;
	Vcl::Stdctrls::TLabel* lblTitleColor;
	Vcl::Stdctrls::TLabel* lblTitleFont;
	Vcl::Stdctrls::TEdit* edTitleCaption;
	Vcl::Stdctrls::TEdit* edTitleFont;
	Vcl::Stdctrls::TComboBox* cbTitleAlignment;
	Vcl::Stdctrls::TComboBox* SMColorsCBTitle;
	Vcl::Stdctrls::TButton* btnTitleFont;
	Vcl::Stdctrls::TGroupBox* gbData;
	Vcl::Stdctrls::TLabel* lblDataAlignment;
	Vcl::Stdctrls::TLabel* lblDataColor;
	Vcl::Stdctrls::TLabel* lblDataFont;
	Vcl::Stdctrls::TEdit* edDataFont;
	Vcl::Stdctrls::TComboBox* cbDataAlignment;
	Vcl::Stdctrls::TComboBox* SMColorsCBData;
	Vcl::Stdctrls::TButton* btnDataFont;
	Vcl::Extctrls::TPanel* pnlStep7;
	Vcl::Stdctrls::TCheckBox* chkHeader;
	Vcl::Stdctrls::TMemo* memoHeader;
	Vcl::Stdctrls::TCheckBox* chkFooter;
	Vcl::Stdctrls::TMemo* memoFooter;
	Vcl::Extctrls::TPanel* pnlStep8;
	Vcl::Stdctrls::TGroupBox* gbOrientation;
	Vcl::Extctrls::TImage* imgOrientation;
	Vcl::Stdctrls::TRadioButton* rbOrientDefault;
	Vcl::Stdctrls::TRadioButton* rbOrientPortrait;
	Vcl::Stdctrls::TRadioButton* rbOrientLandscape;
	Vcl::Stdctrls::TCheckBox* chkAutofit;
	Vcl::Stdctrls::TGroupBox* gbMargin;
	Vcl::Stdctrls::TLabel* lblLeft;
	Vcl::Stdctrls::TLabel* lblTop;
	Vcl::Stdctrls::TLabel* lblRight;
	Vcl::Stdctrls::TLabel* lblBottom;
	Vcl::Stdctrls::TEdit* edMarginTop;
	Vcl::Stdctrls::TEdit* edMarginLeft;
	Vcl::Stdctrls::TEdit* edMarginRight;
	Vcl::Stdctrls::TEdit* edMarginBottom;
	Vcl::Extctrls::TPanel* pnlStep9;
	Vcl::Stdctrls::TRadioButton* rbColorsFonts;
	Vcl::Stdctrls::TRadioButton* rbDataOnly;
	Vcl::Extctrls::TRadioGroup* rgLayout;
	Vcl::Stdctrls::TLabel* lblStyle;
	Vcl::Stdctrls::TComboBox* cbColorStyle;
	Vcl::Stdctrls::TGroupBox* gbPreview;
	Vcl::Extctrls::TPaintBox* pbLayout;
	Vcl::Extctrls::TPanel* pnlStep10;
	Vcl::Stdctrls::TLabel* lblFileName;
	Vcl::Stdctrls::TEdit* edFileName;
	Vcl::Stdctrls::TButton* btnFileName;
	Vcl::Stdctrls::TCheckBox* cbMerged;
	Vcl::Stdctrls::TCheckBox* cbRowsPerFile;
	Vcl::Stdctrls::TEdit* edRowsPerFile;
	Vcl::Extctrls::TRadioGroup* rbActionAfterExport;
	Vcl::Stdctrls::TLabel* lblKeyGenerator;
	Vcl::Stdctrls::TEdit* edKeyGenerator;
	Vcl::Stdctrls::TComboBox* cbTableNames;
	Vcl::Stdctrls::TComboBox* cbAccessVersion;
	Vcl::Stdctrls::TComboBox* cbOOFileFilter;
	Vcl::Stdctrls::TLabel* lblTableName;
	Vcl::Stdctrls::TLabel* lblOOFileFilter;
	Vcl::Stdctrls::TCheckBox* chkAutoFilter;
	void __fastcall btnNextClick(System::TObject* Sender);
	void __fastcall btnPrevClick(System::TObject* Sender);
	void __fastcall FormCreate(System::TObject* Sender);
	void __fastcall FormActivate(System::TObject* Sender);
	void __fastcall FormCloseQuery(System::TObject* Sender, bool &CanClose);
	void __fastcall btnFileNameClick(System::TObject* Sender);
	void __fastcall rgSeparatorClick(System::TObject* Sender);
	void __fastcall edSymbolChange(System::TObject* Sender);
	void __fastcall rgTableTypeClick(System::TObject* Sender);
	void __fastcall btnCancelClick(System::TObject* Sender);
	void __fastcall PropertyExit(System::TObject* Sender);
	void __fastcall SMColorsCBTitleDrawItem(Vcl::Controls::TWinControl* Control, int Index, const Winapi::Windows::TRect &Rect, Winapi::Windows::TOwnerDrawState State);
	void __fastcall btnTitleFontClick(System::TObject* Sender);
	void __fastcall clbFieldsDragDrop(System::TObject* Sender, System::TObject* Source, int X, int Y);
	void __fastcall clbFieldsDragOver(System::TObject* Sender, System::TObject* Source, int X, int Y, System::Uitypes::TDragState State, bool &Accept);
	void __fastcall clbFieldsClick(System::TObject* Sender);
	void __fastcall cbTableNamesDropDown(System::TObject* Sender);
	void __fastcall edFileNameChange(System::TObject* Sender);
	void __fastcall btnSpecsClick(System::TObject* Sender);
	void __fastcall rgLayoutClick(System::TObject* Sender);
	void __fastcall pbLayoutPaint(System::TObject* Sender);
	void __fastcall miSelectAllClick(System::TObject* Sender);
	void __fastcall cbAddTitleClick(System::TObject* Sender);
	void __fastcall FormKeyDown(System::TObject* Sender, System::Word &Key, System::Classes::TShiftState Shift);
	void __fastcall btnFirstClick(System::TObject* Sender);
	void __fastcall btnLastClick(System::TObject* Sender);
	void __fastcall rbText2Click(System::TObject* Sender);
	void __fastcall pnlDescriptionResize(System::TObject* Sender);
	void __fastcall cbColorsFontsClick(System::TObject* Sender);
	void __fastcall rbOrientDefaultClick(System::TObject* Sender);
	void __fastcall miSVRowNoClick(System::TObject* Sender);
	void __fastcall pmColumnsPopup(System::TObject* Sender);
	void __fastcall clbFieldsClickCheck(System::TObject* Sender);
	void __fastcall FormResize(System::TObject* Sender);
	void __fastcall sbCategoryResize(System::TObject* Sender);
	void __fastcall chkHeaderClick(System::TObject* Sender);
	void __fastcall chkFooterClick(System::TObject* Sender);
	void __fastcall pbLogoPaint(System::TObject* Sender);
	void __fastcall cbTableNamesExit(System::TObject* Sender);
	
private:
	int intCurStep;
	int intCountStep;
	bool IsRun;
	TSMESaveSpecNotifyEvent OnSaveSpec;
	System::Classes::TNotifyEvent OnLoadSpec;
	TSMEGetSpecificationsEvent OnGetSpecifications;
	System::UnicodeString DefExt;
	System::UnicodeString FilterExt;
	System::UnicodeString TitleExt;
	TSMEDirection FDirection;
	int frmHeightMin;
	int frmHeightMax;
	int frmWidthMin;
	int frmWidthMax;
	bool __fastcall IsValidCurStep();
	void __fastcall UpdateButtons();
	void __fastcall UpdateMergeStatus();
	
protected:
	_TfrmSMEWizard__1 StepHeader;
	_TfrmSMEWizard__2 StepInfo;
	MESSAGE void __fastcall WMMinMaxInfo(Winapi::Messages::TWMGetMinMaxInfo &Msg);
	
public:
	bool IsCanceled;
	System::UnicodeString sCancel;
	System::UnicodeString sExecute;
	System::UnicodeString sStep;
	System::UnicodeString sAbort;
	TSMEWizardDlg* WizardDlg;
	Exportds::TTableTypeExport __fastcall GetTableTypeIndex();
	__property TSMEDirection Direction = {read=FDirection, nodefault};
public:
	/* TCustomForm.Create */ inline __fastcall virtual TfrmSMEWizard(System::Classes::TComponent* AOwner) : Vcl::Forms::TForm(AOwner) { }
	/* TCustomForm.CreateNew */ inline __fastcall virtual TfrmSMEWizard(System::Classes::TComponent* AOwner, int Dummy) : Vcl::Forms::TForm(AOwner, Dummy) { }
	/* TCustomForm.CreateScaledNew */ inline __fastcall virtual TfrmSMEWizard(System::Classes::TComponent* AOwner, int ADPI, int Dummy) : Vcl::Forms::TForm(AOwner, ADPI, Dummy) { }
	/* TCustomForm.Destroy */ inline __fastcall virtual ~TfrmSMEWizard() { }
	
public:
	/* TWinControl.CreateParented */ inline __fastcall TfrmSMEWizard(HWND ParentWindow) : Vcl::Forms::TForm(ParentWindow) { }
	
};


enum DECLSPEC_DENUM TSMERestriction : unsigned char { erDisabled, erReadOnly, erReadWrite };

typedef System::Set<TSMERestriction, TSMERestriction::erDisabled, TSMERestriction::erReadWrite> TSMERestrictions;

class PASCALIMPLEMENTATION TSMEUserAccess : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	bool FSpecification;
	bool FSpecificationSave;
	bool FSpecificationLoad;
	bool FSpecificationDelete;
	TSMERestriction FTableType;
	TSMERestriction FSourceFileName;
	TSMERestriction FFieldMapping;
	TSMERestriction FActionAfter;
	TSMERestriction FTextType;
	TSMERestriction FFieldDelimiter;
	TSMERestriction FTextQualifier;
	TSMERestriction FRecordSeparator;
	TSMERestriction FHeader;
	TSMERestriction FFooter;
	TSMERestriction FLayout;
	TSMERestriction FColorStyle;
	TSMERestriction FAccessVersion;
	TSMERestriction FKeyGenerator;
	TSMERestriction FSQLOptions;
	TSMERestriction FDataFormats;
	TSMERestriction FPageOrientation;
	TSMERestriction FPageMargins;
	
public:
	__fastcall virtual TSMEUserAccess(System::Classes::TComponent* AOwner);
	
__published:
	__property bool Specification = {read=FSpecification, write=FSpecification, nodefault};
	__property TSMERestriction TableType = {read=FTableType, write=FTableType, default=2};
	__property TSMERestriction SourceFileName = {read=FSourceFileName, write=FSourceFileName, default=2};
	__property TSMERestriction FieldMapping = {read=FFieldMapping, write=FFieldMapping, default=2};
	__property TSMERestriction ActionAfter = {read=FActionAfter, write=FActionAfter, default=2};
	__property TSMERestriction TextType = {read=FTextType, write=FTextType, default=2};
	__property TSMERestriction FieldDelimiter = {read=FFieldDelimiter, write=FFieldDelimiter, default=2};
	__property TSMERestriction TextQualifier = {read=FTextQualifier, write=FTextQualifier, default=2};
	__property TSMERestriction RecordSeparator = {read=FRecordSeparator, write=FRecordSeparator, default=2};
	__property TSMERestriction Header = {read=FHeader, write=FHeader, default=2};
	__property TSMERestriction Footer = {read=FFooter, write=FFooter, default=2};
	__property TSMERestriction Layout = {read=FLayout, write=FLayout, default=2};
	__property TSMERestriction ColorStyle = {read=FColorStyle, write=FColorStyle, default=2};
	__property TSMERestriction AccessVersion = {read=FAccessVersion, write=FAccessVersion, default=0};
	__property TSMERestriction DataFormats = {read=FDataFormats, write=FDataFormats, default=2};
	__property TSMERestriction SQLOptions = {read=FSQLOptions, write=FSQLOptions, default=2};
	__property TSMERestriction KeyGenerator = {read=FKeyGenerator, write=FKeyGenerator, default=0};
	__property TSMERestriction PageOrientation = {read=FPageOrientation, write=FPageOrientation, default=2};
	__property TSMERestriction PageMargins = {read=FPageMargins, write=FPageMargins, default=2};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMEUserAccess() { }
	
};


enum DECLSPEC_DENUM TSMEWizardStyle : unsigned char { wsWindows95, wsWindows2000 };

class PASCALIMPLEMENTATION TSMEWizardDlg : public Exportds::TSMExportBaseComponent
{
	typedef Exportds::TSMExportBaseComponent inherited;
	
private:
	System::Classes::THelpContext FHelpContext;
	TfrmSMEWizard* FfrmSMEWizard;
	Smeengine::TSMEFieldDisplayFormat FFieldDisplayFormat;
	bool FVisibleColumnsOnly;
	Exportds::TExportFormatTypes FFormats;
	Vcl::Controls::TCaption FTitle;
	Vcl::Graphics::TPicture* FPicture;
	bool FShowPicture;
	Vcl::Graphics::TIcon* FIcon;
	TSMECategories* FCategories;
	TSMEUserAccess* FUserAccess;
	bool FConfirmCancelExit;
	bool FConfirmFileOverwrite;
	bool FConfirmExecuteStart;
	System::UnicodeString FInitialDir;
	TSMEGetSpecificationsEvent FOnGetSpecifications;
	TSMECloseEvent FCloseEvent;
	TSMEWizardStyle FWizardStyle;
	bool FSetupSpecificationOnly;
	System::Classes::TNotifyEvent FOnShow;
	TSMEStepChangeEvent FOnStepChange;
	Sme2sql::TSMESQLOptions* FSQLOptions;
	System::UnicodeString FFilterName;
	Sme2sql::TSMESQLOptions* __fastcall GetSQLOptions();
	void __fastcall SetSQLOptions(Sme2sql::TSMESQLOptions* Value);
	TSMECategories* __fastcall GetCategories();
	void __fastcall SetCategories(TSMECategories* Value);
	TSMEUserAccess* __fastcall GetUserAccess();
	void __fastcall SetUserAccess(TSMEUserAccess* Value);
	void __fastcall SaveSpecClick(System::TObject* Sender, const System::UnicodeString Caption, const System::UnicodeString FileName);
	void __fastcall LoadSpecClick(System::TObject* Sender);
	Vcl::Graphics::TPicture* __fastcall GetPicture();
	void __fastcall SetPicture(Vcl::Graphics::TPicture* Value);
	Vcl::Graphics::TIcon* __fastcall GetIcon();
	void __fastcall SetIcon(Vcl::Graphics::TIcon* Value);
	System::UnicodeString __fastcall GetCaptionForFormat(Exportds::TTableTypeExport te);
	
protected:
	void __fastcall SetRestrictionToControls();
	void __fastcall PropertiesToControls();
	void __fastcall CreateCategories();
	
public:
	__fastcall virtual TSMEWizardDlg(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMEWizardDlg();
	HIDESBASE System::Uitypes::TModalResult __fastcall Execute();
	void __fastcall ExecuteWithoutDialog();
	virtual void __fastcall LoadSpecificationFromStrings(System::Classes::TStrings* lstSpec);
	virtual void __fastcall SaveSpecificationToStream(System::Classes::TStream* Stream, const Smeengine::TSMEString SpecName);
	void __fastcall ControlsToProperties();
	
__published:
	__property Smeengine::TSMEFieldDisplayFormat FieldDisplayFormat = {read=FFieldDisplayFormat, write=FFieldDisplayFormat, default=0};
	__property bool VisibleColumnsOnly = {read=FVisibleColumnsOnly, write=FVisibleColumnsOnly, default=0};
	__property System::Classes::THelpContext HelpContext = {read=FHelpContext, write=FHelpContext, default=0};
	__property Exportds::TExportFormatTypes Formats = {read=FFormats, write=FFormats, nodefault};
	__property Vcl::Controls::TCaption Title = {read=FTitle, write=FTitle};
	__property Vcl::Graphics::TPicture* Picture = {read=GetPicture, write=SetPicture};
	__property bool ShowPicture = {read=FShowPicture, write=FShowPicture, default=1};
	__property Vcl::Graphics::TIcon* Icon = {read=GetIcon, write=SetIcon};
	__property TSMECategories* Categories = {read=GetCategories, write=SetCategories};
	__property bool ConfirmCancelExit = {read=FConfirmCancelExit, write=FConfirmCancelExit, default=1};
	__property bool ConfirmFileOverwrite = {read=FConfirmFileOverwrite, write=FConfirmFileOverwrite, default=0};
	__property bool ConfirmExecuteStart = {read=FConfirmExecuteStart, write=FConfirmExecuteStart, default=0};
	__property System::UnicodeString InitialDir = {read=FInitialDir, write=FInitialDir};
	__property TSMEWizardStyle WizardStyle = {read=FWizardStyle, write=FWizardStyle, default=1};
	__property Layout = {default=0};
	__property RowsPerFile = {default=0};
	__property TextQualifier = {default=0};
	__property Separator = {default=0};
	__property RecordSeparator = {default=0};
	__property Fixed;
	__property AutoFitColumns = {default=0};
	__property AutoFilter = {default=0};
	__property TableName = {default=0};
	__property TableType;
	__property ActionAfterExport = {default=0};
	__property FileName = {default=0};
	__property AddTitle = {default=0};
	__property CharacterSet;
	__property ExportStyle;
	__property Header;
	__property Footer;
	__property TSMEUserAccess* UserAccess = {read=GetUserAccess, write=SetUserAccess};
	__property bool SetupSpecificationOnly = {read=FSetupSpecificationOnly, write=FSetupSpecificationOnly, default=0};
	__property Sme2sql::TSMESQLOptions* SQLOptions = {read=GetSQLOptions, write=SetSQLOptions};
	__property System::UnicodeString FilterName = {read=FFilterName, write=FFilterName};
	__property OnGetCellParams;
	__property TSMEGetSpecificationsEvent OnGetSpecifications = {read=FOnGetSpecifications, write=FOnGetSpecifications};
	__property TSMECloseEvent OnClose = {read=FCloseEvent, write=FCloseEvent};
	__property System::Classes::TNotifyEvent OnShow = {read=FOnShow, write=FOnShow};
	__property TSMEStepChangeEvent OnStepChange = {read=FOnStepChange, write=FOnStepChange};
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Smewiz */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMEWIZ)
using namespace Smewiz;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMEWizHPP
