﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMIBase.pas' rev: 37.00 (Windows)

#ifndef SMIBaseHPP
#define SMIBaseHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.Messages.hpp>
#include <System.SysUtils.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.Controls.hpp>
#include <Vcl.Forms.hpp>
#include <Vcl.Dialogs.hpp>
#include <Vcl.StdCtrls.hpp>
#include <Vcl.Buttons.hpp>
#include <Vcl.ExtCtrls.hpp>
#include <Data.DB.hpp>
#include <SMIStat.hpp>
#include <SMIPars.hpp>
#include <System.UITypes.hpp>
#include <System.Variants.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smibase
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS ESMIInvalidPropertyException;
class DELPHICLASS TSMIStatistic;
class DELPHICLASS TSMIDataFormats;
class DELPHICLASS TSMIColumn;
class DELPHICLASS TSMIColumns;
class DELPHICLASS TSMILoadCondition;
class DELPHICLASS TSMISQLFieldNameOptions;
class DELPHICLASS TSMISQLOptions;
class DELPHICLASS TSMImportBaseComponent;
//-- type declarations -------------------------------------------------------
#pragma pack(push,4)
class PASCALIMPLEMENTATION ESMIInvalidPropertyException : public System::Sysutils::Exception
{
	typedef System::Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ inline __fastcall ESMIInvalidPropertyException(const System::UnicodeString Msg) : System::Sysutils::Exception(Msg) { }
	/* Exception.CreateFmt */ inline __fastcall ESMIInvalidPropertyException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High) : System::Sysutils::Exception(Msg, Args, Args_High) { }
	/* Exception.CreateRes */ inline __fastcall ESMIInvalidPropertyException(System::NativeUInt Ident)/* overload */ : System::Sysutils::Exception(Ident) { }
	/* Exception.CreateRes */ inline __fastcall ESMIInvalidPropertyException(System::PResStringRec ResStringRec)/* overload */ : System::Sysutils::Exception(ResStringRec) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMIInvalidPropertyException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMIInvalidPropertyException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High) { }
	/* Exception.CreateHelp */ inline __fastcall ESMIInvalidPropertyException(const System::UnicodeString Msg, int AHelpContext) : System::Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ inline __fastcall ESMIInvalidPropertyException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext) : System::Sysutils::Exception(Msg, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMIInvalidPropertyException(System::NativeUInt Ident, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMIInvalidPropertyException(System::PResStringRec ResStringRec, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMIInvalidPropertyException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMIInvalidPropertyException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High, AHelpContext) { }
	/* Exception.Destroy */ inline __fastcall virtual ~ESMIInvalidPropertyException() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TTableTypeImport : unsigned char { teParadox, teDBase, teText, teHTML, teXLS, teWKS, teQuattro, teXML, teAccess, teWord, teADO, teSPSS, teADT, teDBISAM, teClarion, teClipboard, teWAB, teVCalendar, teODS, teOutlook, teSkype, teTopSpeed, teVCard };

typedef System::Set<TTableTypeImport, TTableTypeImport::teParadox, TTableTypeImport::teVCard> TImportFormatTypes;

enum DECLSPEC_DENUM TSMICharacterSet : unsigned char { csiANSI_WINDOWS, csiASCII_MSDOS, csiEBCDIC };

enum DECLSPEC_DENUM TImportMode : unsigned char { imAppend, imUpdate, imAppendUpdate, imDelete, imCopy, imAppendNewOnly };

typedef System::Set<TImportMode, TImportMode::imAppend, TImportMode::imAppendNewOnly> TImportModes;

enum DECLSPEC_DENUM TSMIAction : unsigned char { iaUnknown, iaAdd, iaUpdate, iaDelete };

enum DECLSPEC_DENUM TSMIResult : unsigned char { irUnknown, irExecuted, irCanceled, irFailed };

enum DECLSPEC_DENUM TSMIFieldDelimiter : unsigned char { fdNone, fdCustom, fdTab, fdSemicolon, fdComma, fdSpace };

enum DECLSPEC_DENUM TSMITextQualifier : unsigned char { tqNone, tqCustom, tqQuot, tqApos };

enum DECLSPEC_DENUM TSMIRecordSeparator : unsigned char { rsCustom, rsCRLF, rsCR, rsLF };

typedef System::UnicodeString TSMIAbout;

enum DECLSPEC_DENUM TSMIOption : unsigned char { soShowMessage, soExtendedStatistic, soSkipEmptyRow, soUseAnimatedControl, soWaitCursor, soAutoCloseStatistic };

typedef System::Set<TSMIOption, TSMIOption::soShowMessage, TSMIOption::soAutoCloseStatistic> TSMIOptions;

typedef void __fastcall (__closure *TBeforeRecordEvent)(System::TObject* Sender, const System::UnicodeString Fields, System::Variant &Values, bool &Accept);

typedef void __fastcall (__closure *TAfterRecordEvent)(System::TObject* Sender, bool &Abort);

typedef void __fastcall (__closure *TLocateRecordEvent)(System::TObject* Sender, const System::UnicodeString KeyFields, const System::Variant &Values, bool &Exist, bool &ExecuteLocate);

typedef void __fastcall (__closure *TBeforeFieldEvent)(System::TObject* Sender, Data::Db::TField* Field, System::Variant &Value, bool &Accept);

typedef void __fastcall (__closure *TSMIGetRowMode)(System::TObject* Sender, const System::Variant &Values, TImportMode &AModeForRow);

typedef void __fastcall (__closure *TGetCellParamsEvent)(System::TObject* Sender, Data::Db::TField* Field, System::Variant &Value);

typedef void __fastcall (__closure *TErrorEvent)(System::TObject* Sender, System::Sysutils::Exception* Error, bool &Abort);

class PASCALIMPLEMENTATION TSMIStatistic : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::LongInt FTotalCount;
	System::LongInt FTotalImported;
	System::LongInt FTotalAdded;
	System::LongInt FTotalDeleted;
	System::LongInt FTotalUpdated;
	System::LongInt FTotalErrors;
	System::LongInt FTotalSkipped;
	System::LongInt FUpdateStep;
	TSMIAction FLastAction;
	System::WideString FLastGeneratedSQL;
	TSMIResult FResult;
	System::LongInt FCurrentRow;
	System::LongInt FCurrentCol;
	System::Variant FCurrentParsedValue;
	
protected:
	System::Classes::TComponent* FSMICntrl;
	System::UnicodeString __fastcall GetCurrentRowsValues();
	
public:
	__fastcall virtual TSMIStatistic(System::Classes::TComponent* ASMICntrl);
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	__property System::WideString LastGeneratedSQL = {read=FLastGeneratedSQL};
	__property System::LongInt CurrentRow = {read=FCurrentRow, write=FCurrentRow, nodefault};
	__property System::LongInt CurrentCol = {read=FCurrentCol, write=FCurrentCol, nodefault};
	__property System::Variant CurrentParsedValue = {read=FCurrentParsedValue, write=FCurrentParsedValue};
	__property System::UnicodeString CurrentRowValues = {read=GetCurrentRowsValues};
	
__published:
	__property System::LongInt TotalCount = {read=FTotalCount, write=FTotalCount, nodefault};
	__property System::LongInt TotalImported = {read=FTotalImported, write=FTotalImported, stored=false, nodefault};
	__property System::LongInt TotalAdded = {read=FTotalAdded, write=FTotalAdded, stored=false, nodefault};
	__property System::LongInt TotalDeleted = {read=FTotalDeleted, write=FTotalDeleted, stored=false, nodefault};
	__property System::LongInt TotalUpdated = {read=FTotalUpdated, write=FTotalUpdated, stored=false, nodefault};
	__property System::LongInt TotalErrors = {read=FTotalErrors, write=FTotalErrors, stored=false, nodefault};
	__property System::LongInt TotalSkipped = {read=FTotalSkipped, write=FTotalSkipped, stored=false, nodefault};
	__property System::LongInt UpdateStep = {read=FUpdateStep, write=FUpdateStep, default=1};
	__property TSMIAction LastAction = {read=FLastAction, write=FLastAction, stored=false, nodefault};
	__property TSMIResult Result = {read=FResult, write=FResult, nodefault};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMIStatistic() { }
	
};


enum DECLSPEC_DENUM TSMIDateOrder : unsigned char { doMDY, doDMY, doYMD, doYDM, doDYM, doMYD };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMIDataFormats : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	TSMIDateOrder FDateOrder;
	System::WideChar FDateSeparator;
	System::WideChar FTimeSeparator;
	bool FFourDigitYear;
	bool FLeadingZerosInDate;
	System::WideChar FThousandSeparator;
	System::WideChar FDecimalSeparator;
	System::UnicodeString FCurrencyString;
	System::UnicodeString FCustomDateTimeFormat;
	System::UnicodeString FBooleanTrue;
	System::UnicodeString FBooleanFalse;
	bool FUseRegionalSettings;
	
public:
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	void __fastcall LoadRegionalSettings();
	System::UnicodeString __fastcall GetDateFormat();
	System::UnicodeString __fastcall GetTimeFormat(bool AddMiliseconds);
	System::UnicodeString __fastcall GetDateTimeFormat(bool ToAddTimePrefix);
	System::UnicodeString __fastcall GetDTSeparator(System::WideChar Value);
	
__published:
	__property TSMIDateOrder DateOrder = {read=FDateOrder, write=FDateOrder, default=0};
	__property System::WideChar DateSeparator = {read=FDateSeparator, write=FDateSeparator, nodefault};
	__property System::WideChar TimeSeparator = {read=FTimeSeparator, write=FTimeSeparator, nodefault};
	__property bool FourDigitYear = {read=FFourDigitYear, write=FFourDigitYear, nodefault};
	__property bool LeadingZerosInDate = {read=FLeadingZerosInDate, write=FLeadingZerosInDate, nodefault};
	__property System::UnicodeString CustomDateTimeFormat = {read=FCustomDateTimeFormat, write=FCustomDateTimeFormat};
	__property System::WideChar ThousandSeparator = {read=FThousandSeparator, write=FThousandSeparator, nodefault};
	__property System::WideChar DecimalSeparator = {read=FDecimalSeparator, write=FDecimalSeparator, nodefault};
	__property System::UnicodeString CurrencyString = {read=FCurrencyString, write=FCurrencyString};
	__property System::UnicodeString BooleanTrue = {read=FBooleanTrue, write=FBooleanTrue};
	__property System::UnicodeString BooleanFalse = {read=FBooleanFalse, write=FBooleanFalse};
	__property bool UseRegionalSettings = {read=FUseRegionalSettings, write=FUseRegionalSettings, nodefault};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMIDataFormats() { }
	
public:
	/* TObject.Create */ inline __fastcall TSMIDataFormats() : System::Classes::TPersistent() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TSMIDataType : unsigned char { itString, itInteger, itFloat, itDateTime, itDate, itTime, itBoolean, itBLOB, itMEMO, itGraphic };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMIColumn : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	System::UnicodeString FFieldName;
	System::UnicodeString FCaption;
	TSMIDataType FDataType;
	int FSize;
	int FPrecision;
	System::Classes::TAlignment FAlignment;
	
public:
	__fastcall virtual TSMIColumn(System::Classes::TCollection* Collection);
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::Classes::TAlignment Alignment = {read=FAlignment, write=FAlignment, default=0};
	__property System::UnicodeString FieldName = {read=FFieldName, write=FFieldName};
	__property System::UnicodeString Caption = {read=FCaption, write=FCaption};
	__property TSMIDataType DataType = {read=FDataType, write=FDataType, default=0};
	__property int Size = {read=FSize, write=FSize, nodefault};
	__property int Precision = {read=FPrecision, write=FPrecision, nodefault};
public:
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TSMIColumn() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMIColumns : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
public:
	TSMIColumn* operator[](int Index) { return this->Items[Index]; }
	
private:
	System::Classes::TComponent* FSMIControl;
	TSMIColumn* __fastcall GetColumn(int Index);
	void __fastcall SetColumn(int Index, TSMIColumn* Value);
	
protected:
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	
public:
	__fastcall TSMIColumns(System::Classes::TComponent* SMICntrl);
	HIDESBASE TSMIColumn* __fastcall Add();
	__property TSMIColumn* Items[int Index] = {read=GetColumn, write=SetColumn/*, default*/};
	__property System::Classes::TComponent* SMIControl = {read=FSMIControl};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TSMIColumns() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMILoadCondition : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::UnicodeString FLoadWhen;
	System::UnicodeString FSkipIf;
	
public:
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::UnicodeString LoadWhen = {read=FLoadWhen, write=FLoadWhen};
	__property System::UnicodeString SkipIf = {read=FSkipIf, write=FSkipIf};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMILoadCondition() { }
	
public:
	/* TObject.Create */ inline __fastcall TSMILoadCondition() : System::Classes::TPersistent() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TSMIFieldCharCase : unsigned char { ifcNormal, ifcUpperCase, ifcLowerCase, ifcProper };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMISQLFieldNameOptions : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::WideChar FSQLQuoteOpen;
	System::WideChar FSQLQuoteClose;
	
public:
	__fastcall virtual TSMISQLFieldNameOptions();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::WideChar SQLQuoteOpen = {read=FSQLQuoteOpen, write=FSQLQuoteOpen, default=91};
	__property System::WideChar SQLQuoteClose = {read=FSQLQuoteClose, write=FSQLQuoteClose, default=93};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMISQLFieldNameOptions() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMISQLOptions : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::UnicodeString FSQLTerm;
	System::WideChar FSQLQuote;
	TSMIFieldCharCase FFieldNameCharCase;
	TSMISQLFieldNameOptions* FFieldNameOptions;
	void __fastcall SetFieldNameOptions(TSMISQLFieldNameOptions* Value);
	
public:
	__fastcall virtual TSMISQLOptions();
	__fastcall virtual ~TSMISQLOptions();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property TSMIFieldCharCase FieldNameCharCase = {read=FFieldNameCharCase, write=FFieldNameCharCase, default=0};
	__property System::WideChar SQLQuote = {read=FSQLQuote, write=FSQLQuote, default=34};
	__property System::UnicodeString SQLTerm = {read=FSQLTerm, write=FSQLTerm};
	__property TSMISQLFieldNameOptions* FieldNameOptions = {read=FFieldNameOptions, write=SetFieldNameOptions};
};

#pragma pack(pop)

typedef void __fastcall (__closure *TSMIOnCreateStructure)(System::TObject* Sender, TSMIColumns* Columns);

typedef void __fastcall (__closure *TSMISpecificationEvent)(System::TObject* Sender, System::UnicodeString &AFileName);

typedef void __fastcall (__closure *TSMIParsedValue)(System::TObject* Sender, Data::Db::TField* Field, System::Variant &Value);

enum DECLSPEC_DENUM TSMITrimSpaces : unsigned char { tsNoTrim, tsTrimRight, tsTrimLeft, tsTrimLeftRight };

enum DECLSPEC_DENUM TSMIActionKind : unsigned char { akDatasetApply, akGenerateSQL };

class PASCALIMPLEMENTATION TSMImportBaseComponent : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	TSMIAbout FAbout;
	bool FAnimatedStatus;
	bool FAbortOnProblem;
	Data::Db::TDataSet* FDataSet;
	System::UnicodeString FDatasetKeys;
	System::Classes::TStrings* FMappings;
	TImportMode FMode;
	TSMILoadCondition* FLoadCondition;
	TSMISQLOptions* FSQLOptions;
	TSMIActionKind FActionKind;
	TSMIOptions FOptions;
	System::UnicodeString FTitleStatus;
	TSMIFieldDelimiter FFieldDelimiter;
	System::UnicodeString FFieldDelimiterCustom;
	TSMITextQualifier FTextQualifier;
	System::WideChar FTextQualifierCustom;
	TSMIRecordSeparator FRecordSeparator;
	System::UnicodeString FRecordSeparatorCustom;
	bool FFixed;
	System::UnicodeString FSourceFileName;
	int FRowFirst;
	int FRowLast;
	int FRowFieldNames;
	int FMaxScanRows;
	System::UnicodeString FTableName;
	TSMICharacterSet FCharacterSet;
	TSMIDataFormats* FDataFormats;
	TTableTypeImport FTableType;
	TSMITrimSpaces FTrimSpaces;
	int FCommitCount;
	TErrorEvent FOnErrorEvent;
	TGetCellParamsEvent FOnGetCellParams;
	TSMIParsedValue FOnParsedValue;
	Smipars::TOnEvaluate FOnParserEvaluate;
	System::Classes::TNotifyEvent FOnBeforeExecute;
	System::Classes::TNotifyEvent FOnAfterExecute;
	TBeforeRecordEvent FOnBeforeRecordEvent;
	TAfterRecordEvent FOnAfterRecordEvent;
	System::Classes::TNotifyEvent FOnBeforeUpdate;
	TBeforeFieldEvent FOnBeforeFieldUpdate;
	TSMIGetRowMode FOnGetRowMode;
	TSMISpecificationEvent FOnBeforeLoadSpecification;
	TSMISpecificationEvent FOnAfterLoadSpecification;
	TSMISpecificationEvent FOnBeforeSaveSpecification;
	TSMISpecificationEvent FOnAfterSaveSpecification;
	TLocateRecordEvent FOnLocateRecord;
	System::Classes::TNotifyEvent FOnStartTransaction;
	System::Classes::TNotifyEvent FOnFinishTransaction;
	System::UnicodeString FSpecificationDir;
	bool Abort;
	bool PausedProcess;
	TSMIStatistic* FStatistic;
	bool FUseDisplayNames;
	TSMIColumns* FColumns;
	Smipars::TSMIParameters* FParameters;
	TSMIOnCreateStructure FOnCreateStructure;
	void __fastcall SetParameters(Smipars::TSMIParameters* Value);
	Data::Db::TDataSet* __fastcall GetDataSet();
	void __fastcall SetDataSet(Data::Db::TDataSet* AValue);
	void __fastcall SetMappings(System::Classes::TStrings* AValue);
	void __fastcall SetAbout(const TSMIAbout Value);
	void __fastcall SetLoadCondition(TSMILoadCondition* Value);
	void __fastcall SetSQLOptions(TSMISQLOptions* Value);
	System::UnicodeString __fastcall Translate(const System::UnicodeString s, bool IsEncrypt);
	
protected:
	System::Variant vLocate;
	System::Variant vValues;
	System::Variant vFields;
	int intCurrentParsedFieldIndex;
	System::Classes::TStream* DataStream;
	Smistat::TfrmSMIProcess* frmSMIProcess;
	bool __fastcall CreateProgressDlg(System::UnicodeString strCaption, System::UnicodeString strMessage, System::UnicodeString strBtnCaption, System::UnicodeString strProcessed, System::UnicodeString strErrors, System::UnicodeString strAdded, System::UnicodeString strUpdated, System::UnicodeString strDeleted, bool ShowAnimated, bool ShowExtendedInfo);
	void __fastcall ChangeProgressDlg(System::LongInt MinValue, System::LongInt MaxValue, System::LongInt Progress);
	bool __fastcall DestroyProgressDlg();
	bool __fastcall UpdateProgressDlg(System::UnicodeString strMessage, System::LongInt Progress, System::LongInt intErrors, System::LongInt intAdded, System::LongInt intDeleted, System::LongInt intUpdated, System::LongInt intSkipped);
	bool __fastcall ProgressPaused();
	bool __fastcall ProgressCanceled();
	int __fastcall GetFieldItem(const System::UnicodeString FieldName);
	System::UnicodeString __fastcall GetTableName();
	bool __fastcall IsGoodRow(int i);
	virtual void __fastcall Prepare();
	virtual void __fastcall BeforeImport();
	virtual void __fastcall AfterImport();
	virtual void __fastcall BuildArrayIntersection();
	virtual void __fastcall BuildFieldMapping();
	virtual bool __fastcall LoadRecord();
	virtual void __fastcall GoFirst();
	virtual void __fastcall GoNext();
	virtual bool __fastcall NeedMore();
	virtual int __fastcall GetTotalCount();
	virtual System::Variant __fastcall GetValues(const System::UnicodeString strValues);
	virtual System::Variant __fastcall GetFieldValue(const System::Variant &v);
	virtual System::Variant __fastcall GetParsedValue(const System::Variant &v, int intFieldIndex);
	virtual bool __fastcall FieldIsTruncated();
	virtual void __fastcall Notification(System::Classes::TComponent* AComponent, System::Classes::TOperation Operation);
	virtual bool __fastcall NotDefined(System::UnicodeString &strProperty);
	void __fastcall CreateDirIfNotExists(const System::UnicodeString s);
	System::UnicodeString __fastcall GetKeyList(Data::Db::TDataSet* DS);
	void __fastcall FillKey4Locate();
	void __fastcall FillKey4Values();
	void __fastcall SetFieldDelimiter(TSMIFieldDelimiter Value);
	void __fastcall SetFieldDelimiterCustom(System::UnicodeString Value);
	void __fastcall SetTextQualifier(TSMITextQualifier Value);
	void __fastcall SetTextQualifierCustom(System::WideChar Value);
	void __fastcall SetRecordSeparator(TSMIRecordSeparator Value);
	void __fastcall SetRecordSeparatorCustom(System::UnicodeString Value);
	virtual bool __fastcall BLOBIsMIME();
	TSMIDataType __fastcall GetSMIDataType(Data::Db::TFieldType DataType);
	void __fastcall ParserEvaluate(System::TObject* Sender, System::UnicodeString Eval, System::Variant *Args, const System::NativeInt Args_High, int ArgCount, bool IsChild, System::Variant &Value, bool &Done);
	virtual bool __fastcall ProcessRowsForColumnTypes();
	__property TTableTypeImport TableType = {read=FTableType, write=FTableType, default=2};
	__property int MaxScanRows = {read=FMaxScanRows, write=FMaxScanRows, default=0};
	
public:
	__fastcall virtual TSMImportBaseComponent(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMImportBaseComponent();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	bool __fastcall AskParameters();
	void __fastcall Execute();
	virtual void __fastcall LoadFromStream(System::Classes::TStream* AStream);
	void __fastcall AboutSMI();
	void __fastcall PauseImport();
	void __fastcall ContinueImport();
	__classmethod virtual System::UnicodeString __fastcall Extension();
	__classmethod virtual System::UnicodeString __fastcall FillFileFilters();
	virtual void __fastcall DetectAutoMapping();
	virtual void __fastcall Columns2Mapping();
	virtual System::UnicodeString __fastcall GetColumnFieldName(int Index);
	System::Variant __fastcall EvaluateExpression(const System::UnicodeString Expression);
	void __fastcall LoadSpecification(System::UnicodeString strFileName);
	void __fastcall SaveSpecification(System::UnicodeString SpecName, System::UnicodeString FileName, bool ShowDialog);
	virtual void __fastcall LoadSpecificationFromStrings(System::Classes::TStrings* lstSpec);
	void __fastcall LoadSpecificationFromStream(System::Classes::TStream* Stream);
	virtual void __fastcall SaveSpecificationToStream(System::Classes::TStream* Stream, const System::UnicodeString SpecName);
	virtual void __fastcall SaveSpecificationToStringList(System::Classes::TStrings* List, const System::UnicodeString SpecName);
	__property TSMIColumns* Columns = {read=FColumns};
	__property TSMIFieldDelimiter FieldDelimiter = {read=FFieldDelimiter, write=SetFieldDelimiter, default=2};
	__property System::UnicodeString FieldDelimiterCustom = {read=FFieldDelimiterCustom, write=SetFieldDelimiterCustom};
	__property TSMITextQualifier TextQualifier = {read=FTextQualifier, write=SetTextQualifier, default=2};
	__property System::WideChar TextQualifierCustom = {read=FTextQualifierCustom, write=SetTextQualifierCustom, default=34};
	__property TSMIRecordSeparator RecordSeparator = {read=FRecordSeparator, write=SetRecordSeparator, default=1};
	__property System::UnicodeString RecordSeparatorCustom = {read=FRecordSeparatorCustom, write=SetRecordSeparatorCustom};
	__property System::UnicodeString SourceFileName = {read=FSourceFileName, write=FSourceFileName};
	__property bool Fixed = {read=FFixed, write=FFixed, nodefault};
	__property int RowFirst = {read=FRowFirst, write=FRowFirst, default=1};
	__property int RowLast = {read=FRowLast, write=FRowLast, default=2147483647};
	__property int RowFieldNames = {read=FRowFieldNames, write=FRowFieldNames, default=1};
	
__published:
	__property TSMIAbout About = {read=FAbout, write=SetAbout};
	__property bool AbortOnProblem = {read=FAbortOnProblem, write=FAbortOnProblem, nodefault};
	__property TSMIActionKind ActionKind = {read=FActionKind, write=FActionKind, default=0};
	__property bool AnimatedStatus = {read=FAnimatedStatus, write=FAnimatedStatus, nodefault};
	__property TSMICharacterSet CharacterSet = {read=FCharacterSet, write=FCharacterSet, default=0};
	__property TSMIDataFormats* DataFormats = {read=FDataFormats, write=FDataFormats};
	__property Data::Db::TDataSet* DataSet = {read=GetDataSet, write=SetDataSet};
	__property System::UnicodeString DatasetKeys = {read=FDatasetKeys, write=FDatasetKeys};
	__property TSMILoadCondition* LoadCondition = {read=FLoadCondition, write=SetLoadCondition};
	__property TSMISQLOptions* SQLOptions = {read=FSQLOptions, write=SetSQLOptions};
	__property System::Classes::TStrings* Mappings = {read=FMappings, write=SetMappings};
	__property TImportMode Mode = {read=FMode, write=FMode, default=0};
	__property TSMIOptions Options = {read=FOptions, write=FOptions, default=59};
	__property Smipars::TSMIParameters* Parameters = {read=FParameters, write=SetParameters};
	__property System::UnicodeString TableName = {read=FTableName, write=FTableName};
	__property System::UnicodeString TitleStatus = {read=FTitleStatus, write=FTitleStatus};
	__property TSMIStatistic* Statistic = {read=FStatistic, write=FStatistic};
	__property System::UnicodeString SpecificationDir = {read=FSpecificationDir, write=FSpecificationDir};
	__property bool UseDisplayNames = {read=FUseDisplayNames, write=FUseDisplayNames, nodefault};
	__property TSMITrimSpaces TrimSpaces = {read=FTrimSpaces, write=FTrimSpaces, default=0};
	__property int CommitCount = {read=FCommitCount, write=FCommitCount, default=300};
	__property TErrorEvent OnErrorEvent = {read=FOnErrorEvent, write=FOnErrorEvent};
	__property TGetCellParamsEvent OnGetCellParams = {read=FOnGetCellParams, write=FOnGetCellParams};
	__property TSMIParsedValue OnParsedValue = {read=FOnParsedValue, write=FOnParsedValue};
	__property Smipars::TOnEvaluate OnParserEvaluate = {read=FOnParserEvaluate, write=FOnParserEvaluate};
	__property System::Classes::TNotifyEvent OnBeforeExecute = {read=FOnBeforeExecute, write=FOnBeforeExecute};
	__property System::Classes::TNotifyEvent OnAfterExecute = {read=FOnAfterExecute, write=FOnAfterExecute};
	__property TBeforeRecordEvent OnBeforeRecordEvent = {read=FOnBeforeRecordEvent, write=FOnBeforeRecordEvent};
	__property TAfterRecordEvent OnAfterRecordEvent = {read=FOnAfterRecordEvent, write=FOnAfterRecordEvent};
	__property TSMIGetRowMode OnGetRowMode = {read=FOnGetRowMode, write=FOnGetRowMode};
	__property System::Classes::TNotifyEvent OnBeforeUpdate = {read=FOnBeforeUpdate, write=FOnBeforeUpdate};
	__property TBeforeFieldEvent OnBeforeFieldUpdate = {read=FOnBeforeFieldUpdate, write=FOnBeforeFieldUpdate};
	__property TSMISpecificationEvent OnBeforeLoadSpecification = {read=FOnBeforeLoadSpecification, write=FOnBeforeLoadSpecification};
	__property TSMISpecificationEvent OnAfterLoadSpecification = {read=FOnAfterLoadSpecification, write=FOnAfterLoadSpecification};
	__property TSMISpecificationEvent OnBeforeSaveSpecification = {read=FOnBeforeSaveSpecification, write=FOnBeforeSaveSpecification};
	__property TSMISpecificationEvent OnAfterSaveSpecification = {read=FOnAfterSaveSpecification, write=FOnAfterSaveSpecification};
	__property TLocateRecordEvent OnLocateRecord = {read=FOnLocateRecord, write=FOnLocateRecord};
	__property System::Classes::TNotifyEvent OnStartTransaction = {read=FOnStartTransaction, write=FOnStartTransaction};
	__property System::Classes::TNotifyEvent OnFinishTransaction = {read=FOnFinishTransaction, write=FOnFinishTransaction};
	__property TSMIOnCreateStructure OnCreateStructure = {read=FOnCreateStructure, write=FOnCreateStructure};
};


typedef void __fastcall (*TPreviewCallback)(System::TObject* grid, int intColumnCount, int intRecNo, bool IsASCII, const System::Variant &Value);

//-- var, const, procedure ---------------------------------------------------
#define SMIVersion L"3.0 (b71)"
static _DELPHI_CONST int MaxRowValue = int(2147483647);
extern DELPHI_PACKAGE void __fastcall AboutSMImport(void);
extern DELPHI_PACKAGE System::UnicodeString __fastcall GetDefExt(int intIndex);
extern DELPHI_PACKAGE System::UnicodeString __fastcall UECode(bool DOSToWin, System::UnicodeString St);
extern DELPHI_PACKAGE System::UnicodeString __fastcall EBCDICCode(System::UnicodeString s);
extern DELPHI_PACKAGE TImportFormatTypes __fastcall GetAvailableImportFormats(void);
}	/* namespace Smibase */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMIBASE)
using namespace Smibase;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMIBaseHPP
