﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMIPars.pas' rev: 37.00 (Windows)

#ifndef SMIParsHPP
#define SMIParsHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <System.SysUtils.hpp>
#include <System.Variants.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smipars
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS ESMIParseException;
class DELPHICLASS TExpToken;
class DELPHICLASS TExpParser;
class DELPHICLASS TExpNode;
class DELPHICLASS TSMIParser;
class DELPHICLASS TSMIParserFunction;
class DELPHICLASS TSMIParserFunctions;
class DELPHICLASS TSMIParameter;
class DELPHICLASS TSMIParameters;
//-- type declarations -------------------------------------------------------
#pragma pack(push,4)
class PASCALIMPLEMENTATION ESMIParseException : public System::Sysutils::Exception
{
	typedef System::Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ inline __fastcall ESMIParseException(const System::UnicodeString Msg) : System::Sysutils::Exception(Msg) { }
	/* Exception.CreateFmt */ inline __fastcall ESMIParseException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High) : System::Sysutils::Exception(Msg, Args, Args_High) { }
	/* Exception.CreateRes */ inline __fastcall ESMIParseException(System::NativeUInt Ident)/* overload */ : System::Sysutils::Exception(Ident) { }
	/* Exception.CreateRes */ inline __fastcall ESMIParseException(System::PResStringRec ResStringRec)/* overload */ : System::Sysutils::Exception(ResStringRec) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMIParseException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMIParseException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High) { }
	/* Exception.CreateHelp */ inline __fastcall ESMIParseException(const System::UnicodeString Msg, int AHelpContext) : System::Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ inline __fastcall ESMIParseException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext) : System::Sysutils::Exception(Msg, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMIParseException(System::NativeUInt Ident, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMIParseException(System::PResStringRec ResStringRec, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMIParseException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMIParseException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High, AHelpContext) { }
	/* Exception.Destroy */ inline __fastcall virtual ~ESMIParseException() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TTokenType : unsigned char { ttNone, ttString, ttNumeric, ttDateTime, ttParenthesis, ttOperation, ttParamDelimitor };

typedef void __fastcall (__closure *TOnEvaluate)(System::TObject* Sender, System::UnicodeString Eval, System::Variant *Args, const System::NativeInt Args_High, int ArgCount, bool IsChild, System::Variant &Value, bool &Done);

#pragma pack(push,4)
class PASCALIMPLEMENTATION TExpToken : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FText;
	TTokenType FTokenType;
	
public:
	__property System::UnicodeString Text = {read=FText};
	__property TTokenType TokenType = {read=FTokenType, nodefault};
public:
	/* TObject.Create */ inline __fastcall TExpToken() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TExpToken() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TExpParser : public System::TObject
{
	typedef System::TObject inherited;
	
protected:
	System::UnicodeString FExpression;
	System::Classes::TList* FTokens;
	int FPos;
	
private:
	void __fastcall Clear();
	TExpToken* __fastcall GetToken(int Index);
	void __fastcall SetExpression(const System::UnicodeString Value);
	
public:
	__fastcall TExpParser();
	__fastcall virtual ~TExpParser();
	TExpToken* __fastcall ReadFirstToken();
	TExpToken* __fastcall ReadNextToken();
	int __fastcall TokenCount();
	__property TExpToken* Tokens[int Index] = {read=GetToken};
	__property System::Classes::TList* TokenList = {read=FTokens};
	__property System::UnicodeString Expression = {read=FExpression, write=SetExpression};
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TExpNode : public System::TObject
{
	typedef System::TObject inherited;
	
protected:
	System::TObject* FOwner;
	TExpNode* FParent;
	System::Classes::TList* FChildren;
	System::Classes::TList* FTokens;
	int FLevel;
	TExpToken* FToken;
	TOnEvaluate FOnEvaluate;
	
private:
	TExpToken* __fastcall GetToken(int Index);
	TExpNode* __fastcall GetChildren(int Index);
	int __fastcall FindLSOTI();
	bool __fastcall ParseFunction();
	void __fastcall RemoveSorroundingParenthesis();
	void __fastcall SplitToChildren(int TokenIndex);
	System::Variant __fastcall Evaluate();
	__property TExpNode* Children[int Index] = {read=GetChildren};
	
public:
	__fastcall TExpNode(System::TObject* AOwner, TExpNode* AParent, System::Classes::TList* Tokens);
	__fastcall virtual ~TExpNode();
	void __fastcall Build();
	int __fastcall TokenCount();
	System::Variant __fastcall Calculate();
	__property TExpToken* Tokens[int Index] = {read=GetToken};
	__property TExpNode* Parent = {read=FParent};
	__property int Level = {read=FLevel, nodefault};
	__property TOnEvaluate OnEvaluate = {read=FOnEvaluate, write=FOnEvaluate};
};


class PASCALIMPLEMENTATION TSMIParser : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	bool FProcessBeforeEvent;
	System::UnicodeString FText;
	TOnEvaluate FOnEvaluate;
	System::Variant FValue;
	
protected:
	void __fastcall Compile(bool ToCalculate);
	System::Variant __fastcall GetValue();
	void __fastcall Evaluate(System::UnicodeString Eval, System::Variant *Args, const System::NativeInt Args_High, bool IsChild, System::Variant &Value);
	
public:
	__fastcall virtual TSMIParser(System::Classes::TComponent* AOwner);
	void __fastcall Validate();
	__property System::Variant Value = {read=GetValue};
	
__published:
	__property bool ProcessBeforeEvent = {read=FProcessBeforeEvent, write=FProcessBeforeEvent, nodefault};
	__property System::UnicodeString Text = {read=FText, write=FText};
	__property TOnEvaluate OnEvaluate = {read=FOnEvaluate, write=FOnEvaluate};
public:
	/* TComponent.Destroy */ inline __fastcall virtual ~TSMIParser() { }
	
};


class PASCALIMPLEMENTATION TSMIParserFunction : public System::TObject
{
	typedef System::TObject inherited;
	
	
private:
	typedef System::StaticArray<System::Variant, 11> _TSMIParserFunction__1;
	
	
protected:
	System::UnicodeString FAsString;
	System::UnicodeString FName;
	System::UnicodeString FFunction;
	System::UnicodeString FDescription;
	System::UnicodeString FHint;
	System::TObject* FOwner;
	int FArgCount;
	System::Classes::TStringList* FArgs;
	_TSMIParserFunction__1 FValues;
	System::UnicodeString FCategory;
	System::UnicodeString FSubCategory;
	
private:
	void __fastcall SetAsString(const System::UnicodeString Value);
	void __fastcall EvalArgs(System::TObject* Sender, System::UnicodeString Eval, System::Variant *Args, const System::NativeInt Args_High, int ArgCount, System::Variant &Value);
	
protected:
	void __fastcall ApplyArguments(System::Variant *Values, const System::NativeInt Values_High);
	
public:
	__fastcall TSMIParserFunction(System::TObject* AOwner);
	__fastcall virtual ~TSMIParserFunction();
	virtual System::Variant __fastcall Calculate();
	__property System::UnicodeString AsString = {read=FAsString, write=SetAsString};
	__property System::UnicodeString Name = {read=FName};
	__property int ArgCount = {read=FArgCount, nodefault};
	__property System::Classes::TStringList* Args = {read=FArgs};
	__property System::UnicodeString Description = {read=FDescription, write=FDescription};
	__property System::UnicodeString Hint = {read=FHint, write=FHint};
	__property System::UnicodeString Category = {read=FCategory, write=FCategory};
	__property System::UnicodeString SubCategory = {read=FSubCategory, write=FSubCategory};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMIParserFunctions : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	__fastcall virtual ~TSMIParserFunctions();
	TSMIParserFunction* __fastcall AddFunction(const System::UnicodeString Value);
	HIDESBASE void __fastcall Remove(int Index);
	TSMIParserFunction* __fastcall GetFunction(int Index);
	TSMIParserFunction* __fastcall FunctionByName(System::UnicodeString FuncName);
public:
	/* TObject.Create */ inline __fastcall TSMIParserFunctions() : System::Classes::TList() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TSMIParameterEditor : unsigned char { ipeEdit, ipeMemo, ipeCheckBox, ipeCombobox, ipeListBox };

enum DECLSPEC_DENUM TSMIParameterMode : unsigned char { ipmCalculate, ipmCalculateAndAsk, ipmAsk };

class PASCALIMPLEMENTATION TSMIParameter : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	System::UnicodeString FName;
	System::UnicodeString FCaption;
	System::UnicodeString FDescription;
	System::UnicodeString FExpression;
	TSMIParameterEditor FParameterEditor;
	TSMIParameterMode FParameterMode;
	System::Classes::TStrings* FParamPromptValues;
	bool FRequired;
	void __fastcall SetParamPromptValues(System::Classes::TStrings* Value);
	void __fastcall SetName(System::UnicodeString Value);
	
public:
	System::Variant Value;
	__fastcall virtual TSMIParameter(System::Classes::TCollection* Collection);
	__fastcall virtual ~TSMIParameter();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::UnicodeString Caption = {read=FCaption, write=FCaption};
	__property System::UnicodeString Name = {read=FName, write=SetName};
	__property System::UnicodeString Expression = {read=FExpression, write=FExpression};
	__property System::UnicodeString Description = {read=FDescription, write=FDescription};
	__property System::Classes::TStrings* ParamPromptValues = {read=FParamPromptValues, write=SetParamPromptValues};
	__property TSMIParameterEditor ParameterEditor = {read=FParameterEditor, write=FParameterEditor, default=0};
	__property TSMIParameterMode ParameterMode = {read=FParameterMode, write=FParameterMode, default=1};
	__property bool Required = {read=FRequired, write=FRequired, default=0};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMIParameters : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
public:
	TSMIParameter* operator[](int Index) { return this->Items[Index]; }
	
private:
	System::Classes::TComponent* FSMIControl;
	TSMIParameter* __fastcall GetParameter(int Index);
	void __fastcall SetParameter(int Index, TSMIParameter* Value);
	
protected:
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	
public:
	__fastcall TSMIParameters(System::Classes::TComponent* SMICntrl);
	HIDESBASE TSMIParameter* __fastcall Add();
	TSMIParameter* __fastcall ParamByName(const System::UnicodeString Value);
	__property System::Classes::TComponent* SMIControl = {read=FSMIControl};
	__property TSMIParameter* Items[int Index] = {read=GetParameter, write=SetParameter/*, default*/};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TSMIParameters() { }
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
static _DELPHI_CONST System::Int8 MAXPARAMCOUNT = System::Int8(0xa);
extern DELPHI_PACKAGE TSMIParserFunctions* lstSMIRegFunctions;
extern DELPHI_PACKAGE System::TDateTime __fastcall GetDTByMask(System::UnicodeString AValue, System::UnicodeString AFormat, System::WideChar ADateSeparator, System::WideChar ATimeSeparator);
extern DELPHI_PACKAGE System::UnicodeString __fastcall GetNextItem(System::WideChar chSeparator, System::UnicodeString &s, bool IsVal, bool IsLastToken);
extern DELPHI_PACKAGE bool __fastcall StringIsNumeric(System::UnicodeString Value);
extern DELPHI_PACKAGE System::UnicodeString __fastcall ReplaceStr(System::UnicodeString s, System::UnicodeString oldPattern, System::UnicodeString newPattern, bool IgnoreCase, bool ReplaceAll);
extern DELPHI_PACKAGE System::WideString __fastcall ReplaceWideStr(System::WideString s, System::WideString oldPattern, System::WideString newPattern, bool IgnoreCase, bool ReplaceAll);
extern DELPHI_PACKAGE bool __fastcall IsNumeric(System::UnicodeString s);
extern DELPHI_PACKAGE bool __fastcall IsAlpha(System::UnicodeString strStr);
}	/* namespace Smipars */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMIPARS)
using namespace Smipars;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMIParsHPP
