﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMCells.pas' rev: 37.00 (Windows)

#ifndef SMCellsHPP
#define SMCellsHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <System.SysUtils.hpp>
#include <System.Types.hpp>
#include <System.Variants.hpp>
#include <Winapi.Windows.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smcells
{
//-- forward type declarations -----------------------------------------------
struct TBIFFRecordHeader;
struct TBIFF12RecordHeader;
class DELPHICLASS TSMICell;
class DELPHICLASS TSpreadSheetCols;
class DELPHICLASS TSpreadSheetRow;
class DELPHICLASS TSpreadSheetCells;
class DELPHICLASS TSpreadSheet;
class DELPHICLASS TSpreadSheets;
class DELPHICLASS TSMRange;
class DELPHICLASS TCustomSpreadSheetFile;
class DELPHICLASS TSpreadSheetFile;
struct TBCD;
struct TSMIBCD;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TSMICellType : unsigned char { ictUnknown, ictEmpty, ictString, ictInteger, ictDecimal, ictDateTime, ictBoolean, ictMemo, ictDate, ictTime };

typedef void __fastcall (*TProgressPreviewCallback)(int Position, int TotalSize);

typedef void __fastcall (__closure *TOnColumnWidth)(System::TObject* Sender, int SheetNo, int ColumnNo, int Width);

typedef void __fastcall (__closure *TOnRowHeight)(System::TObject* Sender, int SheetNo, int RowNo, int Height);

typedef void __fastcall (__closure *TOnDimensions)(System::TObject* Sender, int SheetNo, int FirstRow, int LastRow, int FirstColumn, int LastColumn);

typedef void __fastcall (__closure *TOnCellValue)(System::TObject* Sender, int SheetNo, int Row, int Column, int FormatIndex, const System::Variant &Value, System::Classes::TAlignment Alignment, TSMICellType CellType);

typedef void __fastcall (__closure *TOnGetCellValue)(System::TObject* Sender, int SheetNo, int Row, int Column, System::Variant &Value);

typedef void __fastcall (__closure *TOnSheet)(System::TObject* Sender, System::WideString Caption, int Index, bool &Skip);

typedef void __fastcall (__closure *TOnSheetName)(System::TObject* Sender, System::WideString Caption, int Index);

typedef void __fastcall (__closure *TSMIOnPasswordEvent)(System::TObject* Sender, System::UnicodeString &APassword, bool &Continue);

#pragma pack(push,1)
struct DECLSPEC_DRECORD TBIFFRecordHeader
{
public:
	System::Word ID;
	System::Word Len;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TBIFF12RecordHeader
{
public:
	unsigned ID;
	unsigned Len;
};
#pragma pack(pop)


typedef void __fastcall (__closure *TOnRecord)(System::TObject* Sender, TBIFFRecordHeader Header, const System::Sysutils::TByteArray &Data);

class PASCALIMPLEMENTATION TSMICell : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::Variant FValue;
	System::Classes::TAlignment FAlignment;
	int FFormatIndex;
	TSMICellType FCellType;
	
public:
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::Variant Value = {read=FValue, write=FValue};
	__property System::Classes::TAlignment Alignment = {read=FAlignment, write=FAlignment, default=0};
	__property int FormatIndex = {read=FFormatIndex, write=FFormatIndex, nodefault};
	__property TSMICellType CellType = {read=FCellType, write=FCellType, default=0};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMICell() { }
	
public:
	/* TObject.Create */ inline __fastcall TSMICell() : System::Classes::TPersistent() { }
	
};


class PASCALIMPLEMENTATION TSpreadSheetCols : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	TSMICell* __fastcall GetCell(int Col);
	void __fastcall SetCell(int Col, TSMICell* Value);
public:
	/* TList.Destroy */ inline __fastcall virtual ~TSpreadSheetCols() { }
	
public:
	/* TObject.Create */ inline __fastcall TSpreadSheetCols() : System::Classes::TList() { }
	
};


enum DECLSPEC_DENUM TSMIRowStatus : unsigned char { rsNormal, rsDeleted, rsError };

typedef System::Set<TSMIRowStatus, TSMIRowStatus::rsNormal, TSMIRowStatus::rsError> TSMIRowStatuses;

class PASCALIMPLEMENTATION TSpreadSheetRow : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	int FOriginalRecNo;
	TSMIRowStatus FStatus;
	bool FVisible;
	int FRowHeight;
	
public:
	int Index;
	TSpreadSheetCols* Cols;
	__fastcall virtual TSpreadSheetRow();
	__fastcall virtual ~TSpreadSheetRow();
	void __fastcall ClearValues();
	__property int OriginalRecNo = {read=FOriginalRecNo, write=FOriginalRecNo, nodefault};
	__property TSMIRowStatus Status = {read=FStatus, write=FStatus, default=0};
	__property bool Visible = {read=FVisible, write=FVisible, default=1};
	__property int RowHeight = {read=FRowHeight, write=FRowHeight, default=0};
};


class PASCALIMPLEMENTATION TSpreadSheetCells : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
private:
	int FColCount;
	int FRowCount;
	
protected:
	int FUsedColCount;
	int FUsedRowCount;
	
public:
	bool AutoUsedRangeDetect;
	__fastcall virtual TSpreadSheetCells();
	__fastcall virtual ~TSpreadSheetCells();
	int __fastcall AddRow(int i);
	void __fastcall RemoveRow(int i);
	virtual void __fastcall Clear();
	void __fastcall ClearSort();
	void __fastcall SortByColumn(int AColIndex, bool Ascending);
	TSMICell* __fastcall GetCell(const int Col, const int Row);
	System::Variant __fastcall GetValue(const int Col, const int Row);
	void __fastcall SetValue(const int Col, const int Row, const System::Variant &Value, System::Classes::TAlignment Alignment, int FormatIndex, TSMICellType CellType);
	System::Variant __fastcall ValueByCell(const System::UnicodeString ACellRange);
	System::Variant __fastcall ValueByRange(const System::UnicodeString ARange);
	__property int UsedColCount = {read=FUsedColCount, nodefault};
	__property int UsedRowCount = {read=FUsedRowCount, nodefault};
	__property int ColCount = {read=FColCount, write=FColCount, nodefault};
	__property int RowCount = {read=FRowCount, write=FRowCount, nodefault};
};


class PASCALIMPLEMENTATION TSpreadSheet : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
public:
	TSpreadSheetCells* Cells;
	System::WideString Caption;
	System::Classes::TList* ColWidths;
	__fastcall virtual TSpreadSheet(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSpreadSheet();
	System::UnicodeString __fastcall PlainText();
};


_DECLARE_METACLASS(System::TMetaClass, TSpreadSheetClass);

class PASCALIMPLEMENTATION TSpreadSheets : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	TSpreadSheetClass DefaultSheetClass;
	__fastcall virtual ~TSpreadSheets();
	HIDESBASE int __fastcall Add();
	HIDESBASE void __fastcall Remove(int Index);
	virtual void __fastcall Clear();
	TSpreadSheet* __fastcall Spreadsheet(int Index);
	TSpreadSheet* __fastcall SheetByName(const System::WideString Value);
	int __fastcall SheetIndexByName(const System::WideString Value);
public:
	/* TObject.Create */ inline __fastcall TSpreadSheets() : System::Classes::TList() { }
	
};


class PASCALIMPLEMENTATION TSMRange : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	int FFirstRow;
	int FLastRow;
	int FFirstCol;
	int FLastCol;
	
public:
	__fastcall virtual TSMRange();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property int FirstRow = {read=FFirstRow, write=FFirstRow, default=1};
	__property int LastRow = {read=FLastRow, write=FLastRow, default=2147483647};
	__property int FirstCol = {read=FFirstCol, write=FFirstCol, default=1};
	__property int LastCol = {read=FLastCol, write=FLastCol, default=2147483647};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMRange() { }
	
};


typedef void __fastcall (__closure *TErrorParseRecord)(System::TObject* Sender, System::Sysutils::Exception* Error, bool &Abort);

typedef void __fastcall (__closure *TOnRecordStatusChanged)(System::TObject* Sender, int SheetNo, int ARow, TSMIRowStatus AStatus);

class PASCALIMPLEMENTATION TCustomSpreadSheetFile : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	System::UnicodeString FFileName;
	TErrorParseRecord FOnErrorProcess;
	bool FLoadNULLs;
	int FSheetIndex;
	TSMRange* FLoadRange;
	TOnColumnWidth FOnColumnWidth;
	TOnRowHeight FOnRowHeight;
	TOnDimensions FOnDimensions;
	TOnCellValue FOnCellValue;
	TOnGetCellValue FOnGetCellValue;
	TOnSheet FOnSheet;
	TOnSheetName FOnSheetName;
	TOnRecord FOnRecord;
	TOnRecordStatusChanged FOnRecordStatusChanged;
	void __fastcall SetLoadRange(TSMRange* Value);
	
public:
	bool IsIncrementalLoad;
	__fastcall virtual TCustomSpreadSheetFile(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TCustomSpreadSheetFile();
	virtual bool __fastcall IsEncrypted();
	__property int SheetIndex = {read=FSheetIndex, write=FSheetIndex, default=-1};
	__property TSMRange* LoadRange = {read=FLoadRange, write=SetLoadRange};
	
__published:
	__property System::UnicodeString FileName = {read=FFileName, write=FFileName};
	__property bool LoadNULLs = {read=FLoadNULLs, write=FLoadNULLs, default=0};
	__property TOnColumnWidth OnColumnWidth = {read=FOnColumnWidth, write=FOnColumnWidth};
	__property TOnRowHeight OnRowHeight = {read=FOnRowHeight, write=FOnRowHeight};
	__property TOnDimensions OnDimensions = {read=FOnDimensions, write=FOnDimensions};
	__property TOnCellValue OnCellValue = {read=FOnCellValue, write=FOnCellValue};
	__property TOnGetCellValue OnGetCellValue = {read=FOnGetCellValue, write=FOnGetCellValue};
	__property TOnSheet OnSheet = {read=FOnSheet, write=FOnSheet};
	__property TOnSheetName OnSheetName = {read=FOnSheetName, write=FOnSheetName};
	__property TOnRecord OnRecord = {read=FOnRecord, write=FOnRecord};
	__property TOnRecordStatusChanged OnRecordStatusChanged = {read=FOnRecordStatusChanged, write=FOnRecordStatusChanged};
	__property TErrorParseRecord OnErrorProcess = {read=FOnErrorProcess, write=FOnErrorProcess};
};


typedef void __fastcall (__closure *TOnLoadProgress)(System::TObject* Sender, int Position, int TotalSize);

enum DECLSPEC_DENUM TSMIColumnNameKind : unsigned char { nkAlphabet, nkFieldName };

enum DECLSPEC_DENUM TSMIParseItem : unsigned char { ipiText, ipiBLOB, ipiVBA, ipiPictures, ipiSummaryInformation, ipiComments };

typedef System::Set<TSMIParseItem, TSMIParseItem::ipiText, TSMIParseItem::ipiComments> TSMIParseItems;

class PASCALIMPLEMENTATION TSpreadSheetFile : public TCustomSpreadSheetFile
{
	typedef TCustomSpreadSheetFile inherited;
	
private:
	TOnLoadProgress FOnLoadProgress;
	TSMIColumnNameKind FNameKind;
	TSMIRowStatuses FLoadRowStatutes;
	TSMIParseItems FParseItems;
	void __fastcall DimsEvent(System::TObject* Sender, int SheetNo, int FirstRow, int LastRow, int FirstColumn, int LastColumn);
	void __fastcall SetCellEvent(System::TObject* Sender, int SheetNo, int Row, int Column, int FormatIndex, const System::Variant &Value, System::Classes::TAlignment Alignment, TSMICellType CellType);
	void __fastcall GetCellEvent(System::TObject* Sender, int SheetNo, int Row, int Column, System::Variant &Value);
	void __fastcall SheetEvent(System::TObject* Sender, System::WideString Caption, int Index, bool &Skip);
	void __fastcall SheetNameEvent(System::TObject* Sender, System::WideString Caption, int Index);
	void __fastcall ColumnWidthEvent(System::TObject* Sender, int SheetNo, int ColumnNo, int Width);
	void __fastcall RowHeightEvent(System::TObject* Sender, int SheetNo, int RowNo, int Height);
	
protected:
	TBIFFRecordHeader BufferHeader;
	bool CheckFileExists;
	void __fastcall UpdateProgress(int Position, int TotalSize);
	virtual void __fastcall ApplyEvents();
	virtual void __fastcall ReadBLOBValue(unsigned BlockNo, unsigned ASize, System::UnicodeString &s);
	virtual void __fastcall ReadBLOBUnicodeValue(unsigned BlockNo, unsigned ASize, System::WideString &s);
	void __fastcall SetRowStatus(int ASheetNo, int ARow, TSMIRowStatus AStatus);
	virtual void __fastcall InternalLoadFromOLEStream(System::Classes::TStream* Stream);
	
public:
	TSpreadSheets* Sheets;
	TProgressPreviewCallback ReadProgressCallback;
	int LastLoadedRecNo;
	__fastcall virtual TSpreadSheetFile(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSpreadSheetFile();
	virtual void __fastcall LoadFromFile(const System::WideString FileName);
	virtual void __fastcall LoadFromStream(System::Classes::TStream* AStream);
	virtual void __fastcall LoadFromOLEStream(System::Classes::TStream* AStream);
	virtual void __fastcall BeforeLoad();
	virtual void __fastcall AfterLoad();
	virtual bool __fastcall FindRecord(int RecNo);
	virtual bool __fastcall LoadRecord(int RecNo, int LogicalRecNo);
	virtual int __fastcall FindColumn(const System::UnicodeString AFieldName);
	virtual void __fastcall FillColumnList(System::Classes::TStrings* lst, const System::UnicodeString strFieldList);
	
__published:
	__property TSMIColumnNameKind NameKind = {read=FNameKind, write=FNameKind, default=0};
	__property TSMIRowStatuses LoadRowStatutes = {read=FLoadRowStatutes, write=FLoadRowStatutes, default=1};
	__property TOnLoadProgress OnLoadProgress = {read=FOnLoadProgress, write=FOnLoadProgress};
	__property TSMIParseItems ParseItems = {read=FParseItems, write=FParseItems, default=19};
};


#pragma pack(push,1)
struct DECLSPEC_DRECORD TBCD
{
public:
	System::Byte Precision;
	System::Byte SignSpecialPlaces;
	System::StaticArray<System::Byte, 32> Fraction;
};
#pragma pack(pop)


struct DECLSPEC_DRECORD TSMIBCD
{
public:
	System::Byte Ctrl;
	System::StaticArray<System::Byte, 16> Data;
};


//-- var, const, procedure ---------------------------------------------------
static _DELPHI_CONST System::Int8 ZARange = System::Int8(0x19);
extern DELPHI_PACKAGE bool __fastcall IsNan(const double AValue);
extern DELPHI_PACKAGE int __fastcall GetSpreadSheetColID(System::UnicodeString s, int MaxColCount);
extern DELPHI_PACKAGE System::UnicodeString __fastcall GetSpreadSheetColByID(int ID);
extern DELPHI_PACKAGE bool __fastcall BCDToCurr(const TBCD &BCD, System::Currency &Curr);
extern DELPHI_PACKAGE bool __fastcall SMBCDToCurr(const TSMIBCD &smibcd, int Len, double &dbl);
extern DELPHI_PACKAGE System::TDateTime __fastcall Julian2DMY(System::LongInt j);
extern DELPHI_PACKAGE double __fastcall DMY2Julian(const System::TDateTime AValue);
extern DELPHI_PACKAGE void __fastcall BuildColList(int UsedColCount, const System::UnicodeString strFieldList, System::Classes::TStrings* lst);
}	/* namespace Smcells */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMCELLS)
using namespace Smcells;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMCellsHPP
