﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMClarion.pas' rev: 37.00 (Windows)

#ifndef SMClarionHPP
#define SMClarionHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <SMCells.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smclarion
{
//-- forward type declarations -----------------------------------------------
struct TClarionField;
struct TClarionKey;
struct TClarionKeyItem;
class DELPHICLASS TClarionKeyValue;
class DELPHICLASS TClarionKeys;
struct TClarionPicture;
struct TClarionArrayHeader;
class DELPHICLASS TClarionArrayItem;
class DELPHICLASS TClarionArray;
class DELPHICLASS TClarionFieldLink;
class DELPHICLASS TClarionFieldLinks;
struct TClarionHeader;
struct TClarionRecordHeader;
struct TClarionMEMOHeader;
struct TClarionMEMORecord;
class DELPHICLASS TCustomClarion;
class DELPHICLASS TSMClarionTable;
class DELPHICLASS TClarion;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TClarionFieldType : unsigned char { cftUnknown, cftLong, cftReal, cftString, cftPicString, cftByte, cftShort, cftGroup, cftDecimal, cftMemo, cftSubGroup };

typedef System::StaticArray<System::UnicodeString, 11> Smclarion__1;

typedef System::StaticArray<char, 16> TClarionFieldName;

#pragma pack(push,1)
struct DECLSPEC_DRECORD TClarionField
{
public:
	System::Byte FieldType;
	TClarionFieldName FieldName;
	System::Word StartPos;
	System::Word Length;
	System::Byte Decimals;
	System::Byte Precision;
	System::Word ArrayNum;
	System::Word PicNum;
};
#pragma pack(pop)


typedef System::StaticArray<TClarionField, 512001> TClarionFields;

#pragma pack(push,1)
struct DECLSPEC_DRECORD TClarionKey
{
public:
	System::Byte NumComps;
	System::StaticArray<char, 16> KeyNames;
	System::Byte CompType;
	System::Byte CompLen;
};
#pragma pack(pop)


typedef TClarionKeyItem *PClarionKeyItem;

#pragma pack(push,1)
struct DECLSPEC_DRECORD TClarionKeyItem
{
public:
	System::Byte FieldType;
	System::Word FieldNum;
	System::Word ElementOffset;
	System::Byte ElementLen;
};
#pragma pack(pop)


class PASCALIMPLEMENTATION TClarionKeyValue : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TClarionKey KeyInfo;
	System::Classes::TList* Items;
	void __fastcall AddItem(const TClarionKeyItem &cki);
	void __fastcall ClearItems();
	System::UnicodeString __fastcall GetTypeStr(bool IncludeHexType);
	__fastcall virtual ~TClarionKeyValue();
public:
	/* TObject.Create */ inline __fastcall TClarionKeyValue() : System::TObject() { }
	
};


class PASCALIMPLEMENTATION TClarionKeys : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	TClarionKeyValue* __fastcall AddKey();
	void __fastcall DeleteKey(TClarionKeyValue* Value);
	void __fastcall ClearItems();
	__fastcall virtual ~TClarionKeys();
public:
	/* TObject.Create */ inline __fastcall TClarionKeys() : System::Classes::TList() { }
	
};


#pragma pack(push,1)
struct DECLSPEC_DRECORD TClarionPicture
{
public:
	System::Word PicLen;
	System::StaticArray<char, 256> PicStr;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TClarionArrayHeader
{
public:
	System::Word NumDim;
	System::Word TotalDim;
	System::Word ElementSize;
};
#pragma pack(pop)


class PASCALIMPLEMENTATION TClarionArrayItem : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::Word MaxDim;
	System::Word LenDim;
public:
	/* TObject.Create */ inline __fastcall TClarionArrayItem() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TClarionArrayItem() { }
	
};


class PASCALIMPLEMENTATION TClarionArray : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TClarionArrayHeader Header;
	System::Classes::TList* Items;
public:
	/* TObject.Create */ inline __fastcall TClarionArray() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TClarionArray() { }
	
};


enum DECLSPEC_DENUM TClarionFieldLinkKind : unsigned char { flkNone, flkGroup, flkSplitted };

class PASCALIMPLEMENTATION TClarionFieldLink : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TClarionFieldLinkKind LinkKind;
	int FieldIndex;
	System::UnicodeString FieldName;
	System::UnicodeString OriginalFieldName;
	int ParentFieldIndex;
	System::UnicodeString ParentFieldName;
	__fastcall virtual TClarionFieldLink(TClarionFieldLinkKind ALinkKind, int AFieldIndex, System::UnicodeString AFieldName, int AParentFieldIndex, System::UnicodeString AParentFieldName, const System::UnicodeString AOriginalFieldName);
public:
	/* TObject.Destroy */ inline __fastcall virtual ~TClarionFieldLink() { }
	
};


class PASCALIMPLEMENTATION TClarionFieldLinks : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	TClarionFieldLink* __fastcall GetLinkByFieldName(const System::UnicodeString AFieldName, TClarionFieldLinkKind LinkKind);
	TClarionFieldLink* __fastcall GetLink(int Index);
	void __fastcall RenameFieldName(const TClarionFieldName &OldFieldName, const System::UnicodeString NewFieldName);
	virtual void __fastcall Clear();
public:
	/* TList.Destroy */ inline __fastcall virtual ~TClarionFieldLinks() { }
	
public:
	/* TObject.Create */ inline __fastcall TClarionFieldLinks() : System::Classes::TList() { }
	
};


#pragma pack(push,1)
struct DECLSPEC_DRECORD TClarionHeader
{
public:
	System::Word Signature;
	System::Word Attribute;
	System::Byte NumberOfKeys;
	unsigned NumberOfRecords;
	unsigned NumberOfDeleted;
	System::Word NumberOfFields;
	System::Word NumberOfPictures;
	System::Word NumberOfArrays;
	System::Word RecordSize;
	unsigned Offset;
	unsigned LogicalEOF;
	unsigned LogicalBOF;
	unsigned FirstFreeRec;
	System::StaticArray<char, 12> RecName;
	System::StaticArray<char, 12> MemoName;
	System::StaticArray<char, 3> FileNamePrefix;
	System::StaticArray<char, 3> RecNamePrefix;
	System::Word MemoLength;
	System::Word MemoColWidth;
	unsigned LockCount;
	unsigned LastUpdateTime;
	unsigned LastUpdateDate;
	System::Word CheckSum;
};
#pragma pack(pop)


enum DECLSPEC_DENUM TClarionRecordStatus : unsigned char { crsNew, crsOld, crsRevised, crsDeleted, crsHeld };

#pragma pack(push,1)
struct DECLSPEC_DRECORD TClarionRecordHeader
{
public:
	TClarionRecordStatus Status;
	unsigned NextDeleted;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TClarionMEMOHeader
{
public:
	System::Word Signature;
	unsigned FirstDeleted;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TClarionMEMORecord
{
public:
	unsigned NextBlock;
	System::StaticArray<char, 252> MemoBlock;
};
#pragma pack(pop)


class PASCALIMPLEMENTATION TCustomClarion : public Smcells::TSpreadSheetFile
{
	typedef Smcells::TSpreadSheetFile inherited;
	
private:
	bool FAutoPatchFieldNames;
	bool FSplitArrayFields;
	System::UnicodeString FArrayFieldSeparator;
	
public:
	__fastcall virtual TCustomClarion(System::Classes::TComponent* AOwner);
	virtual System::UnicodeString __fastcall GetStrFieldType(System::Byte AType) = 0 ;
	virtual void __fastcall RenameFieldName(int FieldIndex, const System::UnicodeString FieldName) = 0 ;
	
__published:
	__property bool AutoPatchFieldNames = {read=FAutoPatchFieldNames, write=FAutoPatchFieldNames, default=1};
	__property bool SplitArrayFields = {read=FSplitArrayFields, write=FSplitArrayFields, default=0};
	__property System::UnicodeString ArrayFieldSeparator = {read=FArrayFieldSeparator, write=FArrayFieldSeparator};
public:
	/* TSpreadSheetFile.Destroy */ inline __fastcall virtual ~TCustomClarion() { }
	
};


class PASCALIMPLEMENTATION TSMClarionTable : public Smcells::TSpreadSheet
{
	typedef Smcells::TSpreadSheet inherited;
	
private:
	System::Word FID;
	System::UnicodeString FPassword;
	void __fastcall SetPassword(System::UnicodeString AValue);
	
public:
	TClarionHeader DBHeader;
	TClarionFields Fields;
	TClarionKeys* Keys;
	System::Classes::TList* ArrayFields;
	TClarionFieldLinks* FieldHiearachy;
	__fastcall virtual TSMClarionTable(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMClarionTable();
	void __fastcall ClearArrays();
	void __fastcall Crack();
	bool __fastcall CheckHeader();
	void __fastcall DecodeBuffer(void *Buffer, System::Word ASize);
	
__published:
	__property System::UnicodeString Password = {read=FPassword, write=SetPassword};
};


class PASCALIMPLEMENTATION TClarion : public TCustomClarion
{
	typedef TCustomClarion inherited;
	
private:
	System::Classes::TStream* BLOBStream;
	bool FDateAutodetect;
	System::UnicodeString __fastcall GetPassword();
	void __fastcall SetPassword(System::UnicodeString AValue);
	int __fastcall GetMemoBlockNo(int Value);
	TClarionHeader __fastcall GetDBHeader();
	TClarionField __fastcall GetFields(int Index);
	TClarionKeys* __fastcall GetKeys();
	System::Classes::TList* __fastcall GetArrayFields();
	TClarionFieldLinks* __fastcall GetFieldHiearachy();
	
protected:
	System::Classes::TStream* FCurrentStream;
	virtual void __fastcall ReadBLOBValue(unsigned BlockNo, unsigned ASize, System::UnicodeString &s);
	System::UnicodeString __fastcall GetSplittedFieldName(int ArrayIndex, int ArrayItemIndex, const System::UnicodeString strFieldName, TClarionArray* ca, TClarionArrayItem* cai);
	void __fastcall ParseFieldValue(const TClarionField &Field, const System::AnsiString strBuffer, System::Variant &Value, Smcells::TSMICellType &CellType, bool AnalyzeNull);
	System::UnicodeString __fastcall GetNamePrefix(char *prefix, const System::NativeInt prefix_High);
	System::UnicodeString __fastcall GetRecNamePrefix();
	System::UnicodeString __fastcall GetFileNamePrefix();
	
public:
	__fastcall virtual TClarion(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TClarion();
	virtual void __fastcall LoadFromStream(System::Classes::TStream* AStream);
	virtual void __fastcall LoadFromFile(const System::WideString FileName);
	virtual void __fastcall BeforeLoad();
	virtual void __fastcall AfterLoad();
	virtual bool __fastcall FindRecord(int RecNo);
	virtual bool __fastcall LoadRecord(int RecNo, int LogicalRecNo);
	virtual int __fastcall FindColumn(const System::UnicodeString AFieldName);
	virtual void __fastcall FillColumnList(System::Classes::TStrings* lst, const System::UnicodeString strFieldList);
	System::TDateTime __fastcall GetLastUpdate();
	bool __fastcall IsLocked();
	virtual bool __fastcall IsEncrypted();
	bool __fastcall IsOwned();
	bool __fastcall IsMemoExist();
	bool __fastcall FieldIsTime(const TClarionField &Field, unsigned Value, System::TDateTime &dt);
	bool __fastcall FieldIsDate(const TClarionField &Field, unsigned Value, System::TDateTime &dt);
	virtual System::UnicodeString __fastcall GetStrFieldType(System::Byte AType);
	__classmethod System::TDateTime __fastcall GetDate(int Value);
	__classmethod System::TDateTime __fastcall GetTime(int Value);
	virtual void __fastcall RenameFieldName(int FieldIndex, const System::UnicodeString FieldName);
	void __fastcall CreateDictionaryFile(const System::UnicodeString AFileName);
	__property TClarionHeader DBHeader = {read=GetDBHeader};
	__property TClarionField Fields[int Index] = {read=GetFields};
	__property TClarionKeys* Keys = {read=GetKeys};
	__property System::Classes::TList* ArrayFields = {read=GetArrayFields};
	__property TClarionFieldLinks* FieldHiearachy = {read=GetFieldHiearachy};
	__property System::UnicodeString RecNamePrefix = {read=GetRecNamePrefix};
	__property System::UnicodeString FileNamePrefix = {read=GetFileNamePrefix};
	
__published:
	__property bool DateAutodetect = {read=FDateAutodetect, write=FDateAutodetect, default=0};
	__property System::UnicodeString Password = {read=GetPassword, write=SetPassword};
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE Smclarion__1 arrClarionFieldTypeStr;
static _DELPHI_CONST System::Int8 CS_LOCKED = System::Int8(0x1);
static _DELPHI_CONST System::Int8 CS_OWNED = System::Int8(0x2);
static _DELPHI_CONST System::Int8 CS_ENCRYPTED = System::Int8(0x4);
static _DELPHI_CONST System::Int8 CS_MEMOEXIST = System::Int8(0x8);
static _DELPHI_CONST System::Int8 CS_COMPRESSED = System::Int8(0x10);
static _DELPHI_CONST System::Int8 CS_RECLAIM = System::Int8(0x20);
static _DELPHI_CONST System::Int8 CS_READONLY = System::Int8(0x40);
static _DELPHI_CONST System::Byte CS_CREATED = System::Byte(0x80);
}	/* namespace Smclarion */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMCLARION)
using namespace Smclarion;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMClarionHPP
