﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMXLS.pas' rev: 37.00 (Windows)

#ifndef SMXLSHPP
#define SMXLSHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <SMCells.hpp>
#include <Winapi.ActiveX.hpp>
#include <System.Win.ComObj.hpp>
#include <Vcl.Graphics.hpp>
#include <System.SysUtils.hpp>
#include <SMI_Sum.hpp>
#include <SMIUtils.hpp>
#include <SMIXML.hpp>
#include <System.Types.hpp>
#include <System.Variants.hpp>
#include <Winapi.Windows.hpp>
#include <SMIZipFile.hpp>
#include <System.UITypes.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smxls
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS ESMIExcelException;
class DELPHICLASS TXLSFormat;
class DELPHICLASS TXLSName;
class DELPHICLASS TXLSSharedFormula;
class DELPHICLASS TXLSSharedObject;
class DELPHICLASS TXLPictureSharedObject;
class DELPHICLASS TXLNoteSharedObject;
class DELPHICLASS TXLSSharedObjects;
class DELPHICLASS TXLSObjectInSheet;
class DELPHICLASS TXLSObjectsInSheet;
class DELPHICLASS TVBAProjectItem;
class DELPHICLASS TVBAProjectItems;
class DELPHICLASS TCustomMSExcel;
class DELPHICLASS TMSExcel;
class DELPHICLASS TMSExcelX;
//-- type declarations -------------------------------------------------------
class PASCALIMPLEMENTATION ESMIExcelException : public System::Sysutils::Exception
{
	typedef System::Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ inline __fastcall ESMIExcelException(const System::UnicodeString Msg) : System::Sysutils::Exception(Msg) { }
	/* Exception.CreateFmt */ inline __fastcall ESMIExcelException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High) : System::Sysutils::Exception(Msg, Args, Args_High) { }
	/* Exception.CreateRes */ inline __fastcall ESMIExcelException(System::NativeUInt Ident)/* overload */ : System::Sysutils::Exception(Ident) { }
	/* Exception.CreateRes */ inline __fastcall ESMIExcelException(System::PResStringRec ResStringRec)/* overload */ : System::Sysutils::Exception(ResStringRec) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMIExcelException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMIExcelException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High) { }
	/* Exception.CreateHelp */ inline __fastcall ESMIExcelException(const System::UnicodeString Msg, int AHelpContext) : System::Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ inline __fastcall ESMIExcelException(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext) : System::Sysutils::Exception(Msg, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMIExcelException(System::NativeUInt Ident, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMIExcelException(System::PResStringRec ResStringRec, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMIExcelException(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMIExcelException(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High, AHelpContext) { }
	/* Exception.Destroy */ inline __fastcall virtual ~ESMIExcelException() { }
	
};


enum DECLSPEC_DENUM TExcelVersion : unsigned char { evUnknown, evExcel2, evExcel3, evExcel4, evExcel5, evExcel7, evExcel8, evExcel9, evExcel12, evExcel12Bin };

enum DECLSPEC_DENUM TSMIVerAlignment : unsigned char { ivaTop, ivaCenter, ivaBottom, ivaJustify };

typedef System::StaticArray<int, 65536> TLongIntArray;

typedef TLongIntArray *PLongIntArray;

class PASCALIMPLEMENTATION TXLSFormat : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString Name;
	int NumberFormatIndex;
	int FontIndex;
	bool IsDateTime;
	System::Classes::TAlignment HorAlignment;
	TSMIVerAlignment VerAlignment;
	System::Uitypes::TColor Background;
public:
	/* TObject.Create */ inline __fastcall TXLSFormat() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TXLSFormat() { }
	
};


typedef System::StaticArray<System::Byte, 1025> TXLSFormulaData;

class PASCALIMPLEMENTATION TXLSName : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString Name;
	System::Word FormulaLen;
	TXLSFormulaData Formula;
	int Options;
	System::UnicodeString FormulaValue;
public:
	/* TObject.Create */ inline __fastcall TXLSName() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TXLSName() { }
	
};


enum DECLSPEC_DENUM TXLSFormulaKind : unsigned char { fkSharedFormula, fkCellFormula };

class PASCALIMPLEMENTATION TXLSSharedFormula : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	TXLSFormulaKind FormulaKind;
	int SheetIndex;
	System::Word Row1;
	System::Word Row2;
	System::Byte Col1;
	System::Byte Col2;
	System::Word FormulaLen;
	TXLSFormulaData Formula;
	System::UnicodeString Expression;
	System::UnicodeString __fastcall FormulaString();
public:
	/* TObject.Create */ inline __fastcall TXLSSharedFormula() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TXLSSharedFormula() { }
	
};


class PASCALIMPLEMENTATION TXLSSharedObject : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	int ID;
	System::Word ObjectType;
	System::UnicodeString Name;
	System::Classes::TStream* Data;
	__fastcall virtual TXLSSharedObject();
	__fastcall virtual ~TXLSSharedObject();
};


class PASCALIMPLEMENTATION TXLPictureSharedObject : public TXLSSharedObject
{
	typedef TXLSSharedObject inherited;
	
public:
	/* TXLSSharedObject.Create */ inline __fastcall virtual TXLPictureSharedObject() : TXLSSharedObject() { }
	/* TXLSSharedObject.Destroy */ inline __fastcall virtual ~TXLPictureSharedObject() { }
	
};


class PASCALIMPLEMENTATION TXLNoteSharedObject : public TXLSSharedObject
{
	typedef TXLSSharedObject inherited;
	
public:
	System::Word Options;
	System::Word Rotation;
	System::Word TextLen;
	System::Word FormattingLen;
	System::Classes::TStream* Formatting;
	__fastcall virtual TXLNoteSharedObject();
	__fastcall virtual ~TXLNoteSharedObject();
};


class PASCALIMPLEMENTATION TXLSSharedObjects : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	int __fastcall GetIndexByID(int AID);
public:
	/* TList.Destroy */ inline __fastcall virtual ~TXLSSharedObjects() { }
	
public:
	/* TObject.Create */ inline __fastcall TXLSSharedObjects() : System::Classes::TList() { }
	
};


class PASCALIMPLEMENTATION TXLSObjectInSheet : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString Author;
	System::Word ObjectType;
	Smcells::TSMRange* Range;
	Smcells::TSMRange* Offset;
	int SharedIndex;
	__fastcall virtual TXLSObjectInSheet();
	__fastcall virtual ~TXLSObjectInSheet();
	System::UnicodeString __fastcall Ref();
};


class PASCALIMPLEMENTATION TXLSObjectsInSheet : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	TXLSObjectInSheet* __fastcall FindForSharedObject(TXLSSharedObject* obj);
public:
	/* TList.Destroy */ inline __fastcall virtual ~TXLSObjectsInSheet() { }
	
public:
	/* TObject.Create */ inline __fastcall TXLSObjectsInSheet() : System::Classes::TList() { }
	
};


class PASCALIMPLEMENTATION TVBAProjectItem : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::WideString Entry;
	System::WideString ModuleName;
	System::WideString ModuleID;
	System::WideString ModuleStreamName;
	unsigned Offset;
	System::UnicodeString Body;
public:
	/* TObject.Create */ inline __fastcall TVBAProjectItem() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TVBAProjectItem() { }
	
};


class PASCALIMPLEMENTATION TVBAProjectItems : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	/* TList.Destroy */ inline __fastcall virtual ~TVBAProjectItems() { }
	
public:
	/* TObject.Create */ inline __fastcall TVBAProjectItems() : System::Classes::TList() { }
	
};


class PASCALIMPLEMENTATION TCustomMSExcel : public Smcells::TSpreadSheetFile
{
	typedef Smcells::TSpreadSheetFile inherited;
	
private:
	TExcelVersion FVersion;
	System::AnsiString FVBAProject;
	System::UnicodeString FVBAMacroSource;
	int FSheetIndex;
	Smi_sum::TSMISummaryInformation* FSummaryInformation;
	bool FIsEncrypted;
	System::UnicodeString FPassword;
	Smcells::TSMIOnPasswordEvent FOnPassword;
	void __fastcall SetSummaryInformation(Smi_sum::TSMISummaryInformation* Value);
	System::WideString __fastcall GetUnicodeString(const System::Sysutils::TByteArray &arr, int StartPos, System::Byte Options, int Len);
	
protected:
	System::TDateTime FBaseDate;
	System::Sysutils::TByteArray BufferRecord;
	unsigned __int64 intCurPos;
	int intRowCount;
	int intColCount;
	bool CountIsDefined;
	int intXLSRowCount;
	int intXLSColCount;
	TLongIntArray FColorPalette;
	System::Word FColorPaletteCount;
	bool __fastcall AskValidPassword();
	void __fastcall ProcessColors();
	System::UnicodeString __fastcall GetErrorText(int Code);
	virtual void __fastcall ApplyEvents();
	void __fastcall ClearFonts();
	void __fastcall ClearFormats();
	void __fastcall ClearVBAProjectItems();
	TXLSFormat* __fastcall GetXLSFormat(int Index);
	System::Uitypes::TColor __fastcall GetColorByXLSIndex(int AIndex);
	System::Uitypes::TColor __fastcall GetXLSColorByIndex(int index);
	void __fastcall AddFormat(bool IsNumericFormat, System::UnicodeString AName, int AIndex, int AFontIndex, int AHVAlignment, System::Uitypes::TColor ABackground);
	bool __fastcall ValueIsDateTime(int intFormat);
	bool __fastcall ValueIsPercent(int intFormat);
	void __fastcall DecompressMacrosStream(_di_IStream OStream, System::Classes::TStream* Destination, unsigned AOffset);
	void __fastcall DecompressMacrosStorage(_di_IStorage Storage);
	void __fastcall LoadVBProject(_di_IStorage Storage);
	void __fastcall LoadVBADirStream(System::Classes::TStream* AStream);
	void __fastcall LoadVBA(_di_IStorage Storage);
	void __fastcall ClearSharedFormulas();
	void __fastcall ClearNames();
	virtual int __fastcall GetMaxRowCount();
	virtual int __fastcall GetMaxColCount();
	
public:
	System::Classes::TList* Fonts;
	System::Classes::TList* Formats;
	System::Classes::TStrings* NumericFormats;
	System::Classes::TList* Names;
	Smiutils::TWideStrings* SheetNames;
	Smiutils::TWideStrings* SST;
	TVBAProjectItems* VBAProjectItems;
	System::Classes::TList* SharedFormulas;
	TXLSSharedObjects* SharedObjects;
	TXLSObjectsInSheet* ObjectsInSheet;
	__fastcall virtual TCustomMSExcel(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TCustomMSExcel();
	__classmethod void __fastcall ClearSharedObjects(System::Classes::TList* lstObjectsInSheet, System::Classes::TList* lstObjects);
	System::UnicodeString __fastcall GetFormatString(int AFormatIndex);
	void __fastcall FillFormatForCell(Smcells::TSMICell* cell, Vcl::Graphics::TFont* &fnt, System::UnicodeString &FormatMask);
	__property System::AnsiString VBAProject = {read=FVBAProject};
	__property System::UnicodeString VBAMacroSource = {read=FVBAMacroSource};
	
__published:
	__property Smi_sum::TSMISummaryInformation* SummaryInformation = {read=FSummaryInformation, write=SetSummaryInformation};
	__property TExcelVersion Version = {read=FVersion, write=FVersion, nodefault};
	__property int SheetIndex = {read=FSheetIndex, write=FSheetIndex, nodefault};
	__property System::UnicodeString Password = {read=FPassword, write=FPassword};
	__property Smcells::TSMIOnPasswordEvent OnPassword = {read=FOnPassword, write=FOnPassword};
};


class PASCALIMPLEMENTATION TMSExcel : public TCustomMSExcel
{
	typedef TCustomMSExcel inherited;
	
private:
	int FMaxBuffSize;
	int __fastcall GetMaxBuffSize();
	System::WideString __fastcall DecodeUnicodeString(const System::Sysutils::TByteArray &arr, int StartPos, int Len, bool PlainAnsi);
	System::Classes::TAlignment __fastcall GetXLSAlignment(System::Byte Value);
	void __fastcall ParseMSODrawing(_di_IStream OStream);
	bool __fastcall ProcessBIFFRecord(System::Classes::TStream* AStream, _di_IStream OStream);
	
protected:
	System::Word XLSBuildNo;
	System::Word XLSBuildYear;
	bool __fastcall IsBIFF5Build();
	virtual void __fastcall ApplyEvents();
	void __fastcall ImportFromStream(System::Classes::TStream* Stream);
	void __fastcall ImportFromOLEStream(_di_IStorage Storage);
	
public:
	__fastcall virtual TMSExcel(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TMSExcel();
	virtual void __fastcall LoadFromFile(const System::WideString FileName);
	virtual void __fastcall LoadFromStream(System::Classes::TStream* AStream);
	virtual bool __fastcall IsEncrypted();
	__property unsigned __int64 CurrentPosition = {read=intCurPos};
};


class PASCALIMPLEMENTATION TMSExcelX : public TCustomMSExcel
{
	typedef TCustomMSExcel inherited;
	
private:
	int FcurSheetIndex;
	int CurrentRow;
	int CurrentCol;
	bool ToSkipLoadSheet;
	bool ToAddSST;
	bool XFInCellXFs;
	void __fastcall ReadRecordHeader(System::Classes::TStream* AStream);
	
protected:
	Smcells::TBIFF12RecordHeader BufferHeader12;
	void __fastcall NewSSTAdd(System::TObject* Sender, Smixml::TSMXMLItem* ParentNode, System::UnicodeString ATagName, System::UnicodeString ATagValue, System::UnicodeString ATagAttributes, bool &Accept);
	void __fastcall DeleteSSTTag(System::TObject* Sender, Smixml::TSMXMLItem* &Node, bool &Cancel);
	void __fastcall NewSheetNameAdd(System::TObject* Sender, Smixml::TSMXMLItem* ParentNode, System::UnicodeString ATagName, System::UnicodeString ATagValue, System::UnicodeString ATagAttributes, bool &Accept);
	void __fastcall NewRowTag(System::TObject* Sender, Smixml::TSMXMLItem* ParentNode, System::UnicodeString ATagName, System::UnicodeString ATagValue, System::UnicodeString ATagAttributes, bool &Accept);
	void __fastcall DeleteRowTag(System::TObject* Sender, Smixml::TSMXMLItem* &Node, bool &Cancel);
	void __fastcall NewNamedRangeAdd(System::TObject* Sender, Smixml::TSMXMLItem* ParentNode, System::UnicodeString ATagName, System::UnicodeString ATagValue, System::UnicodeString ATagAttributes, bool &Accept);
	bool __fastcall ProcessBIFF12Record(System::Classes::TStream* AStream);
	void __fastcall UnZipAndLoadBinaryXML(Smizipfile::TZipArchive* ZipFileMem, const System::UnicodeString AFileName);
	void __fastcall UnZipVBProjectAndLoad(Smizipfile::TZipArchive* ZipFileMem, const System::UnicodeString AFileName);
	void __fastcall UnZipDocProp(Smizipfile::TZipArchive* ZipFileMem, const System::UnicodeString AFileName);
	void __fastcall UnZipPath(Smizipfile::TZipArchive* ZipFileMem, const System::UnicodeString AFileName, const System::UnicodeString XMLPath, const System::UnicodeString XMLNode, Smixml::TSMIXMLOnTagEvent OnNewTag, Smixml::TSMIXMLOnAfterTagEvent OnAfterTag);
	void __fastcall UnZipStyles(Smizipfile::TZipArchive* ZipFileMem, const System::UnicodeString AFileName);
	void __fastcall UnZipComments(Smizipfile::TZipArchive* ZipFileMem, const System::UnicodeString AFileName);
	virtual void __fastcall InternalLoadFromOLEStream(System::Classes::TStream* AStream);
	void __fastcall ImportFromOLEStream(_di_IStorage Storage);
	virtual int __fastcall GetMaxRowCount();
	virtual int __fastcall GetMaxColCount();
	
public:
	__fastcall virtual TMSExcelX(System::Classes::TComponent* AOwner);
	virtual void __fastcall LoadFromStream(System::Classes::TStream* Stream);
	virtual void __fastcall LoadFromFile(const System::WideString AFileName);
public:
	/* TCustomMSExcel.Destroy */ inline __fastcall virtual ~TMSExcelX() { }
	
};


//-- var, const, procedure ---------------------------------------------------
static _DELPHI_CONST System::Word XLSR_BLIP_WMF = System::Word(0x216);
static _DELPHI_CONST System::Word XLSR_BLIP_EMF = System::Word(0x3d4);
static _DELPHI_CONST System::Word XLSR_BLIP_JPEG = System::Word(0x46a);
static _DELPHI_CONST System::Word XLSR_BLIP_PNG = System::Word(0x6e0);
static _DELPHI_CONST System::Word XLSR_BLIP_DIB = System::Word(0x7a8);
extern DELPHI_PACKAGE System::UnicodeString __fastcall SMIApplyFormatByExcelMask(const System::UnicodeString XLSFormat, const System::Variant &Value);
extern DELPHI_PACKAGE bool __fastcall SMIGetSheetList(const System::UnicodeString AFileName, System::Classes::TStrings* lst);
extern DELPHI_PACKAGE bool __fastcall SMIGetSheetInfo(const System::UnicodeString AFileName, int SheetIndex, System::UnicodeString &SheetCaption, int &ARowCount, int &AColCount);
}	/* namespace Smxls */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMXLS)
using namespace Smxls;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMXLSHPP
