﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMParadox.pas' rev: 37.00 (Windows)

#ifndef SMParadoxHPP
#define SMParadoxHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <SMCells.hpp>
#include <System.SysUtils.hpp>
#include <Winapi.Windows.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smparadox
{
//-- forward type declarations -----------------------------------------------
struct TFldInfoRec;
struct TPxHeader;
struct TPxHeader4;
struct TParadoxField;
struct TDataBlockHeader;
struct PtrRec;
struct TPdoxBlob;
struct TBlobIndex;
class DELPHICLASS TSMParadoxTable;
class DELPHICLASS TDBParadox;
//-- type declarations -------------------------------------------------------
typedef TFldInfoRec *PFldInfoRec;

#pragma pack(push,1)
struct DECLSPEC_DRECORD TFldInfoRec
{
public:
	System::Byte fType;
	System::Byte fSize;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TPxHeader
{
public:
	System::Word RecordSize;
	System::Word HeaderSize;
	System::Byte FileType;
	System::Byte MaxTableSize;
	unsigned NumberOfRecords;
	System::Word NextBlock;
	System::Word FileBlocks;
	System::Word FirstBlock;
	System::Word LastBlock;
	System::Word Unknown12x13;
	System::Byte ModifiedFlags1;
	System::Byte IndexFieldNumber;
	int PrimaryIndexWorkspace;
	int UnknownPtr1A;
	System::StaticArray<System::Byte, 3> Unknown1Ex20;
	System::Word NumberOfFields;
	System::Word PrimaryKeyFields;
	System::LongInt Encryption1;
	System::Byte SortOrder;
	System::Byte ModifiedFlags2;
	System::StaticArray<System::Byte, 2> unknown2Bx2C;
	System::Byte ChangeCount1;
	System::Byte ChangeCount2;
	System::Byte Unknown2F;
	int TableNamePtrPtr;
	int FldInfoPtr;
	System::Byte writeProtected;
	System::Byte fileVersionID;
	System::Word maxBlocks;
	System::Byte unknown3C;
	System::Byte auxPasswords;
	System::StaticArray<System::Byte, 2> unknown3Ex3F;
	int cryptInfoStartPtr;
	int cryptInfoEndPtr;
	System::Byte unknown48;
	System::LongInt autoIncVal;
	System::StaticArray<System::Byte, 2> unknown4Dx4E;
	System::Byte indexUpdateRequired;
	System::StaticArray<System::Byte, 5> unknown50x54;
	System::Byte refIntegrity;
	System::StaticArray<System::Byte, 2> unknown56x57;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TPxHeader4
{
public:
	System::Word fileVerID2;
	System::Word fileVerID3;
	System::LongInt encryption2;
	System::LongInt fileUpdateTime;
	System::Word hiFieldID;
	System::Word hiFieldIDinfo;
	System::Word sometimesNumFields;
	System::Word dosCodePage;
	System::StaticArray<System::Byte, 4> unknown6Cx6F;
	System::Word changeCount4;
	System::StaticArray<System::Byte, 6> unknown72x77;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TParadoxField
{
public:
	System::SmallString<25> FieldName;
	int FieldType;
	int Start;
	int Length;
};
#pragma pack(pop)


typedef TDataBlockHeader *PDataBlockHeader;

#pragma pack(push,1)
struct DECLSPEC_DRECORD TDataBlockHeader
{
public:
	System::Word NextBlock;
	System::Word BlockNumber;
	System::Word AddDataSize;
	void *FileData;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD PtrRec
{
public:
	System::Word Lo;
	System::Word Hi;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TPdoxBlob
{
public:
	int FileLoc;
	int Length;
	System::Word ModCnt;
	System::Byte Index;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TBlobIndex
{
public:
	System::Byte Offset;
	System::Byte Len16;
	System::Word ModCnt;
	System::Byte Len;
};
#pragma pack(pop)


typedef void __fastcall (*TPDXDecryptDBBlockEvent)(System::TObject* Sender, System::Sysutils::TByteArray &tba, int BlockIndex, System::LongInt BlockSize, System::LongInt CheckSum, bool IsBLOBBlock);

typedef void __fastcall (*TPDXGetPasswordChecksumEvent)(System::TObject* Sender, const System::UnicodeString APassword, int &AResult);

class PASCALIMPLEMENTATION TSMParadoxTable : public Smcells::TSpreadSheet
{
	typedef Smcells::TSpreadSheet inherited;
	
public:
	TPxHeader DBHeader;
	TPxHeader4 DBHeader4;
	System::AnsiString OriginalTableName;
	System::AnsiString SortingName;
	System::StaticArray<TParadoxField, 256> Fields;
public:
	/* TSpreadSheet.Create */ inline __fastcall virtual TSMParadoxTable(System::Classes::TComponent* AOwner) : Smcells::TSpreadSheet(AOwner) { }
	/* TSpreadSheet.Destroy */ inline __fastcall virtual ~TSMParadoxTable() { }
	
};


class PASCALIMPLEMENTATION TDBParadox : public Smcells::TSpreadSheetFile
{
	typedef Smcells::TSpreadSheetFile inherited;
	
private:
	System::Classes::TStream* BLOBStream;
	TDataBlockHeader Block;
	System::UnicodeString FPassword;
	Smcells::TSMIOnPasswordEvent FOnPassword;
	int __fastcall GetBlockSize();
	TPxHeader __fastcall GetDBHeader();
	TPxHeader4 __fastcall GetDBHeader4();
	System::AnsiString __fastcall GetOriginalTableName();
	System::AnsiString __fastcall GetSortingName();
	TParadoxField __fastcall GetFields(int Index);
	
protected:
	int BlockIndex;
	int RecIndexInBlock;
	System::Classes::TStream* FCurrentStream;
	void __fastcall LoadNextBlock();
	void __fastcall WriteNextBlock();
	System::UnicodeString __fastcall TranslateString(const System::AnsiString s);
	void __fastcall SetFieldValue(const TParadoxField &fld, int ShiftPos, int RecNo, int FieldNumber);
	void __fastcall WriteFieldValue(const TParadoxField &fld, int ShiftPos, int RecNo, int FieldNumber);
	void __fastcall ReadBLOBValue1(const TPdoxBlob &BI, System::AnsiString &s);
	System::LongInt __fastcall GetEncryptionCheckSum();
	int __fastcall GetPasswordChecksum(const System::UnicodeString APassword);
	bool __fastcall FileIsEncrypted();
	System::Word __fastcall GetCreatedTableNameSpace();
	
public:
	__fastcall virtual TDBParadox(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TDBParadox();
	virtual void __fastcall LoadFromStream(System::Classes::TStream* AStream);
	virtual void __fastcall LoadFromFile(const System::WideString FileName);
	void __fastcall WriteToStream(System::Classes::TStream* AStream);
	void __fastcall WriteToFile(const System::WideString FileName);
	virtual void __fastcall BeforeLoad();
	virtual void __fastcall AfterLoad();
	virtual bool __fastcall LoadRecord(int RecNo, int LogicalRecNo);
	bool __fastcall WriteRecord(int RecNo);
	virtual int __fastcall FindColumn(const System::UnicodeString AFieldName);
	virtual void __fastcall FillColumnList(System::Classes::TStrings* lst, const System::UnicodeString strFieldList);
	System::UnicodeString __fastcall VersionNumToStr();
	System::Word __fastcall GetTableLevel();
	void __fastcall FmtMemo2PlainText(System::UnicodeString &s);
	System::UnicodeString __fastcall GetStrFieldType(int i);
	System::UnicodeString __fastcall GetStrFileType(System::Byte FileType);
	virtual bool __fastcall IsEncrypted();
	bool __fastcall IsPasswordValid();
	void __fastcall RenameFieldName(int FieldIndex, const System::UnicodeString FieldName);
	__property TPxHeader DBHeader = {read=GetDBHeader};
	__property TPxHeader4 DBHeader4 = {read=GetDBHeader4};
	__property System::AnsiString OriginalTableName = {read=GetOriginalTableName};
	__property System::AnsiString SortingName = {read=GetSortingName};
	__property TParadoxField Fields[int Index] = {read=GetFields};
	
__published:
	__property System::Word TableLevel = {read=GetTableLevel, nodefault};
	__property System::UnicodeString Password = {read=FPassword, write=FPassword};
	__property Smcells::TSMIOnPasswordEvent OnPassword = {read=FOnPassword, write=FOnPassword};
};


//-- var, const, procedure ---------------------------------------------------
static _DELPHI_CONST System::Int8 pxfAlpha = System::Int8(0x1);
static _DELPHI_CONST System::Int8 pxfDate = System::Int8(0x2);
static _DELPHI_CONST System::Int8 pxfShort = System::Int8(0x3);
static _DELPHI_CONST System::Int8 pxfLong = System::Int8(0x4);
static _DELPHI_CONST System::Int8 pxfCurrency = System::Int8(0x5);
static _DELPHI_CONST System::Int8 pxfNumber = System::Int8(0x6);
static _DELPHI_CONST System::Int8 pxfLogical = System::Int8(0x9);
static _DELPHI_CONST System::Int8 pxfMemoBLOB = System::Int8(0xc);
static _DELPHI_CONST System::Int8 pxfBLOB = System::Int8(0xd);
static _DELPHI_CONST System::Int8 pxfFmtMemoBLOB = System::Int8(0xe);
static _DELPHI_CONST System::Int8 pxfOLE = System::Int8(0xf);
static _DELPHI_CONST System::Int8 pxfGraphic = System::Int8(0x10);
static _DELPHI_CONST System::Int8 pxfTime = System::Int8(0x14);
static _DELPHI_CONST System::Int8 pxfTimestamp = System::Int8(0x15);
static _DELPHI_CONST System::Int8 pxfAutoInc = System::Int8(0x16);
static _DELPHI_CONST System::Int8 pxfBCD = System::Int8(0x17);
static _DELPHI_CONST System::Int8 pxfBytes = System::Int8(0x18);
extern DELPHI_PACKAGE TPDXDecryptDBBlockEvent RegisteredParadoxDecryptDBBlock;
extern DELPHI_PACKAGE TPDXGetPasswordChecksumEvent RegisteredParadoxGetPasswordChecksum;
extern DELPHI_PACKAGE Smcells::TSMIOnPasswordEvent RegisteredParadoxPassword;
}	/* namespace Smparadox */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMPARADOX)
using namespace Smparadox;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMParadoxHPP
