﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMDBF.pas' rev: 37.00 (Windows)

#ifndef SMDBFHPP
#define SMDBFHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <SMCells.hpp>
#include <Winapi.Windows.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smdbf
{
//-- forward type declarations -----------------------------------------------
struct TDBFField;
struct TDBFField3;
struct TDBFField7;
struct TDBFHeader;
struct TSMIDBTHeader;
struct TSMIFPTHeader;
struct TSMIBlockHeader;
class DELPHICLASS TSMDBFTable;
class DELPHICLASS TDBF;
//-- type declarations -------------------------------------------------------
#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBFField
{
public:
	System::AnsiString FieldName;
	char FieldType;
	System::LongInt Address;
	System::Byte Length;
	System::Byte Decimals;
	System::StaticArray<System::Byte, 2> Reserved1;
	System::Byte WordAreaID;
	System::Word MultiUserDBase;
	System::Byte SetFields;
	System::StaticArray<System::Byte, 8> Reserved2;
	System::Byte MDXFlag;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBFField3
{
public:
	System::StaticArray<char, 11> FieldName;
	char FieldType;
	System::LongInt Address;
	System::Byte Length;
	System::Byte Decimals;
	System::StaticArray<System::Byte, 2> Reserved1;
	System::Byte WordAreaID;
	System::Word MultiUserDBase;
	System::Byte SetFields;
	System::StaticArray<System::Byte, 8> Reserved2;
	System::Byte MDXFlag;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBFField7
{
public:
	System::StaticArray<char, 32> FieldName;
	char FieldType;
	System::Byte Length;
	System::Byte Decimals;
	System::StaticArray<System::Byte, 2> Reserved1;
	System::Byte MDXFlag;
	unsigned Reserved2;
	unsigned NextAutoInc;
	System::Word Reserved3;
};
#pragma pack(pop)


typedef System::StaticArray<TDBFField, 4096> TDBFFields;

enum DECLSPEC_DENUM TDBFVersion : unsigned char { dBase3, dBase3Memo, dBase3Plus, dBase3PlusMemo, FoxPro, FoxProMemo, dBase4, dBase4Memo, VFP3, dBase5, dBase7, dBase7Memo, FoxBASE1, FoxBASE2, VFP3AutoIncrement, HyperSix, VFP3Binary, dBase4SQL, dBase4SQLSys, FoxPro2 };

enum DECLSPEC_DENUM TDBFMemoType : unsigned char { dmDBT, dmFPT, dmSMT };

#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBFHeader
{
public:
	System::Byte VersionNumber;
	System::Byte LastUpdateYear;
	System::Byte LastUpdateMonth;
	System::Byte LastUpdateDay;
	System::LongInt NumberOfRecords;
	System::Word HeaderSize;
	System::Word RecordSize;
	System::StaticArray<char, 2> Reserve1;
	System::Byte IncompleteTransaction;
	System::Byte Encrypted;
	System::StaticArray<char, 12> Reserved;
	System::Byte MDXIsExist;
	System::Byte LanguageID;
	System::StaticArray<char, 2> Reserved2;
	System::LongInt NumberOfFields;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TSMIDBTHeader
{
public:
	System::LongInt NextBlock;
	System::StaticArray<System::Byte, 4> Dummy;
	System::StaticArray<System::Byte, 8> DbfFile;
	System::Byte Version;
	System::StaticArray<System::Byte, 3> Dummy2;
	System::Word BlockLen;
	System::StaticArray<System::Byte, 490> Dummy3;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TSMIFPTHeader
{
public:
	System::LongInt NextBlock;
	System::StaticArray<System::Byte, 2> Dummy;
	System::Word BlockLen;
	System::StaticArray<System::Byte, 504> Dummy3;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TSMIBlockHeader
{
public:
	System::LongInt MemoType;
	System::LongInt MemoSize;
};
#pragma pack(pop)


class PASCALIMPLEMENTATION TSMDBFTable : public Smcells::TSpreadSheet
{
	typedef Smcells::TSpreadSheet inherited;
	
public:
	TDBFHeader DBHeader;
	TSMIDBTHeader DBTHeader;
	TSMIFPTHeader FPTHeader;
	TDBFFields Fields;
public:
	/* TSpreadSheet.Create */ inline __fastcall virtual TSMDBFTable(System::Classes::TComponent* AOwner) : Smcells::TSpreadSheet(AOwner) { }
	/* TSpreadSheet.Destroy */ inline __fastcall virtual ~TSMDBFTable() { }
	
};


class PASCALIMPLEMENTATION TDBF : public Smcells::TSpreadSheetFile
{
	typedef Smcells::TSpreadSheetFile inherited;
	
private:
	TDBFVersion FDBFVersion;
	TDBFMemoType FDBFMemoType;
	System::Classes::TStream* BLOBStream;
	TDBFHeader __fastcall GetDBHeader();
	TSMIDBTHeader __fastcall GetDBTHeader();
	TSMIFPTHeader __fastcall GetFPTHeader();
	TDBFField __fastcall GetFields(int Index);
	
protected:
	System::Classes::TStream* FCurrentStream;
	virtual void __fastcall ReadBLOBValue(unsigned BlockNo, unsigned ASize, System::UnicodeString &s);
	System::UnicodeString __fastcall TranslateString(const System::AnsiString s);
	
public:
	__fastcall virtual TDBF(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TDBF();
	virtual void __fastcall LoadFromStream(System::Classes::TStream* AStream);
	virtual void __fastcall LoadFromFile(const System::WideString FileName);
	virtual void __fastcall BeforeLoad();
	virtual void __fastcall AfterLoad();
	virtual bool __fastcall FindRecord(int RecNo);
	virtual bool __fastcall LoadRecord(int RecNo, int LogicalRecNo);
	virtual int __fastcall FindColumn(const System::UnicodeString AFieldName);
	virtual void __fastcall FillColumnList(System::Classes::TStrings* lst, const System::UnicodeString strFieldList);
	System::UnicodeString __fastcall GetStrFieldType(char AType);
	System::UnicodeString __fastcall GetStrFileType(System::Byte FileType);
	virtual bool __fastcall IsEncrypted();
	void __fastcall RenameFieldName(int FieldIndex, const System::UnicodeString FieldName);
	__property TDBFHeader DBHeader = {read=GetDBHeader};
	__property TSMIDBTHeader DBTHeader = {read=GetDBTHeader};
	__property TSMIFPTHeader FPTHeader = {read=GetFPTHeader};
	__property TDBFField Fields[int Index] = {read=GetFields};
	
__published:
	__property TDBFVersion DBFVersion = {read=FDBFVersion, write=FDBFVersion, default=0};
	__property TDBFMemoType DBFMemoType = {read=FDBFMemoType, write=FDBFMemoType, default=0};
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE System::StaticArray<System::Byte, 20> arrDBFVersion;
}	/* namespace Smdbf */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMDBF)
using namespace Smdbf;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMDBFHPP
