﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMIWiz.pas' rev: 37.00 (Windows)

#ifndef SMIWizHPP
#define SMIWizHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.Messages.hpp>
#include <System.SysUtils.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.Controls.hpp>
#include <Vcl.Forms.hpp>
#include <Vcl.Dialogs.hpp>
#include <Vcl.StdCtrls.hpp>
#include <Vcl.ExtCtrls.hpp>
#include <Data.DB.hpp>
#include <SMIBase.hpp>
#include <Vcl.Grids.hpp>
#include <Vcl.Tabs.hpp>
#include <Vcl.Menus.hpp>
#include <SMI2XML.hpp>
#include <SMIPST.hpp>
#include <Vcl.ComCtrls.hpp>
#include <System.Variants.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smiwiz
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMICategories;
class DELPHICLASS TfrmSMIWizard;
class DELPHICLASS TSMIUserAccess;
class DELPHICLASS TSMIWizardDlg;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TSMIFileCategory : unsigned char { fciDocument, fciDatabase, fciSpreadsheet, fciWEB, fciEmail, fciOther };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMICategories : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	bool FShowCategories;
	System::Uitypes::TColor FBackColor;
	Vcl::Graphics::TFont* FTextFont;
	Smibase::TImportFormatTypes FDocumentFormats;
	Smibase::TImportFormatTypes FDatabaseFormats;
	Smibase::TImportFormatTypes FSpreadsheetFormats;
	Smibase::TImportFormatTypes FWEBFormats;
	Smibase::TImportFormatTypes FEMailFormats;
	Smibase::TImportFormatTypes FOtherFormats;
	
protected:
	Vcl::Graphics::TFont* __fastcall GetTextFont();
	void __fastcall SetTextFont(Vcl::Graphics::TFont* Value);
	
public:
	__fastcall virtual TSMICategories();
	__fastcall virtual ~TSMICategories();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property bool ShowCategories = {read=FShowCategories, write=FShowCategories, default=1};
	__property System::Uitypes::TColor BackColor = {read=FBackColor, write=FBackColor, default=-16777203};
	__property Vcl::Graphics::TFont* TextFont = {read=GetTextFont, write=SetTextFont};
	__property Smibase::TImportFormatTypes DocumentFormats = {read=FDocumentFormats, write=FDocumentFormats, default=33284};
	__property Smibase::TImportFormatTypes DatabaseFormats = {read=FDatabaseFormats, write=FDatabaseFormats, default=2127107};
	__property Smibase::TImportFormatTypes SpreadsheetFormats = {read=FSpreadsheetFormats, write=FSpreadsheetFormats, default=264304};
	__property Smibase::TImportFormatTypes WEBFormats = {read=FWEBFormats, write=FWEBFormats, default=1245320};
	__property Smibase::TImportFormatTypes EMailFormats = {read=FEMailFormats, write=FEMailFormats, default=524288};
	__property Smibase::TImportFormatTypes OtherFormats = {read=FOtherFormats, write=FOtherFormats, default=0};
};

#pragma pack(pop)

typedef void __fastcall (__closure *TSMIGetSpecificationsEvent)(System::TObject* Sender, System::Classes::TStrings* List);

typedef void __fastcall (__closure *TSMISaveSpecNotifyEvent)(System::TObject* Sender, const System::UnicodeString Caption, const System::UnicodeString FileName);

typedef void __fastcall (__closure *TSMICloseEvent)(System::TObject* Sender, System::Uitypes::TModalResult &Action);

typedef void __fastcall (__closure *TSMIStepChangeEvent)(System::TObject* Sender, bool &Allow);

enum DECLSPEC_DENUM TSMIDirection : unsigned char { idForward, idBackward };

class PASCALIMPLEMENTATION TfrmSMIWizard : public Vcl::Forms::TForm
{
	typedef Vcl::Forms::TForm inherited;
	
	
private:
	typedef System::StaticArray<System::UnicodeString, 8> _TfrmSMIWizard__1;
	
	typedef System::StaticArray<System::UnicodeString, 8> _TfrmSMIWizard__2;
	
	
__published:
	Vcl::Stdctrls::TButton* btnPrev;
	Vcl::Stdctrls::TButton* btnNext;
	Vcl::Stdctrls::TButton* btnCancel;
	Vcl::Stdctrls::TLabel* lblStep;
	Vcl::Extctrls::TImage* imgLogo;
	Vcl::Stdctrls::TButton* btnSpecs;
	Vcl::Extctrls::TImage* imgKey;
	Vcl::Extctrls::TPanel* pnlStep1;
	Vcl::Extctrls::TRadioGroup* rgTableType;
	Vcl::Extctrls::TPanel* pnlStep2;
	Vcl::Stdctrls::TLabel* lblFileName;
	Vcl::Stdctrls::TEdit* edFileName;
	Vcl::Stdctrls::TButton* btnFileName;
	Vcl::Stdctrls::TLabel* lblTableName;
	Vcl::Stdctrls::TComboBox* cbTableNames;
	Vcl::Stdctrls::TLabel* lblFileOrigin;
	Vcl::Stdctrls::TComboBox* cbCharacterSet;
	Vcl::Extctrls::TPanel* pnlStep3;
	Vcl::Stdctrls::TRadioButton* rbText1;
	Vcl::Stdctrls::TRadioButton* rbText2;
	Vcl::Extctrls::TRadioGroup* rgSeparator;
	Vcl::Stdctrls::TEdit* edSymbol;
	Vcl::Stdctrls::TLabel* lblQualifier;
	Vcl::Stdctrls::TLabel* lblRecSeparator;
	Vcl::Stdctrls::TComboBox* cbRecSeparator;
	Vcl::Stdctrls::TComboBox* cbQualifier;
	Vcl::Extctrls::TPanel* pnlStep4;
	Vcl::Stdctrls::TLabel* lblFirstRow;
	Vcl::Stdctrls::TEdit* edFirstRow;
	Vcl::Stdctrls::TLabel* lblLastRow;
	Vcl::Stdctrls::TEdit* edLastRow;
	Vcl::Stdctrls::TGroupBox* gbFormat;
	Vcl::Stdctrls::TLabel* lblDateOrder;
	Vcl::Stdctrls::TLabel* lblDecimalSymbol;
	Vcl::Stdctrls::TComboBox* cbDateOrder;
	Vcl::Stdctrls::TEdit* edDecimalSymbol;
	Vcl::Extctrls::TPanel* pnlStep5Fixed;
	Vcl::Stdctrls::TLabel* lblStep5FixedB;
	Vcl::Extctrls::TPaintBox* pbBreaks;
	Vcl::Stdctrls::TScrollBar* sbBreakHorz;
	Vcl::Stdctrls::TScrollBar* sbBreakVert;
	Vcl::Extctrls::TPanel* pnlStep6CSV;
	Vcl::Grids::TStringGrid* sgPreviewFile;
	Vcl::Extctrls::TPanel* pnlStep7;
	Vcl::Grids::TStringGrid* sgMappings;
	Vcl::Stdctrls::TComboBox* cbFields;
	Vcl::Stdctrls::TCheckBox* cbKey;
	Vcl::Extctrls::TPanel* pnlStep8;
	Vcl::Grids::TStringGrid* sgPreview;
	Vcl::Extctrls::TPanel* pnlStep9;
	Vcl::Extctrls::TRadioGroup* rgModeType;
	Vcl::Tabs::TTabSet* tsSheets;
	Vcl::Stdctrls::TButton* btnFirst;
	Vcl::Stdctrls::TButton* btnLast;
	Vcl::Menus::TPopupMenu* pmFieldList;
	Vcl::Stdctrls::TLabel* lblThousandSymbol;
	Vcl::Stdctrls::TEdit* edThousandSymbol;
	Vcl::Stdctrls::TLabel* lblCurrencyString;
	Vcl::Stdctrls::TEdit* edCurrencyString;
	Vcl::Stdctrls::TLabel* lblLogical;
	Vcl::Stdctrls::TEdit* edTrue;
	Vcl::Stdctrls::TEdit* edFalse;
	Vcl::Extctrls::TPanel* pnlFields;
	Vcl::Stdctrls::TButton* btnExpBuilder;
	Vcl::Extctrls::TPanel* pnlDescription;
	Vcl::Stdctrls::TLabel* lblCaption;
	Vcl::Extctrls::TImage* imgBackground;
	Vcl::Extctrls::TImage* imgDescription;
	Vcl::Stdctrls::TLabel* lblDescription;
	Vcl::Stdctrls::TLabel* lblStepInfo;
	Vcl::Stdctrls::TLabel* lblFieldNameRow;
	Vcl::Stdctrls::TEdit* edFieldNameRow;
	Vcl::Extctrls::TPanel* pnlStandardDate;
	Vcl::Stdctrls::TCheckBox* cbFourDigitYear;
	Vcl::Stdctrls::TCheckBox* cbLeadingZerosInDate;
	Vcl::Extctrls::TPanel* pnlCustomDate;
	Vcl::Stdctrls::TComboBox* cbCustomDateFormat;
	Vcl::Stdctrls::TLabel* lblDateDelimiter;
	Vcl::Stdctrls::TEdit* edDateDelimiter;
	Vcl::Stdctrls::TLabel* lblTimeDelimiter;
	Vcl::Stdctrls::TEdit* edTimeDelimiter;
	Vcl::Stdctrls::TCheckBox* cbLoadWhen;
	Vcl::Stdctrls::TCheckBox* cbSkipIf;
	Vcl::Stdctrls::TEdit* edLoadWhen;
	Vcl::Stdctrls::TButton* btnLoadWhen;
	Vcl::Stdctrls::TEdit* edSkipIf;
	Vcl::Stdctrls::TButton* btnSkipIf;
	Vcl::Extctrls::TImage* imgAutoArrange;
	Vcl::Stdctrls::TCheckBox* chkShowFileHeader;
	Vcl::Extctrls::TPanel* pnlCategory;
	Vcl::Forms::TScrollBox* sbCategory;
	Vcl::Extctrls::TPanel* pnlStep3XML;
	Vcl::Stdctrls::TGroupBox* gbXMLTags;
	Vcl::Stdctrls::TCheckBox* chkXMLCaseSensitive;
	Vcl::Stdctrls::TLabel* lblXMLRecordsTag;
	Vcl::Stdctrls::TEdit* edXMLRecordsTag;
	Vcl::Stdctrls::TLabel* lblXMLRecordTag;
	Vcl::Stdctrls::TEdit* edXMLRecordTag;
	Vcl::Stdctrls::TLabel* lblXMLRowTag;
	Vcl::Stdctrls::TEdit* edXMLRowTag;
	Vcl::Extctrls::TPanel* pnlStep3Outlook;
	Vcl::Stdctrls::TCheckBox* chkOutlookLoadSubFolders;
	Vcl::Comctrls::TTreeView* tvOutlookFolders;
	Vcl::Stdctrls::TLabel* lblOutlookItemType;
	Vcl::Stdctrls::TComboBox* cbOutlookItemType;
	Vcl::Controls::TImageList* imgOutlook;
	Vcl::Stdctrls::TRadioButton* rbOutlookDefFolder;
	Vcl::Stdctrls::TRadioButton* rbOutlookCustomFolder;
	Vcl::Stdctrls::TComboBox* cboTrim;
	Vcl::Stdctrls::TLabel* lblTrim;
	Vcl::Extctrls::TPaintBox* pbLogo;
	void __fastcall btnNextClick(System::TObject* Sender);
	void __fastcall btnPrevClick(System::TObject* Sender);
	void __fastcall FormCreate(System::TObject* Sender);
	void __fastcall FormActivate(System::TObject* Sender);
	void __fastcall FormCloseQuery(System::TObject* Sender, bool &CanClose);
	void __fastcall btnFileNameClick(System::TObject* Sender);
	void __fastcall rgSeparatorClick(System::TObject* Sender);
	void __fastcall edSymbolChange(System::TObject* Sender);
	void __fastcall rgTableTypeClick(System::TObject* Sender);
	void __fastcall btnCancelClick(System::TObject* Sender);
	void __fastcall cbFieldsChange(System::TObject* Sender);
	void __fastcall sgMappingsSelectCell(System::TObject* Sender, int Col, int Row, bool &CanSelect);
	void __fastcall pbBreaksPaint(System::TObject* Sender);
	void __fastcall sgMappingsDrawCell(System::TObject* Sender, int Col, int Row, const System::Types::TRect &Rect, Vcl::Grids::TGridDrawState State);
	void __fastcall sbBreakHorzScroll(System::TObject* Sender, System::Uitypes::TScrollCode ScrollCode, int &ScrollPos);
	void __fastcall sbBreakVertScroll(System::TObject* Sender, System::Uitypes::TScrollCode ScrollCode, int &ScrollPos);
	void __fastcall FormDestroy(System::TObject* Sender);
	void __fastcall pbBreaksMouseUp(System::TObject* Sender, System::Uitypes::TMouseButton Button, System::Classes::TShiftState Shift, int X, int Y);
	void __fastcall pbBreaksMouseMove(System::TObject* Sender, System::Classes::TShiftState Shift, int X, int Y);
	void __fastcall pbBreaksMouseDown(System::TObject* Sender, System::Uitypes::TMouseButton Button, System::Classes::TShiftState Shift, int X, int Y);
	void __fastcall edFileNameChange(System::TObject* Sender);
	void __fastcall rbText1Click(System::TObject* Sender);
	void __fastcall btnSpecsClick(System::TObject* Sender);
	void __fastcall cbKeyExit(System::TObject* Sender);
	void __fastcall cbTableNamesDropDown(System::TObject* Sender);
	void __fastcall tsSheetsChange(System::TObject* Sender, int NewTab, bool &AllowChange);
	void __fastcall btnFirstClick(System::TObject* Sender);
	void __fastcall btnLastClick(System::TObject* Sender);
	void __fastcall sgPreviewFileMouseDown(System::TObject* Sender, System::Uitypes::TMouseButton Button, System::Classes::TShiftState Shift, int X, int Y);
	void __fastcall ColumnMapped(System::TObject* Sender);
	void __fastcall FormKeyDown(System::TObject* Sender, System::Word &Key, System::Classes::TShiftState Shift);
	void __fastcall FormResize(System::TObject* Sender);
	void __fastcall btnExpBuilderClick(System::TObject* Sender);
	void __fastcall pnlFieldsResize(System::TObject* Sender);
	void __fastcall cbTableNamesChange(System::TObject* Sender);
	void __fastcall cbDateOrderChange(System::TObject* Sender);
	void __fastcall cbLoadWhenClick(System::TObject* Sender);
	void __fastcall cbSkipIfClick(System::TObject* Sender);
	void __fastcall sgMappingsTopLeftChanged(System::TObject* Sender);
	void __fastcall imgAutoArrangeClick(System::TObject* Sender);
	void __fastcall pnlCategoryResize(System::TObject* Sender);
	void __fastcall pnlStep3OutlookResize(System::TObject* Sender);
	void __fastcall rbOutlookDefFolderClick(System::TObject* Sender);
	void __fastcall edXMLRecordsTagChange(System::TObject* Sender);
	void __fastcall pbLogoPaint(System::TObject* Sender);
	
private:
	bool FToBuildMappings;
	int frmHeightMin;
	int frmHeightMax;
	int frmWidthMin;
	int frmWidthMax;
	Vcl::Graphics::TBitmap* bmpDropdownArrow;
	int FintCurStep;
	int intCountStep;
	bool IsRun;
	System::UnicodeString CaptionsFromFirstRow;
	int intBreakShiftX;
	int intBreakShiftY;
	System::Classes::TList* lstBreaks;
	int InDownMouse;
	bool MousePressed;
	System::Classes::TStrings* lstTextSample;
	bool TxtWasChanged;
	bool BreaksWasChanged;
	TSMISaveSpecNotifyEvent OnSaveSpec;
	System::Classes::TNotifyEvent OnLoadSpec;
	TSMIGetSpecificationsEvent OnGetSpecifications;
	TSMIDirection FDirection;
	bool __fastcall MappingsAreEmpty();
	void __fastcall ClearMappedFields();
	void __fastcall UpdateButtons();
	int __fastcall GetBreak(int X, bool IsAdd);
	System::WideChar __fastcall GetDelimiter();
	System::WideChar __fastcall GetQualifier();
	Smibase::TTableTypeImport __fastcall GetTableTypeIndex();
	System::UnicodeString __fastcall GetNormalizedFieldName(const System::UnicodeString Source, bool Add);
	void __fastcall LoadTxt();
	void __fastcall SetCurStep(int Value);
	void __fastcall DrawCheckBox(Winapi::Windows::THandle ACanvasHandle, const System::Types::TRect &R, bool IsChecked);
	void __fastcall ClearOutlookFolders();
	int __fastcall GetMapIndex(System::UnicodeString Value, bool IsName);
	System::UnicodeString __fastcall GetFieldCaption(const System::UnicodeString FieldName);
	void __fastcall BuildListField();
	void __fastcall LoadFileToGrid();
	void __fastcall BuildPreviewGrid();
	void __fastcall BuildDefaultMappings();
	void __fastcall ParserEvaluate(System::TObject* Sender, System::UnicodeString Eval, System::Variant *Args, const System::NativeInt Args_High, int ArgCount, bool IsChild, System::Variant &Value, bool &Done);
	System::Variant __fastcall GetEvalValue(const System::UnicodeString Expression, int RowNo);
	bool __fastcall IsValidStep(int AStepIndex);
	int __fastcall GetTopRow(bool IncludeDummy);
	void __fastcall ApplyPreviewGridStyle();
	
protected:
	_TfrmSMIWizard__1 StepHeader;
	_TfrmSMIWizard__2 StepInfo;
	void __fastcall GetFormatExtFilter(System::UnicodeString &DefExt, System::UnicodeString &Filter);
	MESSAGE void __fastcall WMMinMaxInfo(Winapi::Messages::TWMGetMinMaxInfo &Msg);
	void __fastcall ControlsToProperties(Smibase::TSMImportBaseComponent* smi);
	
public:
	bool IsCanceled;
	Data::Db::TDataSet* Destination;
	System::UnicodeString TableName;
	TSMIWizardDlg* WizardDlg;
	System::Classes::TStrings* FWizMappings;
	System::UnicodeString FWizKeys;
	int FWizPreviewRowCount;
	bool FWizShowCategories;
	__property TSMIDirection Direction = {read=FDirection, nodefault};
	__property int CurStep = {read=FintCurStep, write=SetCurStep, nodefault};
public:
	/* TCustomForm.Create */ inline __fastcall virtual TfrmSMIWizard(System::Classes::TComponent* AOwner) : Vcl::Forms::TForm(AOwner) { }
	/* TCustomForm.CreateNew */ inline __fastcall virtual TfrmSMIWizard(System::Classes::TComponent* AOwner, int Dummy) : Vcl::Forms::TForm(AOwner, Dummy) { }
	/* TCustomForm.CreateScaledNew */ inline __fastcall virtual TfrmSMIWizard(System::Classes::TComponent* AOwner, int ADPI, int Dummy) : Vcl::Forms::TForm(AOwner, ADPI, Dummy) { }
	/* TCustomForm.Destroy */ inline __fastcall virtual ~TfrmSMIWizard() { }
	
public:
	/* TWinControl.CreateParented */ inline __fastcall TfrmSMIWizard(HWND ParentWindow) : Vcl::Forms::TForm(ParentWindow) { }
	
};


enum DECLSPEC_DENUM TSMIRestriction : unsigned char { irDisabled, irReadOnly, irReadWrite };

typedef System::Set<TSMIRestriction, TSMIRestriction::irDisabled, TSMIRestriction::irReadWrite> TSMIRestrictions;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMIUserAccess : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	bool FSpecification;
	bool FSpecificationSave;
	bool FSpecificationLoad;
	bool FSpecificationDelete;
	TSMIRestriction FTableType;
	TSMIRestriction FSourceFileName;
	TSMIRestriction FFileOrigin;
	TSMIRestriction FValueTrim;
	TSMIRestriction FFieldMapping;
	TSMIRestriction FPreviewData;
	TSMIRestriction FImportMode;
	Smibase::TImportModes FHiddenImportModes;
	TSMIRestriction FTextType;
	TSMIRestriction FFieldDelimiter;
	TSMIRestriction FTextQualifier;
	TSMIRestriction FRecordSeparator;
	TSMIRestriction FFirstRow;
	TSMIRestriction FLastRow;
	TSMIRestriction FFieldAdjustment;
	TSMIRestriction FDataFormats;
	TSMIRestriction FLoadWhen;
	TSMIRestriction FSkipIf;
	bool FUseExpressionBuilder;
	
public:
	__fastcall virtual TSMIUserAccess(System::Classes::TComponent* AOwner);
	
__published:
	__property bool Specification = {read=FSpecification, write=FSpecification, nodefault};
	__property bool SpecificationSave = {read=FSpecificationSave, write=FSpecificationSave, nodefault};
	__property bool SpecificationLoad = {read=FSpecificationLoad, write=FSpecificationLoad, nodefault};
	__property bool SpecificationDelete = {read=FSpecificationDelete, write=FSpecificationDelete, nodefault};
	__property TSMIRestriction TableType = {read=FTableType, write=FTableType, default=2};
	__property TSMIRestriction SourceFileName = {read=FSourceFileName, write=FSourceFileName, default=2};
	__property TSMIRestriction FileOrigin = {read=FFileOrigin, write=FFileOrigin, default=2};
	__property TSMIRestriction ValueTrim = {read=FValueTrim, write=FValueTrim, default=2};
	__property TSMIRestriction FieldMapping = {read=FFieldMapping, write=FFieldMapping, default=2};
	__property TSMIRestriction PreviewData = {read=FPreviewData, write=FPreviewData, default=2};
	__property TSMIRestriction ImportMode = {read=FImportMode, write=FImportMode, default=2};
	__property Smibase::TImportModes HiddenImportModes = {read=FHiddenImportModes, write=FHiddenImportModes, default=0};
	__property TSMIRestriction TextType = {read=FTextType, write=FTextType, default=2};
	__property TSMIRestriction FieldDelimiter = {read=FFieldDelimiter, write=FFieldDelimiter, default=2};
	__property TSMIRestriction TextQualifier = {read=FTextQualifier, write=FTextQualifier, default=2};
	__property TSMIRestriction RecordSeparator = {read=FRecordSeparator, write=FRecordSeparator, default=2};
	__property TSMIRestriction FirstRow = {read=FFirstRow, write=FFirstRow, default=2};
	__property TSMIRestriction LastRow = {read=FLastRow, write=FLastRow, default=2};
	__property TSMIRestriction FieldAdjustment = {read=FFieldAdjustment, write=FFieldAdjustment, default=2};
	__property TSMIRestriction DataFormats = {read=FDataFormats, write=FDataFormats, default=2};
	__property TSMIRestriction LoadWhen = {read=FLoadWhen, write=FLoadWhen, default=2};
	__property TSMIRestriction SkipIf = {read=FSkipIf, write=FSkipIf, default=2};
	__property bool UseExpressionBuilder = {read=FUseExpressionBuilder, write=FUseExpressionBuilder, default=1};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMIUserAccess() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TSMIWizardStyle : unsigned char { wsWindows95, wsWindows2000 };

class PASCALIMPLEMENTATION TSMIWizardDlg : public Smibase::TSMImportBaseComponent
{
	typedef Smibase::TSMImportBaseComponent inherited;
	
private:
	System::Classes::THelpContext FHelpContext;
	int FSheetIndex;
	TfrmSMIWizard* FfrmSMIWizard;
	TSMIUserAccess* FUserAccess;
	Vcl::Graphics::TPicture* FPicture;
	bool FShowPicture;
	TSMICategories* FCategories;
	Vcl::Graphics::TIcon* FIcon;
	Smibase::TImportFormatTypes FFormats;
	Vcl::Controls::TCaption FTitle;
	bool FConfirmCancelExit;
	bool FConfirmExecuteStart;
	System::UnicodeString FInitialDir;
	TSMIGetSpecificationsEvent FOnGetSpecifications;
	TSMIGetSpecificationsEvent FOnGetFieldList;
	TSMICloseEvent FCloseEvent;
	TSMIWizardStyle FWizardStyle;
	bool FShowFileHeader;
	bool FSetupSpecificationOnly;
	System::Classes::TNotifyEvent FOnShow;
	TSMIStepChangeEvent FOnStepChange;
	System::Classes::TNotifyEvent FOnBeforeAutoMapping;
	int FPreviewRowCount;
	Smipst::TSMIOutlookProperties* FOutlookProperties;
	Smi2xml::TSMIXMLTags* FXMLTags;
	void __fastcall SetOutlookProperties(Smipst::TSMIOutlookProperties* Value);
	void __fastcall SetXMLTags(Smi2xml::TSMIXMLTags* Value);
	Vcl::Graphics::TPicture* __fastcall GetPicture();
	void __fastcall SetPicture(Vcl::Graphics::TPicture* Value);
	Vcl::Graphics::TIcon* __fastcall GetIcon();
	void __fastcall SetIcon(Vcl::Graphics::TIcon* Value);
	TSMICategories* __fastcall GetCategories();
	void __fastcall SetCategories(TSMICategories* Value);
	TSMIUserAccess* __fastcall GetUserAccess();
	void __fastcall SetUserAccess(TSMIUserAccess* Value);
	void __fastcall SetRestrictionToControls();
	void __fastcall SaveSpecClick(System::TObject* Sender, const System::UnicodeString Caption, const System::UnicodeString FileName);
	void __fastcall LoadSpecClick(System::TObject* Sender);
	
protected:
	void __fastcall PropertiesToControls();
	void __fastcall CreateCategories();
	
public:
	__fastcall virtual TSMIWizardDlg(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMIWizardDlg();
	HIDESBASE System::Uitypes::TModalResult __fastcall Execute();
	void __fastcall ExecuteWithoutDialog();
	void __fastcall ShowSpecificationDialog();
	void __fastcall ControlsToProperties();
	virtual void __fastcall LoadSpecificationFromStrings(System::Classes::TStrings* lstSpec);
	virtual void __fastcall SaveSpecificationToStream(System::Classes::TStream* Stream, const System::UnicodeString SpecName);
	
__published:
	__property System::Classes::THelpContext HelpContext = {read=FHelpContext, write=FHelpContext, default=0};
	__property int SheetIndex = {read=FSheetIndex, write=FSheetIndex, default=0};
	__property Vcl::Graphics::TPicture* Picture = {read=GetPicture, write=SetPicture};
	__property bool ShowPicture = {read=FShowPicture, write=FShowPicture, default=1};
	__property TSMICategories* Categories = {read=GetCategories, write=SetCategories};
	__property Vcl::Graphics::TIcon* Icon = {read=GetIcon, write=SetIcon};
	__property Fixed;
	__property Smibase::TImportFormatTypes Formats = {read=FFormats, write=FFormats, nodefault};
	__property System::UnicodeString InitialDir = {read=FInitialDir, write=FInitialDir};
	__property TSMIWizardStyle WizardStyle = {read=FWizardStyle, write=FWizardStyle, default=1};
	__property bool ConfirmCancelExit = {read=FConfirmCancelExit, write=FConfirmCancelExit, default=1};
	__property bool ConfirmExecuteStart = {read=FConfirmExecuteStart, write=FConfirmExecuteStart, default=0};
	__property bool ShowFileHeader = {read=FShowFileHeader, write=FShowFileHeader, default=0};
	__property MaxScanRows = {default=0};
	__property RowFirst = {default=1};
	__property RowLast = {default=2147483647};
	__property RowFieldNames = {default=1};
	__property SourceFileName = {default=0};
	__property TableType = {default=2};
	__property Vcl::Controls::TCaption Title = {read=FTitle, write=FTitle};
	__property TSMIUserAccess* UserAccess = {read=GetUserAccess, write=SetUserAccess};
	__property int PreviewRowCount = {read=FPreviewRowCount, write=FPreviewRowCount, default=20};
	__property FieldDelimiter = {default=2};
	__property FieldDelimiterCustom = {default=0};
	__property TextQualifier = {default=2};
	__property TextQualifierCustom = {default=34};
	__property RecordSeparator = {default=1};
	__property RecordSeparatorCustom = {default=0};
	__property bool SetupSpecificationOnly = {read=FSetupSpecificationOnly, write=FSetupSpecificationOnly, default=0};
	__property Smipst::TSMIOutlookProperties* OutlookProperties = {read=FOutlookProperties, write=SetOutlookProperties};
	__property Smi2xml::TSMIXMLTags* XMLTags = {read=FXMLTags, write=SetXMLTags};
	__property TSMIGetSpecificationsEvent OnGetSpecifications = {read=FOnGetSpecifications, write=FOnGetSpecifications};
	__property TSMIGetSpecificationsEvent OnGetFieldList = {read=FOnGetFieldList, write=FOnGetFieldList};
	__property TSMICloseEvent OnClose = {read=FCloseEvent, write=FCloseEvent};
	__property System::Classes::TNotifyEvent OnShow = {read=FOnShow, write=FOnShow};
	__property TSMIStepChangeEvent OnStepChange = {read=FOnStepChange, write=FOnStepChange};
	__property System::Classes::TNotifyEvent OnBeforeAutoMapping = {read=FOnBeforeAutoMapping, write=FOnBeforeAutoMapping};
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Smiwiz */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMIWIZ)
using namespace Smiwiz;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMIWizHPP
