﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMDBISAM.pas' rev: 37.00 (Windows)

#ifndef SMDBISAMHPP
#define SMDBISAMHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <SMCells.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smdbisam
{
//-- forward type declarations -----------------------------------------------
struct TDBISAMField1;
struct TDBISAMField123;
struct TDBISAMField;
struct TDBISAMRecordHeader;
struct TDBISAMHeader123;
struct TDBISAMHeader;
struct TDBISAMPageHeader;
struct TDBISAMBlockHeader;
struct TDBISAMBlobHeader;
class DELPHICLASS TSMDBISAMTable;
class DELPHICLASS TDBISAM;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TDBISAMFieldType : unsigned char { dftUnknow, dftString, dftDate, dftBLOB, dftLogical, dftInt16, dftInt32, dftFloat, dftBCD, dftBytes, dftTime, dftTimeStamp, dftUInt16, dftUInt32, dftDouble, dftVarBytes, dftLockInfo, dftCursor, dftInt64, dftUInt64, dftADT, dftArray, dftRef, dftTable };

enum DECLSPEC_DENUM TDBISAMFieldSubType : unsigned char { dfstUnknown, dfstPassword, dfstMoney, dfstMEMO, dfstBinary, dfstFmtMEMO, dfstOLE, dfstGraphic, dfstDBSOLE, dfstTypedBinary, dfstAutoInc, dfstAccOLE, dfstFixed, dfstUnicode, dfstHMEMO, dfstHBinary, dfstADTNestedTable, dfstBFile, dfstADTDate, dfstGUID, dfstMD5 };

#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBISAMField1
{
public:
	System::Word FieldNum;
	System::SmallString<30> FieldName;
	System::SmallString<50> Description;
	TDBISAMFieldType DataType;
	System::Byte SubType;
	System::Byte Length;
	System::Byte Decimals;
	System::Word Offset;
	bool Required;
	bool Encrypted;
	System::SmallString<50> Minimum;
	System::SmallString<50> Maximum;
	System::SmallString<50> Default;
	System::StaticArray<System::Byte, 20> EmptySpace;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBISAMField123
{
public:
	System::Word FieldNum;
	System::SmallString<30> FieldName;
	System::SmallString<50> Description;
	TDBISAMFieldType DataType;
	System::Byte SubType;
	System::Byte Length;
	System::Byte Decimals;
	System::Byte DataSize;
	System::Byte DataDecimals;
	System::Word Offset;
	bool Required;
	System::Byte CharCase;
	System::SmallString<50> Minimum;
	System::SmallString<50> Maximum;
	System::SmallString<50> Default;
	bool ExpressionField;
	int ExpressionTokens;
	bool Hidden;
	bool SortDescending;
	System::SmallString<100> FieldOrigin;
	System::Word OriginFieldNum;
	System::Word FieldPos;
	System::SmallString<100> FieldDatabaseOrigin;
	System::StaticArray<System::Byte, 308> EmptySpace;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBISAMField
{
public:
	System::Word FieldNum;
	System::SmallString<60> FieldName;
	System::SmallString<100> Description;
	TDBISAMFieldType FieldType;
	System::Byte FieldSubType;
	System::Word Length;
	System::Byte Decimals;
	System::Word DataSize;
	System::Byte DataDecimals;
	System::Word Offset;
	bool Required;
	System::Byte CharCase;
	System::SmallString<100> Minimum;
	System::SmallString<100> Maximum;
	System::SmallString<100> Default;
	System::Byte Compression;
	bool ExpressionField;
	int ExpressionTokens;
	bool Hidden;
	System::SmallString<100> FieldOrigin;
	System::Word OriginFieldNum;
	System::Word FieldPos;
	System::SmallString<100> FieldDatabaseOrigin;
	System::StaticArray<System::Byte, 76> EmptySpace;
};
#pragma pack(pop)


typedef System::StaticArray<TDBISAMField, 1025> TDBISAMFields;

typedef System::StaticArray<System::Byte, 16> TMD5DigestArray;

enum DECLSPEC_DENUM TDBISAMRecordStatus : unsigned char { drsValid, drsDeleted, drsError };

#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBISAMRecordHeader
{
public:
	TDBISAMRecordStatus Status;
	int NextFree;
	int ID;
	TMD5DigestArray Signature;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBISAMHeader123
{
public:
	int UpdateStamp;
	int BlobBlockSize;
	System::Byte VersionNum;
	int NextFreeRecord;
	int NextEndingRecord;
	int LastRecordID;
	System::Word RecordSize;
	System::Word NumberOfFields;
	System::Word BlobFieldCount;
	System::TDateTime LastUpdated;
	System::SmallString<50> Description;
	bool Encrypted;
	System::SmallString<15> Password;
	System::Word LanguageID;
	System::Word SortID;
	System::Word UserMajorVersion;
	System::Word UserMinorVersion;
	bool IsDirty;
	int LastBlobSignature;
	System::Currency LastEngineVersion;
	System::StaticArray<System::Byte, 3> EmptySpace;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBISAMHeader
{
public:
	int UpdateStamp;
	System::StaticArray<System::Byte, 4> EmptySpace1;
	System::Byte VersionNum;
	TMD5DigestArray FileSignature;
	int NextFreeRecord;
	int NextEndingRecord;
	int LastRecordID;
	int LastAutoIncID;
	int NumberOfRecords;
	System::Word RecordSize;
	System::Word NumberOfFields;
	System::Word BlobFieldCount;
	int BlobBlockSize;
	int LastBlobSignature;
	int IndexPageSize;
	System::TDateTime LastUpdated;
	System::SmallString<100> Description;
	bool Encrypted;
	TMD5DigestArray Digest;
	int LocaleID;
	System::Word UserMajorVersion;
	System::Word UserMinorVersion;
	bool IsDirty;
	System::StaticArray<System::Byte, 314> EmptySpace2;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBISAMPageHeader
{
public:
	System::Byte PageType;
	System::Word NumberOfKeys;
	int LeftNumber;
	int RightNumber;
	System::Word CompressedSize;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBISAMBlockHeader
{
public:
	int PrevNumber;
	int NextNumber;
	System::Word Length;
	int Signature;
	int TotalLength;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TDBISAMBlobHeader
{
public:
	int UpdateStamp;
	System::StaticArray<System::Byte, 4> EmptySpace1;
	System::Byte VersionNum;
	TMD5DigestArray FileSignature;
	int NextFreeBlock;
	int NextEndingBlock;
	bool IsDirty;
	System::StaticArray<System::Byte, 478> EmptySpace;
};
#pragma pack(pop)


class PASCALIMPLEMENTATION TSMDBISAMTable : public Smcells::TSpreadSheet
{
	typedef Smcells::TSpreadSheet inherited;
	
public:
	TDBISAMHeader DBHeader;
	TDBISAMFields Fields;
public:
	/* TSpreadSheet.Create */ inline __fastcall virtual TSMDBISAMTable(System::Classes::TComponent* AOwner) : Smcells::TSpreadSheet(AOwner) { }
	/* TSpreadSheet.Destroy */ inline __fastcall virtual ~TSMDBISAMTable() { }
	
};


class PASCALIMPLEMENTATION TDBISAM : public Smcells::TSpreadSheetFile
{
	typedef Smcells::TSpreadSheetFile inherited;
	
private:
	System::Classes::TStream* BLOBStream;
	System::UnicodeString FPassword;
	Smcells::TSMIOnPasswordEvent FOnPassword;
	TDBISAMHeader __fastcall GetDBHeader();
	TDBISAMField __fastcall GetFields(int Index);
	bool __fastcall CompareDigest(const TMD5DigestArray &d1, const TMD5DigestArray &d2);
	
protected:
	System::UnicodeString FoldPassword;
	System::Classes::TStream* FCurrentStream;
	virtual void __fastcall ReadBLOBValue(unsigned BlockNo, unsigned ASize, System::UnicodeString &s);
	
public:
	TDBISAMBlobHeader BLOBHeader;
	__fastcall virtual TDBISAM(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TDBISAM();
	virtual void __fastcall LoadFromStream(System::Classes::TStream* AStream);
	virtual void __fastcall LoadFromFile(const System::WideString FileName);
	virtual void __fastcall BeforeLoad();
	virtual void __fastcall AfterLoad();
	virtual bool __fastcall LoadRecord(int RecNo, int LogicalRecNo);
	virtual int __fastcall FindColumn(const System::UnicodeString AFieldName);
	virtual void __fastcall FillColumnList(System::Classes::TStrings* lst, const System::UnicodeString strFieldList);
	System::UnicodeString __fastcall VersionNumToStr();
	System::UnicodeString __fastcall GetStrFieldType(TDBISAMFieldType FieldType, TDBISAMFieldSubType FieldSubType);
	TDBISAMFieldSubType __fastcall GetFieldSubType(System::Byte Value);
	virtual bool __fastcall IsEncrypted();
	bool __fastcall IsPasswordValid();
	void __fastcall RenameFieldName(int FieldIndex, const System::UnicodeString FieldName);
	__property System::UnicodeString Password = {read=FPassword, write=FPassword};
	__property TDBISAMHeader DBHeader = {read=GetDBHeader};
	__property TDBISAMField Fields[int Index] = {read=GetFields};
	
__published:
	__property Smcells::TSMIOnPasswordEvent OnPassword = {read=FOnPassword, write=FOnPassword};
};


typedef void __fastcall (*TSMDBISAMDecryptBufferEvent)(System::TObject* Sender, void *Buffer, int NumBytes, bool IsHeader, bool IsRecord, bool IsPChar);

typedef void __fastcall (*TSMDBISAMGetPasswordDigestEvent)(System::TObject* Sender, const System::UnicodeString APassword, TMD5DigestArray &AResult);

typedef void __fastcall (*TSMDBISAMCryptInitEvent)(System::TObject* Sender, const TMD5DigestArray &ADigest);

//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE System::StaticArray<System::Byte, 21> arrFieldSubTypeValue;
extern DELPHI_PACKAGE TSMDBISAMDecryptBufferEvent RegisteredDBISAMDecryptBuffer;
extern DELPHI_PACKAGE TSMDBISAMGetPasswordDigestEvent RegisteredDBISAMGetPasswordDigest;
extern DELPHI_PACKAGE TSMDBISAMCryptInitEvent RegisteredDBISAMCryptInit;
extern DELPHI_PACKAGE Smcells::TSMIOnPasswordEvent RegisteredDBISAMPassword;
}	/* namespace Smdbisam */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMDBISAM)
using namespace Smdbisam;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMDBISAMHPP
