﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMIXML.pas' rev: 37.00 (Windows)

#ifndef SMIXMLHPP
#define SMIXMLHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <System.Types.hpp>
#include <System.Variants.hpp>
#include <Winapi.Windows.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smixml
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMXMLItem;
class DELPHICLASS TSMXMLItems;
class DELPHICLASS TSMXMLEngine;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TSMXMLItemKind : unsigned char { ikProperty, ikAttribute, ikComment, ikCDATA };

class PASCALIMPLEMENTATION TSMXMLItem : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TSMXMLItemKind FKind;
	System::UnicodeString FTagName;
	System::Variant FValue;
	System::UnicodeString FAttributes;
	int FLevel;
	TSMXMLItems* FItems;
	TSMXMLItem* FParentItem;
	
public:
	__fastcall virtual TSMXMLItem(System::TObject* AOwner);
	__fastcall virtual ~TSMXMLItem();
	TSMXMLItem* __fastcall GetChild(const System::UnicodeString XMLTag, bool ExpandAllLevels);
	System::UnicodeString __fastcall GetTagXMLValue();
	System::UnicodeString __fastcall GetTagValue();
	void __fastcall ProcessAttributes();
	__property TSMXMLItem* ParentItem = {read=FParentItem};
	__property int Level = {read=FLevel, nodefault};
	__property System::UnicodeString Attributes = {read=FAttributes, write=FAttributes};
	__property TSMXMLItemKind Kind = {read=FKind, write=FKind, nodefault};
	__property System::UnicodeString TagName = {read=FTagName, write=FTagName};
	__property System::Variant Value = {read=FValue, write=FValue};
	__property TSMXMLItems* Items = {read=FItems, write=FItems};
};


class PASCALIMPLEMENTATION TSMXMLItems : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	__fastcall virtual ~TSMXMLItems();
	TSMXMLItem* __fastcall AddItem(TSMXMLItem* ParentItem);
	virtual void __fastcall Clear();
public:
	/* TObject.Create */ inline __fastcall TSMXMLItems() : System::Classes::TList() { }
	
};


typedef void __fastcall (__closure *TSMIXMLOnTagEvent)(System::TObject* Sender, TSMXMLItem* ParentNode, System::UnicodeString ATagName, System::UnicodeString ATagValue, System::UnicodeString ATagAttributes, bool &Accept);

typedef void __fastcall (__closure *TSMIXMLOnAfterTagEvent)(System::TObject* Sender, TSMXMLItem* &Node, bool &Cancel);

class PASCALIMPLEMENTATION TSMXMLEngine : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	bool FAttributesAutoProcess;
	TSMXMLItem* FRootItem;
	TSMIXMLOnTagEvent FOnTag;
	TSMIXMLOnAfterTagEvent FOnAfterTag;
	bool UTF8Processed;
	
protected:
	void __fastcall ParseXMLFromString(const System::UnicodeString Value, int intLength);
	
public:
	__fastcall virtual TSMXMLEngine(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMXMLEngine();
	void __fastcall LoadFromStream(int AStreamSize, System::Classes::TStream* AStream);
	void __fastcall LoadFromFile(const System::UnicodeString AFileName);
	TSMXMLItem* __fastcall GetItemByTag(TSMXMLItem* ARoot, const System::UnicodeString XMLTag);
	__classmethod System::UnicodeString __fastcall GetFirstTagName(System::UnicodeString &AXMLPath);
	__classmethod System::UnicodeString __fastcall GetLastTagName(System::UnicodeString &AXMLPath);
	
__published:
	__property TSMXMLItem* RootItem = {read=FRootItem, write=FRootItem};
	__property bool AttributesAutoProcess = {read=FAttributesAutoProcess, write=FAttributesAutoProcess, default=0};
	__property TSMIXMLOnTagEvent OnTag = {read=FOnTag, write=FOnTag};
	__property TSMIXMLOnAfterTagEvent OnAfterTag = {read=FOnAfterTag, write=FOnAfterTag};
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE System::TDateTime __fastcall XMLStringToDateTime(const System::UnicodeString AValue);
extern DELPHI_PACKAGE bool __fastcall SameStrings(bool CaseSensitive, const System::UnicodeString s1, const System::UnicodeString s2);
}	/* namespace Smixml */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMIXML)
using namespace Smixml;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMIXMLHPP
