﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMInBase.pas' rev: 37.00 (Windows)

#ifndef SMInBaseHPP
#define SMInBaseHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <Winapi.WinSock.hpp>
#include <System.Win.ScktComp.hpp>

//-- user supplied -----------------------------------------------------------

namespace Sminbase
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMInetProxy;
class DELPHICLASS TSMInetBase;
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TSMIReceivedEvent)(System::TObject* Sender, System::UnicodeString &Text);

typedef System::UnicodeString TSMInetAbout;

class PASCALIMPLEMENTATION TSMInetProxy : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	bool FUseProxyServer;
	System::UnicodeString FProxyServer;
	System::UnicodeString FProxyUser;
	System::UnicodeString FProxyPassword;
	int FProxyPort;
	
public:
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	void __fastcall FillProxyInfo();
	
__published:
	__property System::UnicodeString Server = {read=FProxyServer, write=FProxyServer};
	__property System::UnicodeString User = {read=FProxyUser, write=FProxyUser};
	__property System::UnicodeString Password = {read=FProxyPassword, write=FProxyPassword};
	__property bool UseProxy = {read=FUseProxyServer, write=FUseProxyServer, nodefault};
	__property int Port = {read=FProxyPort, write=FProxyPort, default=0};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMInetProxy() { }
	
public:
	/* TObject.Create */ inline __fastcall TSMInetProxy() : System::Classes::TPersistent() { }
	
};


class PASCALIMPLEMENTATION TSMInetBase : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	System::Win::Scktcomp::TClientSocket* FClientSocket;
	TSMInetAbout FAbout;
	bool FConnected;
	int FPort;
	System::UnicodeString FHost;
	System::UnicodeString FAddress;
	bool FKeepConnection;
	TSMInetProxy* FProxy;
	bool FLoginPrompt;
	System::Win::Scktcomp::TSocketNotifyEvent FOnConnect;
	System::Win::Scktcomp::TSocketNotifyEvent FOnDisconnect;
	System::Win::Scktcomp::TSocketErrorEvent FOnError;
	System::Win::Scktcomp::TSocketNotifyEvent FOnLookup;
	System::Win::Scktcomp::TSocketNotifyEvent FOnConnecting;
	System::Win::Scktcomp::TSocketNotifyEvent FOnSendTextToSocket;
	System::Win::Scktcomp::TSocketNotifyEvent FOnReceiveTextFromSocket;
	System::Classes::TNotifyEvent FOnBeforeExecute;
	TSMIReceivedEvent FOnAfterExecute;
	int __fastcall GetPort();
	void __fastcall SetPort(int Value);
	System::UnicodeString __fastcall GetHost();
	void __fastcall SetHost(System::UnicodeString Value);
	void __fastcall SetProxy(TSMInetProxy* Value);
	System::UnicodeString __fastcall GetAddress();
	void __fastcall SetAddress(System::UnicodeString Value);
	System::Win::Scktcomp::TClientType __fastcall GetClientType();
	void __fastcall SetClientType(System::Win::Scktcomp::TClientType Value);
	void __fastcall SetOnSendTextToSocket(System::Win::Scktcomp::TSocketNotifyEvent Value);
	void __fastcall SetOnReceiveTextFromSocket(System::Win::Scktcomp::TSocketNotifyEvent Value);
	void __fastcall SetAbout(const TSMInetAbout Value);
	
protected:
	int CurrentStep;
	int StepCount;
	bool __fastcall AddrIsIP(const System::UnicodeString strAddr);
	void __fastcall DoConnect(System::TObject* Sender, System::Win::Scktcomp::TCustomWinSocket* Socket);
	void __fastcall DoDisconnect(System::TObject* Sender, System::Win::Scktcomp::TCustomWinSocket* Socket);
	void __fastcall DoError(System::TObject* Sender, System::Win::Scktcomp::TCustomWinSocket* Socket, System::Win::Scktcomp::TErrorEvent ErrorEvent, int &ErrorCode);
	void __fastcall DoLookup(System::TObject* Sender, System::Win::Scktcomp::TCustomWinSocket* Socket);
	void __fastcall DoConnecting(System::TObject* Sender, System::Win::Scktcomp::TCustomWinSocket* Socket);
	virtual System::UnicodeString __fastcall InternalExecute();
	virtual void __fastcall BeforeExecute();
	virtual void __fastcall AfterExecute(System::UnicodeString &strReceived);
	int __fastcall SendToSocket(System::UnicodeString s);
	int __fastcall ReceiveFromSocket(void *Buf, int MaxLen);
	System::UnicodeString __fastcall GetLocalHost();
	
public:
	__fastcall virtual TSMInetBase(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMInetBase();
	virtual System::UnicodeString __fastcall GetQuery();
	virtual System::UnicodeString __fastcall GetRawHeaders();
	System::UnicodeString __fastcall Execute();
	virtual void __fastcall Connect();
	virtual void __fastcall Disconnect();
	__property System::Win::Scktcomp::TClientType ClientType = {read=GetClientType, write=SetClientType, nodefault};
	__property bool Connected = {read=FConnected, nodefault};
	
__published:
	__property TSMInetAbout About = {read=FAbout, write=SetAbout};
	__property int Port = {read=GetPort, write=SetPort, nodefault};
	__property System::UnicodeString Host = {read=GetHost, write=SetHost};
	__property System::UnicodeString Address = {read=GetAddress, write=SetAddress};
	__property bool KeepConnection = {read=FKeepConnection, write=FKeepConnection, nodefault};
	__property TSMInetProxy* Proxy = {read=FProxy, write=SetProxy};
	__property bool LoginPrompt = {read=FLoginPrompt, write=FLoginPrompt, default=1};
	__property System::Win::Scktcomp::TSocketNotifyEvent OnConnect = {read=FOnConnect, write=FOnConnect};
	__property System::Win::Scktcomp::TSocketNotifyEvent OnDisconnect = {read=FOnDisconnect, write=FOnDisconnect};
	__property System::Win::Scktcomp::TSocketErrorEvent OnError = {read=FOnError, write=FOnError};
	__property System::Win::Scktcomp::TSocketNotifyEvent OnLookup = {read=FOnLookup, write=FOnLookup};
	__property System::Win::Scktcomp::TSocketNotifyEvent OnConnecting = {read=FOnConnecting, write=FOnConnecting};
	__property System::Win::Scktcomp::TSocketNotifyEvent OnSendTextToSocket = {read=FOnSendTextToSocket, write=SetOnSendTextToSocket};
	__property System::Win::Scktcomp::TSocketNotifyEvent OnReceiveTextFromSocket = {read=FOnReceiveTextFromSocket, write=SetOnReceiveTextFromSocket};
	__property System::Classes::TNotifyEvent OnBeforeExecute = {read=FOnBeforeExecute, write=FOnBeforeExecute};
	__property TSMIReceivedEvent OnAfterExecute = {read=FOnAfterExecute, write=FOnAfterExecute};
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Sminbase */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMINBASE)
using namespace Sminbase;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMInBaseHPP
