unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ScktComp, StdCtrls, Buttons, ComCtrls, ExtCtrls, SMInBase, SMISMTP;

type
  TfrmSendMail = class(TForm)
    lblSubject: TLabel;
    edSubject: TEdit;
    pcMessage: TPageControl;
    tsBody: TTabSheet;
    memoBody: TMemo;
    tsResultCode: TTabSheet;
    memoResult: TMemo;
    pnlHeader: TPanel;
    lblFrom: TLabel;
    lblTo: TLabel;
    lblReplyTo: TLabel;
    edFrom: TEdit;
    edTo: TEdit;
    btnSendMail: TBitBtn;
    edReplyTo: TEdit;
    rgPriority: TRadioGroup;
    lblCharset: TLabel;
    cbCharset: TComboBox;
    lblEncoding: TLabel;
    cbEncoding: TComboBox;
    SMISMTP1: TSMISMTP;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
  end;

var
  frmSendMail: TfrmSendMail;

implementation

{$R *.DFM}
{$R winxp.res}

procedure TfrmSendMail.Button1Click(Sender: TObject);
begin
  with SMISMTP1 do
  begin
    Port := 25;
    Host := 'rs-ukraine.kiev.ua';

    From.Address := edFrom.Text;

    ReplyTo.Clear;
    ReplyTo.Add.Address := edReplyTo.Text;

    Recipients.Clear;
    Recipients.Add.Address := edTo.Text;

    Date := Now();
    Priority := TSMISMTPPriority(rgPriority.ItemIndex);

    Charset := cbCharset.Text;
    Encoding := cbEncoding.Text;

    Subject := edSubject.Text;
    Body.Assign(memoBody.Lines);

    try
      Execute;
      {OR for group mailing without disconnecting:
      Connect;
      Send;
      Disconnect;
      }
      ShowMessage('Message is sent');
    except
      on E: Exception do
        ShowMessage(E.Message);
    end
  end;
end;

end.
