unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, SMInBase, ComCtrls, ScktComp, SMIWeath;

type
  TfrmMain = class(TForm)
    gbOptions: TGroupBox;
    MemoResults: TMemo;
    btnExecute: TButton;
    btnAbout: TButton;
    lblZipCode: TLabel;
    edZipCode: TEdit;
    imgLogo: TImage;
    StatusBar: TStatusBar;
    SMWeatherInfo: TSMWeatherInfo;
    procedure btnExecuteClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure SMWeatherInfoConnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMWeatherInfoConnecting(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMWeatherInfoDisconnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMWeatherInfoError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure SMWeatherInfoLookup(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMWeatherInfoReceiveTextFromSocket(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMWeatherInfoSendTextToSocket(Sender: TObject;
      Socket: TCustomWinSocket);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}
{$R winxp.res}

uses SMInCnst;

procedure TfrmMain.btnExecuteClick(Sender: TObject);
begin
  {define a Zip code}
  SMWeatherInfo.Zip := edZipCode.Text;
  SMWeatherInfo.TrackingType := wttZip;

  {track a weather}
  SMWeatherInfo.Execute;

  {show results}
  MemoResults.Lines.Text := '';
  MemoResults.Lines.Add('Temperature: ' + IntToStr(SMWeatherInfo.Temperature) + 'C');
end;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  AboutSMInet
end;

procedure TfrmMain.SMWeatherInfoConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Connected.';
end;

procedure TfrmMain.SMWeatherInfoConnecting(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Connecting...';
end;

procedure TfrmMain.SMWeatherInfoDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Disconnected.';
end;

procedure TfrmMain.SMWeatherInfoError(Sender: TObject;
  Socket: TCustomWinSocket; ErrorEvent: TErrorEvent;
  var ErrorCode: Integer);
begin
  StatusBar.SimpleText := 'Error: ' + IntToStr(ErrorCode);
end;

procedure TfrmMain.SMWeatherInfoLookup(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Lookup...';
end;

procedure TfrmMain.SMWeatherInfoReceiveTextFromSocket(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Receiving...';
end;

procedure TfrmMain.SMWeatherInfoSendTextToSocket(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Sending...';
end;

end.
