unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, smiupdate, smidirect;

type
  TfrmMain = class(TForm)
    gbOptions: TGroupBox;
    edHost: TEdit;
    lblHostName: TLabel;
    btnExecute: TButton;
    btnAbout: TButton;
    imgLogo: TImage;
    lblPort: TLabel;
    edPort: TEdit;
    MemoResults: TMemo;
    pnlStatus: TPanel;
    lblURL: TLabel;
    SMWebDirect: TSMWebDirect;
    lblUserID: TLabel;
    edUserID: TEdit;
    lblPassword: TLabel;
    edPassword: TEdit;
    lblWEBSettings: TLabel;
    lblRemoteFile: TLabel;
    edRemoteFile: TEdit;
    pbStatus: TProgressBar;
    lblProgress: TLabel;
    procedure btnExecuteClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lblURLClick(Sender: TObject);
    procedure SMWebDirectProgress(Sender: TObject; CurValue,
      MaxValue: Integer; var Abort: Boolean);
    procedure SMWebDirectAfterExecute(Sender: TObject);
    procedure SMWebDirectActionChange(Sender: TObject);
    procedure SMWebDirectBeforeExecute(Sender: TObject);
    procedure SMWebDirectStatusChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}
{$R winxp.res}

uses ShellAPI, SMInCnst;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  AboutSMInet
end;

procedure TfrmMain.lblURLClick(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar((Sender as TLabel).Caption), nil, nil, SW_SHOWNORMAL);
end;

procedure TfrmMain.btnExecuteClick(Sender: TObject);
begin
  MemoResults.Lines.Clear;

  SMWebDirect.Port := StrToIntDef(edPort.Text, SMWebDirect.Port);
  SMWebDirect.Host := edHost.Text;
  SMWebDirect.User := edUserID.Text;
  SMWebDirect.Password := edPassword.Text;

  SMWebDirect.RemoteFileName := edRemoteFile.Text;

  SMWebDirect.Execute
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Application.Title := Caption;
  edHost.Text := SMWebDirect.Host;
  edPort.Text := IntToStr(SMWebDirect.Port);
  edUserID.Text := SMWebDirect.User;
  edPassword.Text := SMWebDirect.Password;

  edRemoteFile.Text := SMWebDirect.RemoteFileName;
end;

procedure TfrmMain.SMWebDirectProgress(Sender: TObject; CurValue,
  MaxValue: Integer; var Abort: Boolean);
begin
  pbStatus.Max := MaxValue;
  pbStatus.Position := CurValue;
  lblProgress.Caption := 'Downloaded ' + IntToStr(CurValue) + ' of ' + IntToStr(MaxValue) + ' bytes (' + IntToStr(CurValue*100 div MaxValue) + '%)';

  Application.ProcessMessages
end;

procedure TfrmMain.SMWebDirectAfterExecute(Sender: TObject);
var
  s: string;
begin
  pbStatus.Visible := False;

  case SMWebDirect.Status of
    isFinished: s := 'File updated succesfully';
    isFailed: s := 'Error is occured during file updating.';
    isSkipped: s := 'File is not changed';
  else
    s := '';
  end;

  if (s <> '') then
    ShowMessage(s)
end;

procedure TfrmMain.SMWebDirectActionChange(Sender: TObject);
const
  arrAction: array[TSMIAction] of string = (
                'Idle',
                'Connecting...',
                'Connected.',
                'Disconnecting...',
                'Disconnected.',
                'File search...',
                'File found.',
                'Comparing...',
                'Compared.',
                'Downloading...',
                'Downloaded.');
begin
  lblProgress.Caption := arrAction[SMWebDirect.Action];

  Application.ProcessMessages
end;

procedure TfrmMain.SMWebDirectBeforeExecute(Sender: TObject);
begin
  pbStatus.Visible := True;
  pbStatus.Position := 0;

  Application.ProcessMessages
end;

procedure TfrmMain.SMWebDirectStatusChange(Sender: TObject);
const
  arrStatus: array[TSMIStatus] of string = (
             'In progress...',
             'Completed.',
             'Failed.',
             'Skipped',
             'Remote file is not found');
begin
  lblProgress.Caption := arrStatus[SMWebDirect.Status];

  Application.ProcessMessages
end;


end.
