﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMRTypes.pas' rev: 37.00 (Windows)

#ifndef SMRTypesHPP
#define SMRTypesHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <System.UITypes.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smrtypes
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMRCalculation;
class DELPHICLASS TSMRHighLight;
class DELPHICLASS TSMRHighLights;
class DELPHICLASS TSMRVariable;
class DELPHICLASS TSMRVariables;
class DELPHICLASS TSMRParameter;
class DELPHICLASS TSMRParameters;
class DELPHICLASS TSMROutline;
class DELPHICLASS TSMROutlines;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TCalcType : unsigned char { ctNothing, ctCount, ctSum, ctAverage, ctLowest, ctHighest };

enum DECLSPEC_DENUM TResetType : unsigned char { rtEndReport, rtEndPage, rtEndGroup };

enum DECLSPEC_DENUM TSMRCalculate : unsigned char { rcOnEveryRow, rcGroupChange, rcVariableChange };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMRCalculation : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::UnicodeString FResetGroup;
	TCalcType FCalcType;
	TResetType FResetType;
	TSMRCalculate FCalculate;
	System::UnicodeString FGroupChange;
	System::UnicodeString FVariableChange;
	
public:
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	bool __fastcall StateChanged(const System::UnicodeString AGroupChanged, const System::UnicodeString AVariableChanged);
	
__published:
	__property System::UnicodeString ResetGroup = {read=FResetGroup, write=FResetGroup};
	__property TResetType ResetType = {read=FResetType, write=FResetType, nodefault};
	__property TCalcType CalcType = {read=FCalcType, write=FCalcType, nodefault};
	__property TSMRCalculate Calculate = {read=FCalculate, write=FCalculate, default=0};
	__property System::UnicodeString GroupChange = {read=FGroupChange, write=FGroupChange};
	__property System::UnicodeString VariableChange = {read=FVariableChange, write=FVariableChange};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMRCalculation() { }
	
public:
	/* TObject.Create */ inline __fastcall TSMRCalculation() : System::Classes::TPersistent() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMRHighLight : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	System::UnicodeString FExpression;
	Vcl::Graphics::TFont* FFont;
	System::Uitypes::TColor FColor;
	void __fastcall SetFont(Vcl::Graphics::TFont* Value);
	
public:
	__fastcall virtual TSMRHighLight(System::Classes::TCollection* Collection);
	__fastcall virtual ~TSMRHighLight();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::UnicodeString Expression = {read=FExpression, write=FExpression};
	__property Vcl::Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property System::Uitypes::TColor Color = {read=FColor, write=FColor, nodefault};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMRHighLights : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
public:
	TSMRHighLight* operator[](int Index) { return this->Items[Index]; }
	
private:
	System::Classes::TComponent* FSMRControl;
	TSMRHighLight* __fastcall GetHighLight(int Index);
	void __fastcall SetHighLight(int Index, TSMRHighLight* Value);
	
protected:
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	
public:
	__fastcall TSMRHighLights(System::Classes::TComponent* SMRCntrl);
	HIDESBASE TSMRHighLight* __fastcall Add();
	__property System::Classes::TComponent* SMRControl = {read=FSMRControl};
	__property TSMRHighLight* Items[int Index] = {read=GetHighLight, write=SetHighLight/*, default*/};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TSMRHighLights() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TSMRVariable : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	System::UnicodeString FExpression;
	TSMRCalculation* FCalculation;
	System::UnicodeString FName;
	System::Variant FPrevValue;
	System::Variant FCurValue;
	TSMRCalculation* __fastcall GetCalculation();
	void __fastcall SetCalculation(TSMRCalculation* Value);
	
protected:
	bool __fastcall StorePrevValue();
	bool __fastcall StoreCurValue();
	
public:
	__fastcall virtual TSMRVariable(System::Classes::TCollection* Collection);
	__fastcall virtual ~TSMRVariable();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	bool __fastcall ValueChanged();
	
__published:
	__property System::UnicodeString Expression = {read=FExpression, write=FExpression};
	__property TSMRCalculation* Calculation = {read=GetCalculation, write=SetCalculation};
	__property System::UnicodeString Name = {read=FName, write=FName};
	__property System::Variant PrevValue = {read=FPrevValue, write=FPrevValue, stored=StorePrevValue};
	__property System::Variant CurValue = {read=FCurValue, write=FCurValue, stored=StoreCurValue};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMRVariables : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
public:
	TSMRVariable* operator[](int Index) { return this->Items[Index]; }
	
private:
	System::Classes::TComponent* FSMRControl;
	TSMRVariable* __fastcall GetVariable(int Index);
	void __fastcall SetVariable(int Index, TSMRVariable* Value);
	
protected:
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	
public:
	__fastcall TSMRVariables(System::Classes::TComponent* SMRCntrl);
	HIDESBASE TSMRVariable* __fastcall Add();
	__property System::Classes::TComponent* SMRControl = {read=FSMRControl};
	__property TSMRVariable* Items[int Index] = {read=GetVariable, write=SetVariable/*, default*/};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TSMRVariables() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TSMRParameterEditor : unsigned char { peEdit, peMemo, peCheckBox, peCombobox, peListBox };

enum DECLSPEC_DENUM TSMRParameterMode : unsigned char { pmAskAlways, pmAskUndefined };

class PASCALIMPLEMENTATION TSMRParameter : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	System::UnicodeString FName;
	System::UnicodeString FDisplayLabel;
	System::Variant FValue;
	TSMRParameterEditor FParameterEditor;
	TSMRParameterMode FParameterMode;
	System::Classes::TStrings* FParamPromptValues;
	void __fastcall SetParamPromptValues(System::Classes::TStrings* Value);
	
public:
	__fastcall virtual TSMRParameter(System::Classes::TCollection* Collection);
	__fastcall virtual ~TSMRParameter();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::UnicodeString DisplayLabel = {read=FDisplayLabel, write=FDisplayLabel};
	__property System::UnicodeString Name = {read=FName, write=FName};
	__property System::Variant Value = {read=FValue, write=FValue};
	__property System::Classes::TStrings* ParamPromptValues = {read=FParamPromptValues, write=SetParamPromptValues};
	__property TSMRParameterEditor ParameterEditor = {read=FParameterEditor, write=FParameterEditor, default=0};
	__property TSMRParameterMode ParameterMode = {read=FParameterMode, write=FParameterMode, default=0};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMRParameters : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
public:
	TSMRParameter* operator[](int Index) { return this->Items[Index]; }
	
private:
	System::Classes::TComponent* FSMRControl;
	TSMRParameter* __fastcall GetParameter(int Index);
	void __fastcall SetParameter(int Index, TSMRParameter* Value);
	
protected:
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	
public:
	__fastcall TSMRParameters(System::Classes::TComponent* SMRCntrl);
	HIDESBASE TSMRParameter* __fastcall Add();
	TSMRParameter* __fastcall ParamByName(const System::UnicodeString Value);
	__property System::Classes::TComponent* SMRControl = {read=FSMRControl};
	__property TSMRParameter* Items[int Index] = {read=GetParameter, write=SetParameter/*, default*/};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TSMRParameters() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMROutline : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	System::UnicodeString FText;
	int FPageNo;
	int FBarNo;
	int FTop;
	
public:
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::UnicodeString Text = {read=FText, write=FText};
	__property int PageNo = {read=FPageNo, write=FPageNo, nodefault};
	__property int BarNo = {read=FBarNo, write=FBarNo, nodefault};
	__property int Top = {read=FTop, write=FTop, nodefault};
public:
	/* TCollectionItem.Create */ inline __fastcall virtual TSMROutline(System::Classes::TCollection* Collection) : System::Classes::TCollectionItem(Collection) { }
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TSMROutline() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMROutlines : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
private:
	System::Classes::TComponent* FSMRControl;
	
protected:
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	
public:
	__fastcall TSMROutlines(System::Classes::TComponent* SMRCntrl);
	HIDESBASE TSMROutline* __fastcall Add();
	__property System::Classes::TComponent* SMRControl = {read=FSMRControl};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TSMROutlines() { }
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
}	/* namespace Smrtypes */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMRTYPES)
using namespace Smrtypes;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMRTypesHPP
