﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMRView.pas' rev: 37.00 (Windows)

#ifndef SMRViewHPP
#define SMRViewHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.Messages.hpp>
#include <System.SysUtils.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.Controls.hpp>
#include <Vcl.Forms.hpp>
#include <PrintSM.hpp>
#include <Vcl.Buttons.hpp>
#include <Vcl.StdCtrls.hpp>
#include <Vcl.ExtCtrls.hpp>
#include <SMRFind.hpp>
#include <System.Types.hpp>
#include <System.UITypes.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smrview
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMRPrevHighlightRect;
class DELPHICLASS TSMRPagePreview;
class DELPHICLASS TSMRPreview;
//-- type declarations -------------------------------------------------------
#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMRPrevHighlightRect : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::Types::TRect r;
	System::Uitypes::TColor Background;
public:
	/* TObject.Create */ inline __fastcall TSMRPrevHighlightRect() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TSMRPrevHighlightRect() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TZoomByClick : unsigned char { zcNone, zcInc, zcDec };

class PASCALIMPLEMENTATION TSMRPagePreview : public Vcl::Forms::TScrollBox
{
	typedef Vcl::Forms::TScrollBox inherited;
	
private:
	Vcl::Extctrls::TPanel* pnlPage;
	Vcl::Stdctrls::TLabel* bvlRight;
	Vcl::Stdctrls::TLabel* bvlBottom;
	Vcl::Extctrls::TPaintBox* pbPage;
	int CoefScale;
	int FPageNumber;
	int FBarNumber;
	Printsm::TSMPrintBaseComponent* FSMPrintComponent;
	bool FShowMargins;
	bool FShowGrid;
	TZoomByClick FZoomByClick;
	System::Classes::TNotifyEvent FPageNumberChangeEvent;
	System::Classes::TNotifyEvent FBarNumberChangeEvent;
	System::Classes::TNotifyEvent FZoomChangeEvent;
	void __fastcall SetReport(Printsm::TSMPrintBaseComponent* Value);
	int __fastcall GetPageNumber();
	int __fastcall GetBarNumber();
	void __fastcall SetZoom(int Value);
	void __fastcall SetShowMargins(bool Value);
	void __fastcall SetShowGrid(bool Value);
	void __fastcall SetZoomByClick(TZoomByClick Value);
	Vcl::Graphics::TCanvas* __fastcall GetPaintCanvas();
	HIDESBASE MESSAGE void __fastcall WMSize(Winapi::Messages::TWMSize &Message);
	
protected:
	System::Classes::TList* HighlightRects;
	Smrfind::TfrmSMRFind* dlgFind;
	TSMRPrevHighlightRect* __fastcall AddHighlightRect();
	void __fastcall pbPageMouseDown(System::TObject* Sender, System::Uitypes::TMouseButton Button, System::Classes::TShiftState Shift, int X, int Y);
	void __fastcall pbPageMouseMove(System::TObject* Sender, System::Classes::TShiftState Shift, int X, int Y);
	void __fastcall pbPageMouseUp(System::TObject* Sender, System::Uitypes::TMouseButton Button, System::Classes::TShiftState Shift, int X, int Y);
	void __fastcall pbPagePaint(System::TObject* Sender);
	virtual void __fastcall SetPageNumber(int Value);
	void __fastcall SetBarNumber(int Value);
	int __fastcall GetOffset();
	virtual int __fastcall GetLeftOffset();
	void __fastcall PreviewResize();
	
public:
	__fastcall virtual TSMRPagePreview(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMRPagePreview();
	int __fastcall GetZoomFitToWidth();
	int __fastcall GetZoomFitToPage();
	void __fastcall ClearHighlightRects();
	__property Vcl::Graphics::TCanvas* PaintCanvas = {read=GetPaintCanvas};
	
__published:
	__property Printsm::TSMPrintBaseComponent* Report = {read=FSMPrintComponent, write=SetReport};
	__property int PageNumber = {read=GetPageNumber, write=SetPageNumber, nodefault};
	__property int BarNumber = {read=GetBarNumber, write=SetBarNumber, nodefault};
	__property int Zoom = {read=CoefScale, write=SetZoom, nodefault};
	__property bool ShowMargins = {read=FShowMargins, write=SetShowMargins, nodefault};
	__property bool ShowGrid = {read=FShowGrid, write=SetShowGrid, nodefault};
	__property TZoomByClick ZoomByClick = {read=FZoomByClick, write=SetZoomByClick, nodefault};
	__property System::Classes::TNotifyEvent PageNumberChangeEvent = {read=FPageNumberChangeEvent, write=FPageNumberChangeEvent};
	__property System::Classes::TNotifyEvent BarNumberChangeEvent = {read=FBarNumberChangeEvent, write=FBarNumberChangeEvent};
	__property System::Classes::TNotifyEvent ZoomChangeEvent = {read=FZoomChangeEvent, write=FZoomChangeEvent};
public:
	/* TWinControl.CreateParented */ inline __fastcall TSMRPagePreview(HWND ParentWindow) : Vcl::Forms::TScrollBox(ParentWindow) { }
	
};


class PASCALIMPLEMENTATION TSMRPreview : public TSMRPagePreview
{
	typedef TSMRPagePreview inherited;
	
private:
	Vcl::Graphics::TBitmap* bmpOutline;
	Vcl::Forms::TScrollBox* FThumbContainer;
	bool FShowThumbnails;
	Vcl::Forms::TScrollBox* FOutlineContainer;
	bool FEnableOutlines;
	bool FShowOutlines;
	void __fastcall SetShowThumbnails(bool Value);
	void __fastcall SetShowOutlines(bool Value);
	void __fastcall ThumpPageClick(System::TObject* Sender);
	
protected:
	void __fastcall CreateThumbnails();
	void __fastcall DestroyThumbnails();
	void __fastcall UpdateThumbnails(int oldPageNo, int newPageNo);
	void __fastcall CreateOutlines();
	void __fastcall DestroyOutlines();
	virtual void __fastcall SetPageNumber(int Value);
	virtual int __fastcall GetLeftOffset();
	void __fastcall OutlineClick(System::TObject* Sender);
	void __fastcall OutlineDrawItem(Vcl::Controls::TWinControl* Control, int Index, const System::Types::TRect &ARect, Winapi::Windows::TOwnerDrawState State);
	
public:
	__fastcall virtual TSMRPreview(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMRPreview();
	bool __fastcall FindText();
	
__published:
	__property bool ShowThumbnails = {read=FShowThumbnails, write=SetShowThumbnails, default=0};
	__property bool EnableOutlines = {read=FEnableOutlines, write=FEnableOutlines, default=0};
	__property bool ShowOutlines = {read=FShowOutlines, write=SetShowOutlines, default=0};
public:
	/* TWinControl.CreateParented */ inline __fastcall TSMRPreview(HWND ParentWindow) : TSMRPagePreview(ParentWindow) { }
	
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Smrview */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMRVIEW)
using namespace Smrview;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMRViewHPP
