﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMPrntr.pas' rev: 37.00 (Windows)

#ifndef SMPrntrHPP
#define SMPrntrHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <Vcl.Printers.hpp>
#include <Winapi.Windows.hpp>
#include <System.SysUtils.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smprntr
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMRPageMargins;
class DELPHICLASS TSMRPrinter;
class DELPHICLASS ESMRNoPrinterError;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TSMRPaperSize : unsigned char { psDefault, psLetter, psLetterSmall, psTabloid, psLedger, psLegal, psStatement, psExecutive, psA2, psA3, psA3Transverse, psA4, psA4Small, psA4Transverse, psA5, psB4, psB5, psFolio, psQuarto, psQr10X14, psQr11X17, psNote, psEnv9, psEnv10, psEnv11, psEnv12, psEnv14, psCSheet, psDSheet, psESheet, psCustom };

enum DECLSPEC_DENUM TSMRBin : unsigned char { sbDefault, sbFirst, sbUpper, sbLower, sbMiddle, sbManual, sbEnvelope, sbEnvManual, sbAuto, sbTractor, sbSmallFormat, sbLargeFormat, sbLargeCapacity, sbCassette, sbLast };

enum DECLSPEC_DENUM TSMRPrinterOrientation : unsigned char { spoDefault, spoPortrait, spoLandscape };

enum DECLSPEC_DENUM TSMRDuplex : unsigned char { sdDefault, sdNone, sdHorizontal, sdVertical };

class PASCALIMPLEMENTATION TSMRPageMargins : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	bool FByDefault;
	int FLeft;
	int FTop;
	int FRight;
	int FBottom;
	
__published:
	__property bool ByDefault = {read=FByDefault, write=FByDefault, default=1};
	__property int Left = {read=FLeft, write=FLeft, nodefault};
	__property int Top = {read=FTop, write=FTop, nodefault};
	__property int Right = {read=FRight, write=FRight, nodefault};
	__property int Bottom = {read=FBottom, write=FBottom, nodefault};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMRPageMargins() { }
	
public:
	/* TObject.Create */ inline __fastcall TSMRPageMargins() : System::Classes::TPersistent() { }
	
};


class PASCALIMPLEMENTATION TSMRPrinter : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	int FPrinterIndex;
	System::UnicodeString FPrinterName;
	System::WideChar *FDevice;
	System::WideChar *FDriver;
	System::WideChar *FPort;
	Winapi::Windows::THandle DeviceMode;
	Winapi::Windows::PDeviceMode DevMode;
	TSMRPageMargins* FMargins;
	TSMRPaperSize FPaperSize;
	int FPaperSizeWidth;
	int FPaperSizeHeight;
	TSMRPrinterOrientation FOrientation;
	TSMRBin FOutputBin;
	TSMRDuplex FDuplex;
	int FCopies;
	bool FCollate;
	void __fastcall SetPrinterIndex(int Value);
	void __fastcall SetPrinterName(System::UnicodeString Value);
	void __fastcall SetMargins(TSMRPageMargins* Value);
	void __fastcall SetPaperSize(TSMRPaperSize Value);
	void __fastcall SetOrientation(TSMRPrinterOrientation Value);
	int __fastcall GetScreenPPI();
	int __fastcall GetPaperSizeWidth();
	int __fastcall GetPaperSizeHeight();
	
public:
	__fastcall TSMRPrinter();
	__fastcall virtual ~TSMRPrinter();
	int __fastcall GetPageWidth();
	int __fastcall GetPageHeight();
	int __fastcall GetPixelsPerInchX();
	int __fastcall GetPixelsPerInchY();
	int __fastcall GetPageOffsetLeft();
	int __fastcall GetPageOffsetRight();
	int __fastcall GetPageOffsetTop();
	int __fastcall GetPageOffsetBottom();
	void __fastcall GetPrinterSettings();
	void __fastcall SetPrinterSettings(Vcl::Printers::TPrinter* FPrinter);
	
__published:
	__property int PrinterIndex = {read=FPrinterIndex, write=SetPrinterIndex, default=-1};
	__property System::UnicodeString PrinterName = {read=FPrinterName, write=SetPrinterName};
	__property TSMRPageMargins* Margins = {read=FMargins, write=SetMargins};
	__property TSMRPaperSize PaperSize = {read=FPaperSize, write=SetPaperSize, default=0};
	__property int PaperSizeWidth = {read=GetPaperSizeWidth, write=FPaperSizeWidth, nodefault};
	__property int PaperSizeHeight = {read=GetPaperSizeHeight, write=FPaperSizeHeight, nodefault};
	__property TSMRPrinterOrientation Orientation = {read=FOrientation, write=SetOrientation, default=0};
	__property TSMRBin OutputBin = {read=FOutputBin, write=FOutputBin, default=0};
	__property TSMRDuplex Duplex = {read=FDuplex, write=FDuplex, default=0};
	__property int Copies = {read=FCopies, write=FCopies, default=1};
	__property bool Collate = {read=FCollate, write=FCollate, nodefault};
};


class PASCALIMPLEMENTATION ESMRNoPrinterError : public System::Sysutils::Exception
{
	typedef System::Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ inline __fastcall ESMRNoPrinterError(const System::UnicodeString Msg) : System::Sysutils::Exception(Msg) { }
	/* Exception.CreateFmt */ inline __fastcall ESMRNoPrinterError(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High) : System::Sysutils::Exception(Msg, Args, Args_High) { }
	/* Exception.CreateRes */ inline __fastcall ESMRNoPrinterError(System::NativeUInt Ident)/* overload */ : System::Sysutils::Exception(Ident) { }
	/* Exception.CreateRes */ inline __fastcall ESMRNoPrinterError(System::PResStringRec ResStringRec)/* overload */ : System::Sysutils::Exception(ResStringRec) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMRNoPrinterError(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High) { }
	/* Exception.CreateResFmt */ inline __fastcall ESMRNoPrinterError(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High) { }
	/* Exception.CreateHelp */ inline __fastcall ESMRNoPrinterError(const System::UnicodeString Msg, int AHelpContext) : System::Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ inline __fastcall ESMRNoPrinterError(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext) : System::Sysutils::Exception(Msg, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMRNoPrinterError(System::NativeUInt Ident, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall ESMRNoPrinterError(System::PResStringRec ResStringRec, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMRNoPrinterError(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall ESMRNoPrinterError(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High, AHelpContext) { }
	/* Exception.Destroy */ inline __fastcall virtual ~ESMRNoPrinterError() { }
	
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE System::StaticArray<System::StaticArray<int, 2>, 30> constSMRPaperSizeMetrics;
extern DELPHI_PACKAGE System::StaticArray<int, 31> constSMRPaperTranslate;
extern DELPHI_PACKAGE System::StaticArray<int, 14> constSMRBinTranslate;
}	/* namespace Smprntr */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMPRNTR)
using namespace Smprntr;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMPrntrHPP
