﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMRAuto.pas' rev: 37.00 (Windows)

#ifndef SMRAutoHPP
#define SMRAutoHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <System.SysUtils.hpp>
#include <Vcl.Dialogs.hpp>
#include <Vcl.Controls.hpp>
#include <Data.DB.hpp>
#include <PrintSM.hpp>
#include <SMRTypes.hpp>
#include <Vcl.Grids.hpp>
#include <SMRDMan.hpp>
#include <System.UITypes.hpp>
#include <System.Types.hpp>
#include <SMPrntr.hpp>
#include <SMRPars.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smrauto
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMRStyle;
class DELPHICLASS TSMAutoPrint;
class DELPHICLASS TSMRACalculation;
class DELPHICLASS TSMRACalculations;
class DELPHICLASS TColumnInfo;
class DELPHICLASS TSMRAGroup;
class DELPHICLASS TSMPrintData;
class DELPHICLASS TSMPrintCustomGrid;
class DELPHICLASS TSMPrintStringGrid;
class DELPHICLASS TSMPrintText;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TImageAlign : unsigned char { iaTopPage, iaBottomPage, iaWholePage };

enum DECLSPEC_DENUM TBevels : unsigned char { bvNone, bvTopLine, bvBottomLine, bvLeftLine, bvRightLine, bvHCenterLine, bvVCenterLine, bvFrame };

enum DECLSPEC_DENUM TSMRRowStyle : unsigned char { rsNormal, rsPriceList, rsMSMoney, rsBrick, rsDesert, rsEggplant, rsLilac, rsMaple, rsMarine, rsRose, rsSpruce, rsWheat };

class PASCALIMPLEMENTATION TSMRStyle : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	bool FFixedCols;
	bool FFixedRows;
	TSMRRowStyle FRowStyle;
	System::Uitypes::TColor FOddColor;
	System::Uitypes::TColor FEvenColor;
	void __fastcall SetRowStyle(TSMRRowStyle Value);
	
public:
	__fastcall virtual TSMRStyle();
	
__published:
	__property bool FixedCols = {read=FFixedCols, write=FFixedCols, nodefault};
	__property bool FixedRows = {read=FFixedRows, write=FFixedRows, nodefault};
	__property TSMRRowStyle RowStyle = {read=FRowStyle, write=SetRowStyle, nodefault};
	__property System::Uitypes::TColor OddColor = {read=FOddColor, write=FOddColor, nodefault};
	__property System::Uitypes::TColor EvenColor = {read=FEvenColor, write=FEvenColor, nodefault};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMRStyle() { }
	
};


typedef void __fastcall (__closure *TOnDrawTextEvent)(Vcl::Graphics::TCanvas* ACanvas, System::UnicodeString &Text, const Winapi::Windows::TRect &ARect, System::Word &Flags, int &ResultHeight, bool &DrawDefault);

class PASCALIMPLEMENTATION TSMAutoPrint : public Printsm::TSMPrintComponent
{
	typedef Printsm::TSMPrintComponent inherited;
	
private:
	System::Classes::TStrings* FHeader;
	Vcl::Graphics::TFont* FHeaderFont;
	System::Classes::TStrings* FFooter;
	Vcl::Graphics::TFont* FFooterFont;
	Vcl::Graphics::TPen* FGridLine;
	bool FWordWrap;
	System::WideChar FMacroChar;
	TSMRStyle* FStyle;
	Smrtypes::TSMRHighLights* FHighLights;
	TOnDrawTextEvent FOnDrawText;
	Smrdman::TSMRDataManager* DataManager;
	void __fastcall SetHighLights(Smrtypes::TSMRHighLights* Value);
	void __fastcall SetStyle(TSMRStyle* Value);
	void __fastcall SetGridLine(Vcl::Graphics::TPen* Value);
	void __fastcall SetMacroChar(System::WideChar Value);
	bool __fastcall EvaluateMacro(System::UnicodeString &strSource, System::Classes::TAlignment &FstrAlign, TBevels &bv, System::UnicodeString &ImageFile, TImageAlign &ifAlign, bool IsPage);
	void __fastcall PrintBevel(TBevels bvlLine, int X1, int Y1, int X2, int Y2);
	void __fastcall SetHeader(System::Classes::TStrings* Value);
	void __fastcall SetHeaderFont(Vcl::Graphics::TFont* Value);
	void __fastcall SetFooter(System::Classes::TStrings* Value);
	void __fastcall SetFooterFont(Vcl::Graphics::TFont* Value);
	
protected:
	bool boolNeedPrintHeaderGrid;
	int __fastcall PrintStrings(System::Classes::TStrings* strList, Vcl::Graphics::TFont* fontForPrint, bool boolCalc, bool IsPage);
	int __fastcall SMRDrawText(Vcl::Graphics::TCanvas* ACanvas, System::UnicodeString Text, const Winapi::Windows::TRect &ARect, System::Word Flags);
	
public:
	__fastcall virtual TSMAutoPrint(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMAutoPrint();
	virtual void __fastcall NewPage(bool isNewBar);
	__property Vcl::Graphics::TPen* GridLine = {read=FGridLine, write=SetGridLine};
	
__published:
	__property TSMRStyle* Style = {read=FStyle, write=SetStyle};
	__property System::WideChar MacroChar = {read=FMacroChar, write=SetMacroChar, nodefault};
	__property bool WordWrap = {read=FWordWrap, write=FWordWrap, nodefault};
	__property System::Classes::TStrings* Header = {read=FHeader, write=SetHeader};
	__property Vcl::Graphics::TFont* HeaderFont = {read=FHeaderFont, write=SetHeaderFont};
	__property System::Classes::TStrings* Footer = {read=FFooter, write=SetFooter};
	__property Vcl::Graphics::TFont* FooterFont = {read=FFooterFont, write=SetFooterFont};
	__property AnimatedStatus = {default=1};
	__property Frame;
	__property PrinterSetting;
	__property Smrtypes::TSMRHighLights* HighLights = {read=FHighLights, write=SetHighLights};
	__property OnGetVariable;
	__property TOnDrawTextEvent OnDrawText = {read=FOnDrawText, write=FOnDrawText};
};


class PASCALIMPLEMENTATION TSMRACalculation : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	System::Variant PrevValue;
	System::Variant CurValue;
	System::UnicodeString FFieldName;
	Smrtypes::TSMRCalculation* FCalculation;
	Vcl::Graphics::TFont* FFont;
	System::Classes::TAlignment FAlignment;
	bool FWordWrap;
	int FFieldColNum;
	System::UnicodeString FCaption;
	int FCaptionColNum;
	void __fastcall SetFont(Vcl::Graphics::TFont* Value);
	void __fastcall SetCalculation(Smrtypes::TSMRCalculation* Value);
	
public:
	__fastcall virtual TSMRACalculation(System::Classes::TCollection* Collection);
	__fastcall virtual ~TSMRACalculation();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	bool __fastcall ValueChanged();
	
__published:
	__property System::UnicodeString FieldName = {read=FFieldName, write=FFieldName};
	__property Smrtypes::TSMRCalculation* Calculation = {read=FCalculation, write=SetCalculation};
	__property Vcl::Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property System::UnicodeString Caption = {read=FCaption, write=FCaption};
	__property int FieldColNum = {read=FFieldColNum, write=FFieldColNum, nodefault};
	__property int CaptionColNum = {read=FCaptionColNum, write=FCaptionColNum, nodefault};
	__property System::Classes::TAlignment Alignment = {read=FAlignment, write=FAlignment, nodefault};
	__property bool WordWrap = {read=FWordWrap, write=FWordWrap, nodefault};
};


class PASCALIMPLEMENTATION TSMRACalculations : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
public:
	TSMRACalculation* operator[](int Index) { return this->Items[Index]; }
	
private:
	TSMPrintData* FSMAReport;
	TSMRACalculation* __fastcall GetCalculation(int Index);
	void __fastcall SetCalculation(int Index, TSMRACalculation* Value);
	
protected:
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	
public:
	__fastcall TSMRACalculations(TSMPrintData* SMRA);
	HIDESBASE TSMRACalculation* __fastcall Add();
	__property TSMPrintData* SMAReport = {read=FSMAReport};
	__property TSMRACalculation* Items[int Index] = {read=GetCalculation, write=SetCalculation/*, default*/};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TSMRACalculations() { }
	
};


enum DECLSPEC_DENUM TColumnSource : unsigned char { csDBGrid, csDataSet };

class PASCALIMPLEMENTATION TColumnInfo : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString FieldName;
	System::UnicodeString Caption;
	System::Classes::TAlignment Alignment;
	System::Classes::TAlignment HeaderAlignment;
	int Position;
	int Width;
	bool WordWrap;
	bool IsFixed;
	Vcl::Graphics::TFont* DataFont;
	Vcl::Graphics::TFont* TitleFont;
	__fastcall virtual TColumnInfo();
	__fastcall virtual ~TColumnInfo();
};


class PASCALIMPLEMENTATION TSMRAGroup : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString FieldsList;
	System::Variant PrevValue;
	System::Variant CurValue;
	bool __fastcall ValueChanged();
public:
	/* TObject.Create */ inline __fastcall TSMRAGroup() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TSMRAGroup() { }
	
};


enum DECLSPEC_DENUM TPrintRecNo : unsigned char { rnNone, rnFirstCol, rnFirstColOnEachBar };

typedef void __fastcall (__closure *TSMRGetNextSelected)(System::TObject* Sender, int Index, Data::Db::TBookmark &Selected);

typedef void __fastcall (__closure *TSMRGetSelectedCount)(System::TObject* Sender, System::LongInt &Count);

class PASCALIMPLEMENTATION TSMPrintData : public TSMAutoPrint
{
	typedef TSMAutoPrint inherited;
	
private:
	int FRecNo;
	int FGapHorizontal;
	int FGapVertical;
	bool FIsWWDBGrid;
	bool FIsTMSDBGrid;
	Vcl::Controls::TCustomControl* FDBGrid;
	Data::Db::TDataSet* FDataSet;
	bool FSelectedRecord;
	TPrintRecNo FPrintRecNo;
	bool FAutoFit;
	bool FAutoFitColumnWidth;
	TColumnSource FColumnSource;
	System::Classes::TList* FPosition;
	bool FWordWrapHeader;
	bool FBlankIfZero;
	TSMRACalculations* FCalculations;
	System::Classes::TList* Groups;
	int intStartColumn;
	int intEndColumn;
	int intMaxPageWidth;
	TSMRGetNextSelected FOnGetNextSelected;
	TSMRGetSelectedCount FOnGetSelectedCount;
	void __fastcall ReadCalculations(System::Classes::TReader* Reader);
	void __fastcall WriteCalculations(System::Classes::TWriter* Writer);
	void __fastcall SetCalculations(TSMRACalculations* Value);
	Vcl::Controls::TCustomControl* __fastcall GetDBGrid();
	void __fastcall SetDBGrid(Vcl::Controls::TCustomControl* AValue);
	Data::Db::TDataSet* __fastcall GetDataSet();
	void __fastcall SetDataSet(Data::Db::TDataSet* AValue);
	bool __fastcall PrintableField(Data::Db::TField* Field);
	double __fastcall GetAutoFitCoef();
	int __fastcall GetMaxSize(bool boolWH, bool IsRecord, int intStart, int intEnd);
	int __fastcall GetMaxColumn(int intStart, int intPageWidth);
	void __fastcall FillColumnInfo();
	int __fastcall PrintHeaderGrid(int intMaxWidth);
	int __fastcall PrintRecord(int intMaxWidth, int intMaxHeight);
	int __fastcall GetGroupsMaxSize();
	int __fastcall PrintGroups(Data::Db::TDataSet* ds, int intMaxWidth, int intMaxHeight);
	void __fastcall ClearGroups();
	void __fastcall AddGroup(TSMRACalculation* calc);
	void __fastcall FillGroups();
	TSMRAGroup* __fastcall GetGroup(System::UnicodeString FieldName);
	bool __fastcall UpdateGroupValue(Data::Db::TDataSet* ds, bool IsHeader);
	void __fastcall ResetGroupValue();
	void __fastcall ResetPrintedValues(Smrtypes::TResetType RType, System::UnicodeString strGroupName);
	
protected:
	virtual void __fastcall Notification(System::Classes::TComponent* AComponent, System::Classes::TOperation Operation);
	Data::Db::TBookmark __fastcall GetNextSelected(int i);
	int __fastcall GetSelectedCount();
	System::UnicodeString __fastcall GetFieldStr(Data::Db::TField* curField);
	virtual void __fastcall PrepareReport();
	virtual void __fastcall DefineProperties(System::Classes::TFiler* Filer);
	DYNAMIC TSMRACalculations* __fastcall CreateCalculations();
	
public:
	__fastcall virtual TSMPrintData(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMPrintData();
	virtual void __fastcall NewPage(bool isNewBar);
	__property bool IsWWDBGrid = {read=FIsWWDBGrid, nodefault};
	__property bool IsTMSDBGrid = {read=FIsTMSDBGrid, nodefault};
	
__published:
	__property TSMRACalculations* Calculations = {read=FCalculations, write=SetCalculations};
	__property bool BlankIfZero = {read=FBlankIfZero, write=FBlankIfZero, nodefault};
	__property int GapHorizontal = {read=FGapHorizontal, write=FGapHorizontal, nodefault};
	__property int GapVertical = {read=FGapVertical, write=FGapVertical, nodefault};
	__property GridLine;
	__property Vcl::Controls::TCustomControl* DBGrid = {read=GetDBGrid, write=SetDBGrid};
	__property Data::Db::TDataSet* DataSet = {read=GetDataSet, write=SetDataSet};
	__property bool SelectedRecord = {read=FSelectedRecord, write=FSelectedRecord, nodefault};
	__property TPrintRecNo PrintRecNo = {read=FPrintRecNo, write=FPrintRecNo, nodefault};
	__property bool AutoFit = {read=FAutoFit, write=FAutoFit, default=0};
	__property bool AutoFitColumnWidth = {read=FAutoFitColumnWidth, write=FAutoFitColumnWidth, default=0};
	__property TColumnSource ColumnSource = {read=FColumnSource, write=FColumnSource, nodefault};
	__property bool WordWrapHeader = {read=FWordWrapHeader, write=FWordWrapHeader, nodefault};
	__property Font;
	__property TSMRGetNextSelected OnGetNextSelected = {read=FOnGetNextSelected, write=FOnGetNextSelected};
	__property TSMRGetSelectedCount OnGetSelectedCount = {read=FOnGetSelectedCount, write=FOnGetSelectedCount};
	__property Options = {default=1};
};


class PASCALIMPLEMENTATION TSMPrintCustomGrid : public TSMAutoPrint
{
	typedef TSMAutoPrint inherited;
	
private:
	int FGapHorizontal;
	int FGapVertical;
	bool FAutoFit;
	int intStartColumn;
	int intEndColumn;
	int intMaxPageWidth;
	double __fastcall GetAutoFitCoef();
	virtual int __fastcall GetMaxSize(bool boolWH, int intRow, int intStart, int intEnd);
	virtual int __fastcall GetMaxColumn(int intStart, int intPageWidth);
	virtual int __fastcall PrintHeaderGrid(int intMaxWidth);
	virtual int __fastcall PrintRow(int intRow, int intMaxWidth, int intMaxHeight);
	
protected:
	System::Classes::TList* FPosition;
	virtual bool __fastcall PrintHorizontalLines();
	virtual bool __fastcall PrintVerticalLines();
	virtual void __fastcall CheckAvailableGrid();
	virtual int __fastcall GetColCount();
	virtual int __fastcall GetRowCount();
	virtual int __fastcall GetFixedColCount();
	virtual int __fastcall GetFixedRowCount();
	virtual System::UnicodeString __fastcall GetCellText(int Col, int Row);
	virtual System::Classes::TAlignment __fastcall GetCellAlignment(int Col, int Row);
	virtual Vcl::Graphics::TFont* __fastcall GetControlFont(int Col, int Row);
	virtual void __fastcall FillColumnInfo();
	virtual void __fastcall PrepareReport();
	
public:
	__fastcall virtual TSMPrintCustomGrid(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMPrintCustomGrid();
	
__published:
	__property int GapHorizontal = {read=FGapHorizontal, write=FGapHorizontal, nodefault};
	__property int GapVertical = {read=FGapVertical, write=FGapVertical, nodefault};
	__property GridLine;
	__property bool AutoFit = {read=FAutoFit, write=FAutoFit, nodefault};
};


class PASCALIMPLEMENTATION TSMPrintStringGrid : public TSMPrintCustomGrid
{
	typedef TSMPrintCustomGrid inherited;
	
private:
	Vcl::Grids::TStringGrid* FStringGrid;
	
protected:
	virtual void __fastcall Notification(System::Classes::TComponent* AComponent, System::Classes::TOperation Operation);
	virtual bool __fastcall PrintHorizontalLines();
	virtual bool __fastcall PrintVerticalLines();
	virtual void __fastcall CheckAvailableGrid();
	virtual int __fastcall GetColCount();
	virtual int __fastcall GetRowCount();
	virtual int __fastcall GetFixedColCount();
	virtual int __fastcall GetFixedRowCount();
	virtual System::UnicodeString __fastcall GetCellText(int Col, int Row);
	virtual Vcl::Graphics::TFont* __fastcall GetControlFont(int Col, int Row);
	virtual void __fastcall FillColumnInfo();
	
public:
	__fastcall virtual TSMPrintStringGrid(System::Classes::TComponent* AOwner);
	
__published:
	__property Vcl::Grids::TStringGrid* StringGrid = {read=FStringGrid, write=FStringGrid};
public:
	/* TSMPrintCustomGrid.Destroy */ inline __fastcall virtual ~TSMPrintStringGrid() { }
	
};


enum DECLSPEC_DENUM TCodePage : unsigned char { cpANSI, cpASCII };

class PASCALIMPLEMENTATION TSMPrintText : public TSMAutoPrint
{
	typedef TSMAutoPrint inherited;
	
private:
	TCodePage FCodePage;
	System::UnicodeString FFileName;
	int __fastcall PrintLine(System::UnicodeString strForPrint, int intMaxWidth);
	int __fastcall GetStartChar(System::UnicodeString str, int intMaxWidth);
	
protected:
	virtual void __fastcall PrepareReport();
	
public:
	__fastcall virtual TSMPrintText(System::Classes::TComponent* AOwner);
	
__published:
	__property TCodePage CodePage = {read=FCodePage, write=FCodePage, nodefault};
	__property System::UnicodeString FileName = {read=FFileName, write=FFileName};
	__property Font;
public:
	/* TSMAutoPrint.Destroy */ inline __fastcall virtual ~TSMPrintText() { }
	
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE System::StaticArray<int, 3> AlignFlags;
extern DELPHI_PACKAGE System::StaticArray<System::Word, 2> WordWraps;
extern DELPHI_PACKAGE bool __fastcall PropIsDBGrid(System::Classes::TComponent* comp, bool &IsWWDBGrid, bool &IsTMSDBGrid);
extern DELPHI_PACKAGE Data::Db::TDataSet* __fastcall GetPropAsDataSet(System::Classes::TComponent* comp);
extern DELPHI_PACKAGE System::Classes::TList* __fastcall GetPropAsSelectedList(System::Classes::TComponent* comp);
extern DELPHI_PACKAGE System::Classes::TCollection* __fastcall GetPropAsColumns(System::Classes::TComponent* comp);
extern DELPHI_PACKAGE System::Classes::TStrings* __fastcall GetPropAsSelected(System::Classes::TComponent* comp);
extern DELPHI_PACKAGE void __fastcall FillGridList(System::Classes::TComponent* comp, System::Classes::TStrings* lst);
}	/* namespace Smrauto */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMRAUTO)
using namespace Smrauto;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMRAutoHPP
