﻿// CodeGear C++Builder
// Copyright (c) 1995, 2024 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMWZipFile.pas' rev: 36.00 (Windows)

#ifndef SMWZipFileHPP
#define SMWZipFileHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <System.Types.hpp>
#include <System.Classes.hpp>
#include <System.SysUtils.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smwzipfile
{
//-- forward type declarations -----------------------------------------------
struct TCommonFileHeader;
struct TFileHeader;
struct TEndOfCentralDir;
class DELPHICLASS TLocalFile;
class DELPHICLASS TLocalFiles;
class DELPHICLASS TZipArchive;
class DELPHICLASS EZipFileCRCError;
//-- type declarations -------------------------------------------------------
#pragma pack(push,1)
struct DECLSPEC_DRECORD TCommonFileHeader
{
public:
	System::Word VersionNeededToExtract;
	System::Word GeneralPurposeBitFlag;
	System::Word CompressionMethod;
	unsigned LastModFileTimeDate;
	unsigned Crc32;
	unsigned CompressedSize;
	unsigned UncompressedSize;
	System::Word FilenameLength;
	System::Word ExtraFieldLength;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TFileHeader
{
public:
	unsigned CentralFileHeaderSignature;
	System::Word VersionMadeBy;
	TCommonFileHeader CommonFileHeader;
	System::Word FileCommentLength;
	System::Word DiskNumberStart;
	System::Word InternalFileAttributes;
	unsigned ExternalFileAttributes;
	unsigned RelativeOffsetOfLocalHeader;
	System::AnsiString FileName;
	System::AnsiString ExtraField;
	System::AnsiString FileComment;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TEndOfCentralDir
{
public:
	unsigned EndOfCentralDirSignature;
	System::Word NumberOfThisDisk;
	System::Word NumberOfTheDiskWithTheStart;
	System::Word TotalNumberOfEntriesOnThisDisk;
	System::Word TotalNumberOfEntries;
	unsigned SizeOfTheCentralDirectory;
	unsigned OffsetOfStartOfCentralDirectory;
	System::Word ZipfileCommentLength;
};
#pragma pack(pop)


#pragma pack(push,4)
class PASCALIMPLEMENTATION TLocalFile : public System::Classes::TCollectionItem
{
	typedef System::Classes::TCollectionItem inherited;
	
private:
	unsigned FLocalFileHeaderSignature;
	TCommonFileHeader FCommonFileHeader;
	System::AnsiString FFileName;
	System::AnsiString FExtraField;
	System::AnsiString FCompressedData;
	unsigned FCentralFileHeaderSignature;
	System::Word FCentralVersionMadeBy;
	TCommonFileHeader FCentralCommonFileHeader;
	System::Word FCentralFileCommentLength;
	System::Word FCentralDiskNumberStart;
	System::Word FCentralInternalFileAttributes;
	unsigned FCentralExternalFileAttributes;
	unsigned FCentralRelativeOffsetOfLocalHeader;
	System::AnsiString FCentralFileName;
	System::AnsiString FCentralExtraField;
	System::AnsiString FCentralFileComment;
	
protected:
	bool FHeaderRead;
	
public:
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	void __fastcall LoadFileFromStream(System::Classes::TStream* AStream);
	void __fastcall LoadCentralDirectoryFromStream(System::Classes::TStream* AStream);
	__property unsigned LocalFileHeaderSignature = {read=FLocalFileHeaderSignature, write=FLocalFileHeaderSignature, nodefault};
	__property TCommonFileHeader CommonFileHeader = {read=FCommonFileHeader, write=FCommonFileHeader};
	__property System::AnsiString FileName = {read=FFileName, write=FFileName};
	__property System::AnsiString ExtraField = {read=FExtraField, write=FExtraField};
	__property System::AnsiString CompressedData = {read=FCompressedData, write=FCompressedData};
	__property unsigned CentralFileHeaderSignature = {read=FCentralFileHeaderSignature, write=FCentralFileHeaderSignature, nodefault};
	__property System::Word CentralVersionMadeBy = {read=FCentralVersionMadeBy, write=FCentralVersionMadeBy, nodefault};
	__property TCommonFileHeader CentralCommonFileHeader = {read=FCentralCommonFileHeader, write=FCentralCommonFileHeader};
	__property System::Word CentralFileCommentLength = {read=FCentralFileCommentLength, write=FCentralFileCommentLength, nodefault};
	__property System::Word CentralDiskNumberStart = {read=FCentralDiskNumberStart, write=FCentralDiskNumberStart, nodefault};
	__property System::Word CentralInternalFileAttributes = {read=FCentralInternalFileAttributes, write=FCentralInternalFileAttributes, nodefault};
	__property unsigned CentralExternalFileAttributes = {read=FCentralExternalFileAttributes, write=FCentralExternalFileAttributes, nodefault};
	__property unsigned CentralRelativeOffsetOfLocalHeader = {read=FCentralRelativeOffsetOfLocalHeader, write=FCentralRelativeOffsetOfLocalHeader, nodefault};
	__property System::AnsiString CentralFileName = {read=FCentralFileName, write=FCentralFileName};
	__property System::AnsiString CentralExtraField = {read=FCentralExtraField, write=FCentralExtraField};
	__property System::AnsiString CentralFileComment = {read=FCentralFileComment, write=FCentralFileComment};
public:
	/* TCollectionItem.Create */ inline __fastcall virtual TLocalFile(System::Classes::TCollection* Collection) : System::Classes::TCollectionItem(Collection) { }
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TLocalFile() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TLocalFiles : public System::Classes::TCollection
{
	typedef System::Classes::TCollection inherited;
	
public:
	TLocalFile* operator[](int Index) { return this->Items[Index]; }
	
private:
	System::Classes::TComponent* FControl;
	TLocalFile* __fastcall GetLocalFile(int Index);
	void __fastcall SetLocalFile(int Index, TLocalFile* Value);
	
protected:
	DYNAMIC System::Classes::TPersistent* __fastcall GetOwner();
	
public:
	__fastcall TLocalFiles(System::Classes::TComponent* ACntrl);
	HIDESBASE TLocalFile* __fastcall Add();
	__property System::Classes::TComponent* OwnerControl = {read=FControl};
	__property TLocalFile* Items[int Index] = {read=GetLocalFile, write=SetLocalFile/*, default*/};
public:
	/* TCollection.Destroy */ inline __fastcall virtual ~TLocalFiles() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TZipArchive : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	TLocalFiles* Files;
	TEndOfCentralDir EndOfCentralDirectory;
	System::UnicodeString ZipFileComment;
	System::AnsiString __fastcall GetUncompressed(int i);
	int __fastcall GetCount();
	
public:
	__fastcall virtual TZipArchive(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TZipArchive();
	int __fastcall GetIndexByFileName(const System::UnicodeString AFileName);
	System::UnicodeString __fastcall DecompressFileName(const System::UnicodeString AFileName);
	void __fastcall LoadFromFile(const System::UnicodeString FileName);
	void __fastcall LoadFromStream(System::Classes::TStream* const ZipFileStream);
	void __fastcall GetFileNames(System::Classes::TStrings* lstFiles);
	__property int Count = {read=GetCount, nodefault};
	__property System::AnsiString Uncompressed[int i] = {read=GetUncompressed};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION EZipFileCRCError : public System::Sysutils::Exception
{
	typedef System::Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ inline __fastcall EZipFileCRCError(const System::UnicodeString Msg) : System::Sysutils::Exception(Msg) { }
	/* Exception.CreateFmt */ inline __fastcall EZipFileCRCError(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High) : System::Sysutils::Exception(Msg, Args, Args_High) { }
	/* Exception.CreateRes */ inline __fastcall EZipFileCRCError(System::NativeUInt Ident)/* overload */ : System::Sysutils::Exception(Ident) { }
	/* Exception.CreateRes */ inline __fastcall EZipFileCRCError(System::PResStringRec ResStringRec)/* overload */ : System::Sysutils::Exception(ResStringRec) { }
	/* Exception.CreateResFmt */ inline __fastcall EZipFileCRCError(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High) { }
	/* Exception.CreateResFmt */ inline __fastcall EZipFileCRCError(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High) { }
	/* Exception.CreateHelp */ inline __fastcall EZipFileCRCError(const System::UnicodeString Msg, int AHelpContext) : System::Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ inline __fastcall EZipFileCRCError(const System::UnicodeString Msg, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext) : System::Sysutils::Exception(Msg, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall EZipFileCRCError(System::NativeUInt Ident, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, AHelpContext) { }
	/* Exception.CreateResHelp */ inline __fastcall EZipFileCRCError(System::PResStringRec ResStringRec, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall EZipFileCRCError(System::PResStringRec ResStringRec, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(ResStringRec, Args, Args_High, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ inline __fastcall EZipFileCRCError(System::NativeUInt Ident, const System::TVarRec *Args, const System::NativeInt Args_High, int AHelpContext)/* overload */ : System::Sysutils::Exception(Ident, Args, Args_High, AHelpContext) { }
	/* Exception.Destroy */ inline __fastcall virtual ~EZipFileCRCError() { }
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
}	/* namespace Smwzipfile */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMWZIPFILE)
using namespace Smwzipfile;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMWZipFileHPP
